/*
 * Decompiled with CFR 0.152.
 */
package cib.cad;

import cib.cad.kernel.Kernel;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class Instance {
    public static final String VERSION_ROBUSTNESS_ALFA = "a";
    public static final String VERSION_ROBUSTNESS_BETA = "b";
    public static final String VERSION_ROBUSTNESS_RELEASE_CANDIDATE = "RC";
    public static final String VERSION_ROBUSTNESS_RELEASE = "";
    public static String VERSION_MAJOR = "4";
    public static String VERSION_MINOR = "0";
    public static String VERSION_ROBUSTNESS = "RC";
    public static String VERSION_BUILD = "6";
    public static final String VERSION_COMPLETED = "";
    public static final String VERSION_INTERMEDIATE = " intermediate";
    public static final String VERSION_STRING = String.valueOf(VERSION_MAJOR) + "." + VERSION_MINOR + " " + VERSION_ROBUSTNESS + VERSION_BUILD;
    public static int JRE_VERSION = 1;
    public static int JRE_SUB_VERSION = 6;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Kernel kernel = Instance.createKernel(args);
        kernel.begin();
    }

    static Kernel createKernel(String[] args) throws IOException {
        System.out.println("Usage: java cib.cad.Instance <doc> <options>");
        System.out.println("where <doc> is the path name of a document to load and possible <options> include:");
        System.out.println("    -i <file>          Define an alternative property file");
        System.out.println("    -p <name>=<value>  Define a Property (multiple usage supported)");
        System.out.println("    -c <commands>      Define a CADEMIA start command (multiple usage supported)");
        System.out.println("    -cp <;-separated-list> or");
        System.out.println("    -classpath <;-separated-list>\n                       Add classpath as a list of directories and JAR files with an arbitrary extension");
        System.out.println("    -plugin <;-separated-list>\n                       Add plugins as a list of directories and Plugin files with an arbitrary extension. All files with extension cademia_plugin contained in the directories are loaded as Plugins");
        System.out.println("Got " + args.length + " arguments");
        int i = 0;
        while (i < args.length) {
            System.out.println("\targs[" + i + "] = " + args[i]);
            ++i;
        }
        Instance.checkJavaEnvironment();
        File propertiesFile = Instance.getPropertiesFile(args);
        Properties props = Instance.getCmdLineProperties(args);
        String cmds = Instance.getCmdLineCommands(args);
        return new Kernel(propertiesFile, props, cmds);
    }

    private static void checkJavaEnvironment() {
        String os;
        Properties props = System.getProperties();
        String javaVersion = props.getProperty("java.version");
        System.out.println("CADEMIA requests Java version " + JRE_VERSION + "." + JRE_SUB_VERSION + ", installed Java version is " + javaVersion);
        StringTokenizer st = new StringTokenizer(javaVersion, ".");
        try {
            int i = Integer.parseInt(st.nextToken());
            int j = Integer.parseInt(st.nextToken());
            if (i < JRE_VERSION || j < JRE_SUB_VERSION) {
                System.err.println("Java version obsolete. CADEMIA requests Java version " + JRE_VERSION + "." + JRE_SUB_VERSION + ", installed Java version is " + javaVersion + ". CADEMIA cannot be launched.");
                JOptionPane.showMessageDialog(null, "Java version obsolete. CADEMIA requests Java version " + JRE_VERSION + "." + JRE_SUB_VERSION + ",\ninstalled Java version is " + javaVersion + ". CADEMIA cannot be launched.", "CADEMIA", 0);
                System.exit(1);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing java.version, exiting CADEMIA");
            System.exit(2);
        }
        if ((os = props.getProperty("os.name").toLowerCase()).startsWith("windows")) {
            props.setProperty("sun.java2d.d3d", "false");
        }
    }

    private static File getPropertiesFile(String[] args) throws IOException {
        File file = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-i")) {
                file = new File(args[i + 1]);
                break;
            }
            ++i;
        }
        if (file != null) {
            if (!file.exists()) {
                System.out.print("Property file " + file + " does not exist. ");
                System.out.print("It will be created...");
                if (file.createNewFile()) {
                    System.out.println("Ok");
                } else {
                    System.out.println("Failed");
                    file = null;
                }
            } else if (!file.canRead()) {
                System.out.println("Can't read property file " + file);
                file = null;
            } else if (!file.canWrite()) {
                System.out.println("Can't write to property file " + file);
                file = null;
            }
        }
        if (file == null) {
            file = new File(System.getProperty("user.home"), "cademia.ini");
            file.createNewFile();
        }
        return file;
    }

    private static Properties getCmdLineProperties(String[] args) {
        Properties props = new Properties();
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-p") && ++i < args.length) {
                int indexEq = args[i].indexOf(61);
                if (indexEq < 1) {
                    System.err.println(String.valueOf(args[i]) + ": Invalid syntax");
                } else {
                    props.setProperty(args[i].substring(0, indexEq), args[i].substring(indexEq + 1, args[i].length()));
                }
            }
            ++i;
        }
        return props;
    }

    private static String getCmdLineCommands(String[] args) {
        String cmds = "";
        int i = 0;
        while (i < args.length) {
            if ((args[i].equalsIgnoreCase("-cp") || args[i].equalsIgnoreCase("-classpath")) && ++i < args.length) {
                cmds = String.valueOf(cmds) + "addclasspath " + args[i] + ";";
            }
            ++i;
        }
        i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-plugin") && ++i < args.length) {
                cmds = String.valueOf(cmds) + "addplugin " + args[i] + ";";
            }
            ++i;
        }
        String doc = Instance.getFileToLoad(args);
        if (doc.length() != 0) {
            cmds = String.valueOf(cmds) + "macroload \"" + doc + "\";";
        }
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equalsIgnoreCase("-c") && ++i2 < args.length) {
                cmds = String.valueOf(cmds) + args[i2] + ";";
            }
            ++i2;
        }
        return cmds;
    }

    private static String getFileToLoad(String[] args) {
        if (args.length > 0 && !args[0].startsWith("-")) {
            return args[0].replace('\\', '/');
        }
        return "";
    }
}

