/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.DistanceFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.util.AttributedShape;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ComponentArc2D
extends ComponentAdapter
implements CtrlSegments {
    private static final long serialVersionUID = 0L;
    private int m_subVersion = 1;
    private double m_x = 0.0;
    private double m_y = 0.0;
    private double m_r = 0.0;
    private double m_phi = 0.0;
    private double m_alpha = 0.0;
    private double m_ext = 0.0;
    private transient Point2D[] t_locs = new Point2D[4];
    private static final String[] FEATURE_NAMES = new String[]{"GEOMETRY.POINT_2D", "GEOMETRY.ANGLE", "GEOMETRY.SWEEP_ANGLE", "GEOMETRY.DIAMETER", "GEOMETRY.LENGTH"};

    private double _getSpX() {
        return this.m_x;
    }

    private double _getSpY() {
        return this.m_y;
    }

    private double _getApX() {
        return this.m_r;
    }

    private double _getApY() {
        return this.m_phi;
    }

    private double _getEpX() {
        return this.m_alpha;
    }

    private double _getEpY() {
        return this.m_ext;
    }

    private void _setSpX(double val) {
        this.m_x = val;
    }

    private void _setSpY(double val) {
        this.m_y = val;
    }

    private void _setApX(double val) {
        this.m_r = val;
    }

    private void _setApY(double val) {
        this.m_phi = val;
    }

    private void _setEpX(double val) {
        this.m_alpha = val;
    }

    private void _setEpY(double val) {
        this.m_ext = val;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.m_subVersion == 0) {
            Vector2D vsp = new Vector2D(this.m_phi).scaleBy(this.m_r).add(this.m_x, this.m_y);
            Vector2D vap = new Vector2D(this.m_phi + 0.5 * this.m_alpha).scaleBy(this.m_r).add(this.m_x, this.m_y);
            Vector2D vep = new Vector2D(this.m_phi + this.m_alpha).scaleBy(this.m_r).add(this.m_x, this.m_y);
            this._setSpX(vsp.x);
            this._setSpY(vsp.y);
            this._setApX(vap.x);
            this._setApY(vap.y);
            this._setEpX(vep.x);
            this._setEpY(vep.y);
            this.m_subVersion = 1;
        }
    }

    public ComponentArc2D() {
        this.setArc(0.0, 0.0, 1.0, 0.0, Math.PI * 2);
    }

    public ComponentArc2D(double centerX, double centerY, double radius, double startAngle, double sweepAngle) {
        this.setArc(centerX, centerY, radius, startAngle, sweepAngle);
    }

    public ComponentArc2D(Point2D sp, Point2D ap, Point2D ep) {
        this.setArc(sp, ap, ep);
    }

    public ComponentArc2D(double spx, double spy, double apx, double apy, double epx, double epy) {
        this.setArc(new Point2D.Double(spx, spy), new Point2D.Double(apx, apy), new Point2D.Double(epx, epy));
    }

    public ComponentArc2D(Arc2D arc) {
        this.setArc(arc);
    }

    public void setArc(Point2D sp, Point2D ap, Point2D ep) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double();
        p.setLocation(sp);
        u2w.transform(p, p);
        this._setSpX(((Point2D)p).getX());
        this._setSpY(((Point2D)p).getY());
        p.setLocation(ap);
        u2w.transform(p, p);
        this._setApX(((Point2D)p).getX());
        this._setApY(((Point2D)p).getY());
        p.setLocation(ep);
        u2w.transform(p, p);
        this._setEpX(((Point2D)p).getX());
        this._setEpY(((Point2D)p).getY());
        this._notifyWasChanged();
    }

    public void setArc(double ctrX, double ctrY, double radius, double startAngle, double sweepAngle) {
        Vector2D vsp = new Vector2D(startAngle).scaleBy(radius).add(ctrX, ctrY);
        Vector2D vap = new Vector2D(startAngle + 0.5 * sweepAngle).scaleBy(radius).add(ctrX, ctrY);
        Vector2D vep = new Vector2D(startAngle + sweepAngle).scaleBy(radius).add(ctrX, ctrY);
        this.setArc(vsp, vap, vep);
    }

    public void setArc(Arc2D arc) {
        if (!Geo2D.equality(arc.getWidth(), arc.getHeight())) {
            throw new IllegalArgumentException("Not a circular arc");
        }
        double startAngle = -Math.toRadians(arc.getAngleStart());
        double sweepAngle = -Math.toRadians(arc.getAngleExtent());
        this.setArc(arc.getCenterX(), arc.getCenterY(), 0.5 * arc.getWidth(), startAngle, sweepAngle);
    }

    public Point2D getStartPoint(Point2D p) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        if (p == null) {
            p = new Point2D.Double();
        }
        p.setLocation(this._getSpX(), this._getSpY());
        return w2u.transform(p, p);
    }

    public Point2D getEndPoint(Point2D p) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        if (p == null) {
            p = new Point2D.Double();
        }
        p.setLocation(this._getEpX(), this._getEpY());
        return w2u.transform(p, p);
    }

    public Point2D getArcPoint(Point2D p) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        if (p == null) {
            p = new Point2D.Double();
        }
        p.setLocation(this._getApX(), this._getApY());
        return w2u.transform(p, p);
    }

    public Point2D centerPoint(Point2D p) {
        Arc2D arc = Geo2D.calculateArc2D(this.getStartPoint(new Point2D.Double()), this.getArcPoint(new Point2D.Double()), this.getEndPoint(new Point2D.Double()), new Arc2D.Double());
        if (arc == null) {
            return null;
        }
        if (p == null) {
            p = new Point2D.Double();
        }
        p.setLocation(arc.getCenterX(), arc.getCenterY());
        return p;
    }

    public double radius() {
        Point2D cp = this.centerPoint(new Point2D.Double());
        return cp == null ? Double.NaN : Geo2D.distance(this.centerPoint(new Point2D.Double()), this.getArcPoint(new Point2D.Double()));
    }

    public double startAngle() {
        Point2D cp = this.centerPoint(new Point2D.Double());
        if (cp == null) {
            return Double.NaN;
        }
        Point2D sp = this.getStartPoint(new Point2D.Double());
        Vector2D vec = new Vector2D(cp, sp);
        try {
            return Vector2D.X_UNIT.getAngleCCW(vec);
        }
        catch (NullVectorException e) {
            return 0.0;
        }
    }

    public double sweepAngle() {
        Point2D cp = this.centerPoint(new Point2D.Double());
        if (cp == null) {
            return Double.NaN;
        }
        Vector2D vsp = new Vector2D(cp, this.getStartPoint(new Point2D.Double()));
        Vector2D vap = new Vector2D(cp, this.getArcPoint(new Point2D.Double()));
        Vector2D vep = new Vector2D(cp, this.getEndPoint(new Point2D.Double()));
        try {
            double sa = vsp.getAngleCCW(vap);
            double se = vsp.getAngleCCW(vep);
            return se >= sa ? se : se - Math.PI - Math.PI;
        }
        catch (NullVectorException e) {
            return 0.0;
        }
    }

    @Override
    public void assign(Component rhs) {
        ComponentArc2D rhsComp = (ComponentArc2D)rhs;
        this.m_subVersion = rhsComp.m_subVersion;
        this.m_x = rhsComp.m_x;
        this.m_y = rhsComp.m_y;
        this.m_r = rhsComp.m_r;
        this.m_phi = rhsComp.m_phi;
        this.m_alpha = rhsComp.m_alpha;
        this.m_ext = rhsComp.m_ext;
        super.assign(rhs);
    }

    @Override
    public void transformBy(AffineTransform mat) {
        Point2D sp = this.getStartPoint(new Point2D.Double());
        mat.transform(sp, sp);
        Point2D ap = this.getArcPoint(new Point2D.Double());
        mat.transform(ap, ap);
        Point2D ep = this.getEndPoint(new Point2D.Double());
        mat.transform(ep, ep);
        this.setArc(sp, ap, ep);
    }

    private AttributedShape getShape() {
        Point2D sp = this.getStartPoint(new Point2D.Double());
        Point2D ep = this.getEndPoint(new Point2D.Double());
        Arc2D arc = Geo2D.calculateArc2D(sp, this.getArcPoint(new Point2D.Double()), ep, new Arc2D.Double());
        return arc != null ? this._attributeShape(new AttributedShape(arc)) : this._attributeShape(new AttributedShape(new Line2D.Double(sp, ep)));
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this.getShape());
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name >= 0 && name <= 3;
    }

    @Override
    public int getControlPointChildrenCount(int name) {
        switch (name) {
            case 0: {
                return 3;
            }
            case 1: 
            case 2: 
            case 3: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getControlPointChild(int name, int iChild) {
        switch (name) {
            case 0: {
                switch (iChild) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        switch (name) {
            case 0: {
                Point2D p = this.centerPoint(new Point2D.Double());
                if (p == null) {
                    Point2D sp = this.getStartPoint(new Point2D.Double());
                    Point2D ep = this.getEndPoint(new Point2D.Double());
                    p = new Point2D.Double(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
                }
                return p;
            }
            case 1: {
                return this.getStartPoint(new Point2D.Double());
            }
            case 2: {
                return this.getEndPoint(new Point2D.Double());
            }
            case 3: {
                return this.getArcPoint(new Point2D.Double());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getCtrlType(int name) {
        switch (name) {
            case 0: {
                return 64;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getVertexSegmentCount(int vtxName) {
        switch (vtxName) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getVertexSegmentAt(int vtxName, int iSegment) {
        switch (vtxName) {
            case 1: 
            case 2: {
                if (iSegment != 0) break;
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentVertex1(int segName) {
        switch (segName) {
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentVertex2(int segName) {
        switch (segName) {
            case 0: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentPointCount(int segName) {
        switch (segName) {
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentPointAt(int segName, int iPoint) {
        switch (segName) {
            case 0: {
                if (iPoint != 0) break;
                return 3;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentCrds(int segName, double[] crds) {
        switch (segName) {
            case 0: {
                Point2D.Double p = new Point2D.Double();
                this.getStartPoint(p);
                crds[0] = ((Point2D)p).getX();
                crds[1] = ((Point2D)p).getY();
                this.getArcPoint(p);
                crds[2] = ((Point2D)p).getX();
                crds[3] = ((Point2D)p).getY();
                this.getEndPoint(p);
                crds[4] = ((Point2D)p).getX();
                crds[5] = ((Point2D)p).getY();
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setSegmentCrds(int segName, double[] crds) throws UnsupportedOperationException {
        switch (segName) {
            case 0: {
                this.setArc(new Point2D.Double(crds[0], crds[1]), new Point2D.Double(crds[2], crds[3]), new Point2D.Double(crds[4], crds[5]));
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPointStarts() {
        if (this.t_locs == null) {
            this.t_locs = new Point2D[4];
        }
        int i = 0;
        while (i < this.t_locs.length) {
            this.t_locs[i] = null;
            ++i;
        }
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        if (name < 0 || name > 3) {
            throw new IllegalArgumentException();
        }
        this.t_locs[name] = pnt;
    }

    @Override
    public void setControlPointEnds() {
        if (this.t_locs[0] != null) {
            Point2D p = this.getControlPoint(0);
            double dx = this.t_locs[0].getX() - p.getX();
            double dy = this.t_locs[0].getY() - p.getY();
            int i = 1;
            while (i < 4) {
                this.t_locs[i] = this.getControlPoint(i);
                this.t_locs[i].setLocation(this.t_locs[i].getX() + dx, this.t_locs[i].getY() + dy);
                ++i;
            }
        }
        Point2D sp = this.t_locs[1] == null ? this.getControlPoint(1) : this.t_locs[1];
        Point2D ep = this.t_locs[2] == null ? this.getControlPoint(2) : this.t_locs[2];
        Point2D ap = this.t_locs[3] == null ? this.getControlPoint(3) : this.t_locs[3];
        this.setArc(sp, ap, ep);
    }

    @Override
    public void setCtrlType(int type, int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int split(int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 4;
            }

            @Override
            protected Point2D _get(int index) {
                return ComponentArc2D.this.getControlPoint(index);
            }

            @Override
            protected void _set(int index, Point2D p) {
                ComponentArc2D.this.setControlPoint(p, index);
            }
        };
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            Point2D cp = this.centerPoint(new Point2D.Double());
            if (cp == null) {
                Point2DFeature f = new Point2DFeature(FEATURE_NAMES[0], new Point2D.Double(Double.NaN, Double.NaN));
                f.setChangeable(false);
                return f;
            }
            return new Point2DFeature(FEATURE_NAMES[0], cp);
        }
        if (name.equals(FEATURE_NAMES[1])) {
            double val = this.startAngle();
            AngleFeature f = new AngleFeature(FEATURE_NAMES[1], val);
            if (Double.isNaN(val)) {
                f.setChangeable(false);
            }
            return f;
        }
        if (name.equals(FEATURE_NAMES[2])) {
            double val = this.sweepAngle();
            AngleFeature f = new AngleFeature(FEATURE_NAMES[2], val);
            if (Double.isNaN(val)) {
                f.setChangeable(false);
            }
            return f;
        }
        if (name.equals(FEATURE_NAMES[3])) {
            double r = this.radius();
            DistanceFeature f = new DistanceFeature(FEATURE_NAMES[3], r + r);
            if (Double.isNaN(r)) {
                f.setChangeable(false);
            }
            return f;
        }
        if (name.equals(FEATURE_NAMES[4])) {
            double r = this.radius();
            double angle = Math.abs(this.sweepAngle());
            DistanceFeature f = new DistanceFeature(FEATURE_NAMES[4], r * angle);
            if (Double.isNaN(r)) {
                f.setChangeable(false);
            }
            return f;
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        Point2D center = this.centerPoint(new Point2D.Double());
        double radius = this.radius();
        double startAngle = this.startAngle();
        double sweepAngle = this.sweepAngle();
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            center = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[1])) {
            startAngle = (Double)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[2])) {
            sweepAngle = (Double)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[3])) {
            radius = 0.5 * (Double)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[4])) {
            sweepAngle = Math.signum(sweepAngle) * (Double)feature.getValue() / radius;
        } else {
            super.setFeature(feature);
            return;
        }
        this.setArc(center.getX(), center.getY(), radius, startAngle, sweepAngle);
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentArc2D.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

