/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.ChoiceFeature;
import cib.cad.db.feature.DoubleFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.cad.db.feature.StringFeature;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

public class ComponentDimSingle
extends ComponentAdapter {
    private static final long serialVersionUID = 0L;
    public static final String DEFAULT_FREE_FORMAT = "#,##0.00##";
    public static final String DEFAULT_FREE_TEXT = "null";
    public static final int TERMINATOR_SLASH = 0;
    public static final int TERMINATOR_HOLLOW_CIRCLE = 1;
    public static final int TERMINATOR_FILLED_CIRCLE = 2;
    public static final int TERMINATOR_HOLLOW_ARROW = 3;
    public static final int TERMINATOR_FILLED_ARROW = 4;
    public static final List<String> TERMINATORS = new ArrayList<String>();
    public static final int TEXT_JUST_CENTER = 0;
    public static final int TEXT_JUST_P1 = 1;
    public static final int TEXT_JUST_P2 = 2;
    public static final int TEXT_JUST_USER = 3;
    public static final List<String> TEXT_JUSTIFICATION;
    public static final int PROJ_DIST_FIXED = 0;
    public static final int PROJ_LINE_FIXED = 1;
    public static final List<String> PROJECTION_LINE;
    public static final int FORMAT_MM = 0;
    public static final int FORMAT_CM = 1;
    public static final int FORMAT_M_CM = 2;
    public static final int FORMAT_M = 3;
    public static final int FORMAT_KM = 4;
    public static final int FORMAT_FREE_FORMAT = 5;
    public static final int FORMAT_FREE_TEXT = 6;
    public static final List<String> FORMATS;
    private transient Point2D m_p1 = new Point2D.Double();
    private transient Point2D m_p2 = new Point2D.Double();
    private transient Point2D m_pd = new Point2D.Double();
    private double m_angle = 0.0;
    private boolean m_isParallel = false;
    private AttributedText m_text = new AttributedText(new AttributedString(""), new AffineTransform());
    private double m_dimensionTextOffset = 1.0;
    private double m_dimensionLineExtension = 2.0;
    private double m_projectionLineExtension = 2.0;
    private double m_projectionLineOffset = -1.0;
    private double m_dimensionLineTerminatorSize = 1.5;
    private int m_dimensionLineTerminator = 0;
    private int m_textJustification = 0;
    private int m_projectionLineLeft = 0;
    private int m_projectionLineRight = 0;
    private double m_textPosX = 0.0;
    private double m_textPosY = 0.0;
    private double m_projectionLineLeftValue = 3.0;
    private double m_projectionLineRightValue = 3.0;
    private int m_textUnit = 0;
    private String m_textPrefix = null;
    private String m_textFree = null;
    private String m_textPostfix = null;
    private double m_textScale = 1.0;
    private String m_textFormat = null;
    private double m_textFormatMMPerUnit = 1000.0;
    private String m_heightText = null;
    private static final String[] FEATURE_NAMES;

    static {
        TERMINATORS.add("SLASH");
        TERMINATORS.add("HOLLOW_CIRCLE");
        TERMINATORS.add("FILLED_CIRCLE");
        TERMINATORS.add("HOLLOW_ARROW");
        TERMINATORS.add("FILLED_ARROW");
        TEXT_JUSTIFICATION = new ArrayList<String>();
        TEXT_JUSTIFICATION.add("CENTER");
        TEXT_JUSTIFICATION.add("LEFT");
        TEXT_JUSTIFICATION.add("RIGHT");
        TEXT_JUSTIFICATION.add("USERDEF");
        PROJECTION_LINE = new ArrayList<String>();
        PROJECTION_LINE.add("DIST_FIXED");
        PROJECTION_LINE.add("LINE_FIXED");
        FORMATS = new ArrayList<String>();
        FORMATS.add("MM");
        FORMATS.add("CM");
        FORMATS.add("M_CM");
        FORMATS.add("M");
        FORMATS.add("KM");
        FORMATS.add("FREE_FORMAT");
        FORMATS.add("FREE_TEXT");
        FEATURE_NAMES = new String[]{"GEOMETRY.START_POINT_2D", "GEOMETRY.END_POINT_2D", "GEOMETRY.ANGLE", "DIM.DIST_POINT_2D", "DIM.DISTANCE", "DIM.TERMINATOR", "DIM.PROJ_LEFT", "DIM.PROJ_RIGHT", "DIM.PROJ_VALUE_LEFT_MM", "DIM.PROJ_VALUE_RIGHT_MM", "DIM.PROJ_VALUE_EXT_MM", "DIM_TEXT.POINT_2D", "DIM_TEXT.JUSTIFICATION", "DIM_TEXT.PREFIX", "DIM_TEXT.POSTFIX", "DIM_TEXT.SCALE", "DIM_TEXT.FORMAT_SPEC", "DIM_TEXT.FORMAT_STRING", "DIM_TEXT.MM_PER_UNIT", "DIM_TEXT.FREE_TEXT", "DIM_TEXT.LOWER_TEXT"};
    }

    public ComponentDimSingle() {
        this.m_text.setJustification(10);
        this.setDimension(new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new Point2D.Double(0.5, -1.0), 0.0);
    }

    public ComponentDimSingle(Point2D p1, Point2D p2, Point2D pd, double ang) {
        this.m_text.setJustification(10);
        this.setDimension(p1, p2, pd, ang);
    }

    public ComponentDimSingle(Point2D p1, Point2D p2, Point2D pd) {
        this.m_text.setJustification(10);
        this.setParallelDimension(p1, p2, pd);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.m_p1.getX());
        out.writeDouble(this.m_p1.getY());
        out.writeDouble(this.m_p2.getX());
        out.writeDouble(this.m_p2.getY());
        out.writeDouble(this.m_pd.getX());
        out.writeDouble(this.m_pd.getY());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_p1 = new Point2D.Double(in.readDouble(), in.readDouble());
        this.m_p2 = new Point2D.Double(in.readDouble(), in.readDouble());
        this.m_pd = new Point2D.Double(in.readDouble(), in.readDouble());
        if (this.m_textPosX == 0.0 && this.m_textPosY == 0.0) {
            this._updateText();
        }
        if (this.m_projectionLineOffset != -1.0) {
            this.m_projectionLineLeft = 0;
            this.m_projectionLineLeftValue = 3.0;
            this.m_projectionLineRight = 0;
            this.m_projectionLineRightValue = 3.0;
        }
        if (this.m_textScale == 0.0) {
            this.m_textScale = 1.0;
        }
        if (this.m_textFormatMMPerUnit == 0.0) {
            this.m_textFormatMMPerUnit = 1000.0;
        }
    }

    @Override
    public Object clone() {
        ComponentDimSingle dst = (ComponentDimSingle)super.clone();
        dst.m_p1 = (Point2D)this.m_p1.clone();
        dst.m_p2 = (Point2D)this.m_p2.clone();
        dst.m_pd = (Point2D)this.m_pd.clone();
        dst.m_text = (AttributedText)this.m_text.clone();
        return dst;
    }

    @Override
    public void assign(Component rhs) {
        ComponentDimSingle rhsComp = (ComponentDimSingle)rhs;
        this.m_p1.setLocation(rhsComp.m_p1);
        this.m_p2.setLocation(rhsComp.m_p2);
        this.m_pd.setLocation(rhsComp.m_pd);
        this.m_angle = rhsComp.m_angle;
        this.m_isParallel = rhsComp.m_isParallel;
        this.m_text = (AttributedText)rhsComp.m_text.clone();
        this.m_textPosX = rhsComp.m_textPosX;
        this.m_textPosY = rhsComp.m_textPosY;
        this.m_textJustification = rhsComp.m_textJustification;
        this.m_dimensionTextOffset = rhsComp.m_dimensionTextOffset;
        this.m_dimensionLineExtension = rhsComp.m_dimensionLineExtension;
        this.m_projectionLineExtension = rhsComp.m_projectionLineExtension;
        this.m_projectionLineLeftValue = rhsComp.m_projectionLineLeftValue;
        this.m_projectionLineRightValue = rhsComp.m_projectionLineRightValue;
        this.m_projectionLineLeft = rhsComp.m_projectionLineLeft;
        this.m_projectionLineRight = rhsComp.m_projectionLineRight;
        this.m_projectionLineOffset = rhsComp.m_projectionLineOffset;
        this.m_dimensionLineTerminatorSize = rhsComp.m_dimensionLineTerminatorSize;
        this.m_dimensionLineTerminator = rhsComp.m_dimensionLineTerminator;
        this.m_textPrefix = rhsComp.m_textPrefix;
        this.m_textFree = rhsComp.m_textFree;
        this.m_textPostfix = rhsComp.m_textPostfix;
        this.m_textScale = rhsComp.m_textScale;
        this.m_textFormat = rhsComp.m_textFormat;
        this.m_textFormatMMPerUnit = rhsComp.m_textFormatMMPerUnit;
        this.m_heightText = rhsComp.m_heightText;
        super.assign(rhs);
    }

    public Point2D getP1() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double pu = new Point2D.Double();
        return w2u.transform(this.m_p1, pu);
    }

    public Point2D getP2() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double pu = new Point2D.Double();
        return w2u.transform(this.m_p2, pu);
    }

    public Point2D getPd() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double pu = new Point2D.Double();
        return w2u.transform(this.m_pd, pu);
    }

    public Point2D getPt() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double pt = new Point2D.Double(this.m_textPosX, this.m_textPosY);
        Point2D.Double pu = new Point2D.Double();
        return w2u.transform(pt, pu);
    }

    public void setPt(Point2D pt) {
        Point2D[] pnts = this._getJustPts();
        if (Geo2D.equality(pnts[0], pt)) {
            this.m_textJustification = 0;
        } else if (Geo2D.equality(pnts[1], pt)) {
            this.m_textJustification = this._isP1Left() ? 1 : 2;
        } else if (Geo2D.equality(pnts[2], pt)) {
            this.m_textJustification = this._isP1Left() ? 2 : 1;
        } else {
            this.m_textJustification = 3;
            CoordSpace cs = CoordSpace.getCoordSpace();
            AffineTransform u2w = cs.getUserToWorldTransform();
            Point2D.Double pw = new Point2D.Double();
            u2w.transform(pt, pw);
            this.m_textPosX = ((Point2D)pw).getX();
            this.m_textPosY = ((Point2D)pw).getY();
        }
        this._updateText();
        this._notifyWasChanged();
    }

    private Point2D[] _getJustPts() {
        Point2D[] _pnts = new Point2D.Double[3];
        Line2D.Double dimLine = new Line2D.Double();
        this._getDimensionLine(dimLine, true);
        CoordSpace cs = CoordSpace.getCoordSpace();
        double mmPerNU = cs.getMillimetersPerNaturalUnit();
        double angle = Math.atan2(((Line2D)dimLine).getY2() - ((Line2D)dimLine).getY1(), ((Line2D)dimLine).getX2() - ((Line2D)dimLine).getX1());
        double scale = cs.getScale();
        double textOffset = this.m_dimensionTextOffset * scale / mmPerNU;
        Vector2D vecDim = new Vector2D(angle);
        Vector2D vecForth = (Vector2D)vecDim.clone();
        vecForth.scaleBy(textOffset);
        Vector2D vecLeft = new Vector2D(vecDim.left());
        vecLeft.scaleBy(textOffset);
        Vector2D vecRight = new Vector2D(vecDim.right());
        vecRight.scaleBy(textOffset);
        Vector2D plp = new Vector2D(((Line2D)dimLine).getP1());
        plp.add(((Line2D)dimLine).getP2());
        plp.scaleBy(0.5);
        Point2D.Double ptU = new Point2D.Double(plp.x, plp.y);
        Vector2D _vec = new Vector2D();
        AffineTransform deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
        _pnts[0] = deltaTrf.transform(ptU, new Point2D.Double());
        _vec.setLocation(((Line2D)dimLine).getP1());
        _vec.subtract(new Point2D.Double(plp.x, plp.y));
        deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
        _pnts[1] = deltaTrf.transform(ptU, new Point2D.Double());
        _vec.setLocation(((Line2D)dimLine).getP2());
        _vec.subtract(new Point2D.Double(plp.x, plp.y));
        deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
        _pnts[2] = deltaTrf.transform(ptU, new Point2D.Double());
        return _pnts;
    }

    public Point2D getProjP1() {
        Line2D.Double dimLine = new Line2D.Double();
        this._getDimensionLine(dimLine, false);
        return this._getProjLinePoint(this.getP1(), ((Line2D)dimLine).getP1(), true);
    }

    public void setProjP1(Point2D pt) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale() / cs.getMillimetersPerNaturalUnit();
        Line2D.Double dimLine = new Line2D.Double();
        this._getDimensionLine(dimLine, false);
        double len = this._getProjLineLength(this.getP1(), ((Line2D)dimLine).getP1(), pt);
        this.m_projectionLineLeft = 1;
        this.m_projectionLineLeftValue = len / scale;
        this._notifyWasChanged();
    }

    public Point2D getProjP2() {
        Line2D.Double dimLine = new Line2D.Double();
        this._getDimensionLine(dimLine, false);
        return this._getProjLinePoint(this.getP2(), ((Line2D)dimLine).getP2(), false);
    }

    public void setProjP2(Point2D pt) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale() / cs.getMillimetersPerNaturalUnit();
        Line2D.Double dimLine = new Line2D.Double();
        this._getDimensionLine(dimLine, false);
        double len = this._getProjLineLength(this.getP2(), ((Line2D)dimLine).getP2(), pt);
        this.m_projectionLineRight = 1;
        this.m_projectionLineRightValue = len / scale;
        this._notifyWasChanged();
    }

    public double getAngle() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double angleNU = cs.angleToUser(this.m_angle);
        return angleNU;
    }

    public void setAngle(double angle) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        this.m_angle = cs.angleToWorld(angle);
        this._notifyWasChanged();
    }

    public boolean isParallel() {
        return this.m_isParallel;
    }

    public void setDimension(Point2D p1, Point2D p2, Point2D pd, double angle) {
        this.m_isParallel = false;
        this._setDimension(p1, p2, pd, angle);
    }

    public void setParallelDimension(Point2D p1, Point2D p2, Point2D pd) {
        this.m_isParallel = true;
        double angle = Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX());
        this._setDimension(p1, p2, pd, angle);
    }

    public void setDimension(Point2D p1, Point2D p2, Point2D pd) {
        if (this.m_isParallel) {
            this.setParallelDimension(p1, p2, pd);
        } else {
            this.setDimension(p1, p2, pd, this.getAngle());
        }
    }

    public void setDimension(Point2D p1, Point2D p2) {
        if (this.m_isParallel) {
            Line2D.Double l = new Line2D.Double(this.getP1(), this.getP2());
            double d = Geo2D.distance(this.getPd(), l, true);
            Point2D pd = null;
            Vector2D p1p2 = new Vector2D(p1, p2);
            Vector2D p1pd = new Vector2D(this.getP1(), this.getPd());
            try {
                Vector2D prp = new Vector2D(p1p2);
                if (p1p2.getAngleCCW(p1pd) < Math.PI) {
                    prp.left();
                } else {
                    prp.right();
                }
                prp.normalize();
                prp.scaleBy(d);
                pd = prp.add(p1);
            }
            catch (NullVectorException e) {
                pd = this.getPd();
            }
            this.setParallelDimension(p1, p2, pd);
        } else {
            this.setDimension(p1, p2, this.getPd(), this.getAngle());
        }
    }

    public void setPrefix(String prefix) {
        this.m_textPrefix = prefix;
    }

    public String getPrefix() {
        return this.m_textPrefix;
    }

    public void setFreeText(String text) {
        this.m_textFree = text;
    }

    public String getFreeText() {
        return this.m_textFree;
    }

    public void setPostfix(String postfix) {
        this.m_textPostfix = postfix;
    }

    public String getPostfix() {
        return this.m_textPostfix;
    }

    public void setTextScale(double scale) {
        this.m_textScale = scale;
    }

    public double getTextScale() {
        return this.m_textScale;
    }

    public void setFormat(String format, double mmPerUnit) {
        this.m_textFormat = format;
        this.m_textFormatMMPerUnit = mmPerUnit;
    }

    public String getFormat() {
        return this.m_textFormat;
    }

    public double getMMPerUnit() {
        return this.m_textFormatMMPerUnit;
    }

    public void setHeightText(String text) {
        this.m_heightText = text;
    }

    public String getHeightText() {
        return this.m_heightText;
    }

    private void _setDimension(Point2D p1, Point2D p2, Point2D pd, double angle) {
        Vector2D vecdim2;
        Vector2D vecdim = new Vector2D(angle);
        Vector2D pd2 = new Vector2D(pd);
        pd2.add(vecdim);
        Line2D.Double ld = new Line2D.Double(pd, pd2);
        Point2D p1p = Geo2D.projection(p1, (Line2D)ld, new Point2D.Double());
        Point2D p2p = Geo2D.projection(p2, (Line2D)ld, new Point2D.Double());
        double EPS = 0.0017453292519943296;
        angle %= Math.PI * 2;
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (1.5725416560468908 < angle && angle <= 4.714134309636684) {
            angle -= Math.PI;
            if ((angle %= Math.PI * 2) < 0.0) {
                angle += Math.PI * 2;
            }
        }
        if ((vecdim2 = new Vector2D(p1p, p2p)).getScalarProduct(vecdim = new Vector2D(angle)) < 0.0) {
            Point2D pt = p1p;
            p1p = p2p;
            p2p = pt;
        }
        Point2D.Double pd25 = new Point2D.Double(p1p.getX() + 0.25 * (p2p.getX() - p1p.getX()), p1p.getY() + 0.25 * (p2p.getY() - p1p.getY()));
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        u2w.transform(p1, this.m_p1);
        u2w.transform(p2, this.m_p2);
        u2w.transform(pd25, this.m_pd);
        this.setAngle(angle);
        this._updateText();
        this._notifyWasChanged();
    }

    private boolean _isP1Left() {
        Vector2D _vecdim;
        Vector2D _vecdim2;
        double angle = this.getAngle();
        Point2D pd = this.getPd();
        Vector2D pd2 = new Vector2D(pd);
        pd2.add(new Vector2D(angle));
        Line2D.Double line = new Line2D.Double(pd, pd2);
        Point2D p1 = this.getP1();
        Point2D p2 = this.getP2();
        Point2D _p1p = Geo2D.projection(p1, (Line2D)line, new Point2D.Double());
        Point2D _p2p = Geo2D.projection(p2, (Line2D)line, new Point2D.Double());
        double EPS = 0.0017453292519943296;
        angle %= Math.PI * 2;
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (1.5725416560468908 < angle && angle <= 4.714134309636684) {
            angle -= Math.PI;
            if ((angle %= Math.PI * 2) < 0.0) {
                angle += Math.PI * 2;
            }
        }
        return !((_vecdim2 = new Vector2D(_p1p, _p2p)).getScalarProduct(_vecdim = new Vector2D(angle)) < 0.0);
    }

    private double _getProjLineLength(Point2D pt, Point2D dimLinePt, Point2D pjp) {
        Line2D.Double projLine = new Line2D.Double(pt, dimLinePt);
        if (Geo2D.equality(((Line2D)projLine).getP1(), ((Line2D)projLine).getP2())) {
            return 0.0;
        }
        Vector2D vext = new Vector2D(((Line2D)projLine).getP1(), ((Line2D)projLine).getP2());
        vext.normalize();
        Vector2D v1 = new Vector2D();
        Geo2D.projection(pjp, (Line2D)projLine, v1);
        double length = Geo2D.distance((Point2D)v1, dimLinePt);
        Vector2D dimV = new Vector2D(pt, dimLinePt);
        Vector2D projV = new Vector2D(v1, dimLinePt);
        if (dimV.getScalarProduct(projV) < 0.0) {
            length = -length;
        }
        return length;
    }

    private Point2D _getProjLinePoint(Point2D pt, Point2D dimLinePt, boolean left) {
        if (Geo2D.equality(pt, dimLinePt)) {
            return new Point2D.Double(pt.getX(), pt.getY());
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale() / cs.getMillimetersPerNaturalUnit();
        Line2D.Double projLine = new Line2D.Double(pt, dimLinePt);
        Vector2D voffs = null;
        Vector2D vext = null;
        Vector2D vPt = null;
        if (left) {
            double length = this.m_projectionLineLeftValue * scale;
            switch (this.m_projectionLineLeft) {
                case 0: {
                    vext = new Vector2D(((Line2D)projLine).getP1(), ((Line2D)projLine).getP2());
                    vext.normalize();
                    voffs = new Vector2D(vext);
                    voffs.scaleBy(length);
                    vPt = new Vector2D(((Line2D)projLine).getP1());
                    vPt.add(voffs);
                    break;
                }
                case 1: {
                    vext = new Vector2D(((Line2D)projLine).getP2(), ((Line2D)projLine).getP1());
                    vext.normalize();
                    voffs = new Vector2D(vext);
                    voffs.scaleBy(length);
                    vPt = new Vector2D(((Line2D)projLine).getP2());
                    vPt.add(voffs);
                    break;
                }
                default: {
                    this.m_projectionLineLeft = 0;
                    vext = new Vector2D(((Line2D)projLine).getP1(), ((Line2D)projLine).getP2());
                    vext.normalize();
                    voffs = new Vector2D(vext);
                    voffs.scaleBy(length);
                    vPt = new Vector2D(((Line2D)projLine).getP1());
                    vPt.add(voffs);
                    break;
                }
            }
        } else {
            double length = this.m_projectionLineRightValue * scale;
            switch (this.m_projectionLineRight) {
                case 0: {
                    vext = new Vector2D(((Line2D)projLine).getP1(), ((Line2D)projLine).getP2());
                    vext.normalize();
                    voffs = new Vector2D(vext);
                    voffs.scaleBy(length);
                    vPt = new Vector2D(((Line2D)projLine).getP1());
                    vPt.add(voffs);
                    break;
                }
                case 1: {
                    vext = new Vector2D(((Line2D)projLine).getP2(), ((Line2D)projLine).getP1());
                    vext.normalize();
                    voffs = new Vector2D(vext);
                    voffs.scaleBy(length);
                    vPt = new Vector2D(((Line2D)projLine).getP2());
                    vPt.add(voffs);
                    break;
                }
                default: {
                    this.m_projectionLineRight = 0;
                    vext = new Vector2D(((Line2D)projLine).getP1(), ((Line2D)projLine).getP2());
                    vext.normalize();
                    voffs = new Vector2D(vext);
                    voffs.scaleBy(length);
                    vPt = new Vector2D(((Line2D)projLine).getP1());
                    vPt.add(voffs);
                }
            }
        }
        return vPt;
    }

    private Line2D _getDimensionLine(Line2D line, boolean sorted) {
        double angle = this.getAngle();
        Point2D pd = this.getPd();
        Vector2D pd2 = new Vector2D(pd);
        pd2.add(new Vector2D(angle));
        line.setLine(pd, pd2);
        Point2D p1 = this.getP1();
        Point2D p2 = this.getP2();
        Point2D _p1p = Geo2D.projection(p1, line, new Point2D.Double());
        Point2D _p2p = Geo2D.projection(p2, line, new Point2D.Double());
        if (sorted) {
            Vector2D _vecdim;
            Vector2D _vecdim2;
            double EPS = 0.0017453292519943296;
            if ((angle %= Math.PI * 2) < 0.0) {
                angle += Math.PI * 2;
            }
            if (1.5725416560468908 < angle && angle <= 4.714134309636684) {
                angle -= Math.PI;
                if ((angle %= Math.PI * 2) < 0.0) {
                    angle += Math.PI * 2;
                }
            }
            if ((_vecdim2 = new Vector2D(_p1p, _p2p)).getScalarProduct(_vecdim = new Vector2D(angle)) < 0.0) {
                Point2D _pt = _p1p;
                _p1p = _p2p;
                _p2p = _pt;
            }
        }
        line.setLine(_p1p, _p2p);
        return line;
    }

    private void _updateText() {
        AttributedString attString;
        Line2D.Double dimLine = new Line2D.Double();
        if (this._isP1Left()) {
            this._getDimensionLine(dimLine, false);
        } else {
            this._getDimensionLine(dimLine, true);
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        AffineTransform w2u = cs.getWorldToUserTransform();
        double mmPerNU = cs.getMillimetersPerNaturalUnit();
        double dist = Geo2D.length(dimLine) * this.getTextScale();
        int iDistmm = (int)(mmPerNU * dist + 0.5);
        String prefix = this.getPrefix() == null ? "" : this.getPrefix();
        String text = "";
        String postfix = this.getPostfix() == null ? "" : this.getPostfix();
        switch (this.m_textUnit) {
            case 0: {
                text = Integer.toString(iDistmm);
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            case 1: {
                double dDistcm = (double)iDistmm / 10.0;
                double digit = dDistcm - (double)((int)dDistcm);
                text = 0.0 <= digit && digit < 0.25 ? Integer.toString((int)dDistcm) : (0.25 <= digit && digit < 0.75 ? String.valueOf(Integer.toString((int)dDistcm)) + ".5" : Integer.toString((int)dDistcm + 1));
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            case 2: {
                double dDistcm = (double)iDistmm / 10.0;
                double digit = dDistcm - (double)((int)dDistcm);
                if (0.0 <= digit && digit < 0.25) {
                    int length = (text = String.valueOf(text) + Integer.toString((int)dDistcm)).length();
                    if (length > 2) {
                        text = String.valueOf(text.substring(0, length - 2)) + "." + text.substring(length - 2);
                    }
                    attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                    break;
                }
                if (0.25 <= digit && digit < 0.75) {
                    int length = (text = String.valueOf(text) + Integer.toString((int)dDistcm) + "5").length();
                    if (length > 3) {
                        text = String.valueOf(text.substring(0, length - 3)) + "." + text.substring(length - 3);
                    }
                    attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                    attString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, prefix.length() + text.length() - 1, prefix.length() + text.length());
                    break;
                }
                int length = (text = String.valueOf(text) + Integer.toString((int)dDistcm + 1)).length();
                if (length > 2) {
                    text = String.valueOf(text.substring(0, length - 2)) + "." + text.substring(length - 2);
                }
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            case 3: {
                double dDistm = mmPerNU * dist / 1000.0;
                double digit = (dDistm - (double)((int)dDistm)) * 100.0;
                text = Math.round(digit) == 100L ? String.valueOf(Long.toString(Math.round(dDistm))) + ".00" : (Math.round(digit) < 10L ? String.valueOf(Integer.toString((int)dDistm)) + "." + "0" + Long.toString(Math.round(digit)) : String.valueOf(Integer.toString((int)dDistm)) + "." + Long.toString(Math.round(digit)));
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            case 4: {
                double dDistkm = mmPerNU * dist / 1000000.0;
                double digit = (dDistkm - (double)((int)dDistkm)) * 100.0;
                text = Math.round(digit) == 100L ? String.valueOf(Long.toString(Math.round(dDistkm))) + ".00" : (Math.round(digit) < 10L ? String.valueOf(Integer.toString((int)dDistkm)) + "." + "0" + Long.toString(Math.round(digit)) : String.valueOf(Integer.toString((int)dDistkm)) + "." + Long.toString(Math.round(digit)));
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            case 5: {
                try {
                    DecimalFormat nf = new DecimalFormat();
                    nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
                    String format = this.getFormat();
                    if (format == null) {
                        format = DEFAULT_FREE_FORMAT;
                    }
                    nf.applyLocalizedPattern(format);
                    double scaledDist = dist * mmPerNU / this.getMMPerUnit();
                    text = nf.format(scaledDist);
                }
                catch (Exception e) {
                    text = e.getMessage();
                }
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            case 6: {
                text = this.getFreeText();
                if (text == null) {
                    text = DEFAULT_FREE_TEXT;
                }
                attString = new AttributedString(String.valueOf(prefix) + text + postfix);
                break;
            }
            default: {
                int iDist = (int)(mmPerNU * dist + 0.5);
                text = Integer.toString(iDist);
                attString = new AttributedString(String.valueOf(prefix) + text + prefix);
            }
        }
        this.m_text.setAttributedString(attString);
        double angle = Math.atan2(((Line2D)dimLine).getY2() - ((Line2D)dimLine).getY1(), ((Line2D)dimLine).getX2() - ((Line2D)dimLine).getX1());
        double scale = cs.getScale();
        double textOffset = this.m_dimensionTextOffset * scale / mmPerNU;
        Vector2D vecDim = new Vector2D(angle);
        Vector2D vecForth = (Vector2D)vecDim.clone();
        vecForth.scaleBy(textOffset);
        Vector2D vecLeft = new Vector2D(vecDim.left());
        vecLeft.scaleBy(textOffset);
        Vector2D plp = new Vector2D(((Line2D)dimLine).getP1());
        plp.add(((Line2D)dimLine).getP2());
        plp.scaleBy(0.5);
        Point2D ptU = new Point2D.Double(plp.x, plp.y);
        AffineTransform trf = AffineTransform.getRotateInstance(angle);
        Vector2D _vec = new Vector2D();
        switch (this.m_textJustification) {
            case 0: {
                this.m_text.setJustification(3);
                trf.preConcatenate(AffineTransform.getTranslateInstance(plp.getX(), plp.getY()));
                AffineTransform deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                ptU = deltaTrf.transform(ptU, ptU);
                _vec.add(vecLeft);
                deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                trf.preConcatenate(deltaTrf);
                break;
            }
            case 1: {
                if (this._isP1Left()) {
                    this.m_text.setJustification(6);
                    trf.preConcatenate(AffineTransform.getTranslateInstance(plp.getX(), plp.getY()));
                    _vec.setLocation(((Line2D)dimLine).getP1());
                    _vec.subtract(new Point2D.Double(plp.x, plp.y));
                    AffineTransform deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                    ptU = deltaTrf.transform(ptU, ptU);
                    _vec.add(vecForth.invert());
                    _vec.add(vecLeft);
                    deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                    trf.preConcatenate(deltaTrf);
                    break;
                }
                this.m_text.setJustification(0);
                trf.preConcatenate(AffineTransform.getTranslateInstance(plp.getX(), plp.getY()));
                _vec.setLocation(((Line2D)dimLine).getP2());
                _vec.subtract(new Point2D.Double(plp.x, plp.y));
                AffineTransform deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                ptU = deltaTrf.transform(ptU, ptU);
                _vec.add(vecForth);
                _vec.add(vecLeft);
                deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                trf.preConcatenate(deltaTrf);
                break;
            }
            case 2: {
                if (this._isP1Left()) {
                    this.m_text.setJustification(0);
                    trf.preConcatenate(AffineTransform.getTranslateInstance(plp.getX(), plp.getY()));
                    _vec.setLocation(((Line2D)dimLine).getP2());
                    _vec.subtract(new Point2D.Double(plp.x, plp.y));
                    AffineTransform deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                    ptU = deltaTrf.transform(ptU, ptU);
                    _vec.add(vecForth);
                    _vec.add(vecLeft);
                    deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                    trf.preConcatenate(deltaTrf);
                    break;
                }
                this.m_text.setJustification(6);
                trf.preConcatenate(AffineTransform.getTranslateInstance(plp.getX(), plp.getY()));
                _vec.setLocation(((Line2D)dimLine).getP1());
                _vec.subtract(new Point2D.Double(plp.x, plp.y));
                AffineTransform deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                ptU = deltaTrf.transform(ptU, ptU);
                _vec.add(vecForth.invert());
                _vec.add(vecLeft);
                deltaTrf = AffineTransform.getTranslateInstance(_vec.x, _vec.y);
                trf.preConcatenate(deltaTrf);
                break;
            }
            case 3: {
                this.m_text.setJustification(3);
                Point2D.Double pt = new Point2D.Double(this.m_textPosX, this.m_textPosY);
                ptU = new Point2D.Double();
                w2u.transform(pt, ptU);
                trf.preConcatenate(AffineTransform.getTranslateInstance(ptU.getX(), ptU.getY()));
            }
        }
        trf.preConcatenate(u2w);
        this.m_text.setTransform(trf);
        Point2D.Double ptW = new Point2D.Double();
        u2w.transform(ptU, ptW);
        this.m_textPosX = ((Point2D)ptW).getX();
        this.m_textPosY = ((Point2D)ptW).getY();
    }

    @Override
    public void transformBy(AffineTransform mat) {
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        Point2D.Double pd = new Point2D.Double();
        Point2D.Double pt = new Point2D.Double();
        mat.transform(this.getP1(), p1);
        mat.transform(this.getP2(), p2);
        mat.transform(this.getPd(), pd);
        if (this.m_textJustification == 3) {
            mat.transform(this.getPt(), pt);
            this.setPt(pt);
        }
        if (this.m_isParallel) {
            this.setParallelDimension(p1, p2, pd);
            return;
        }
        Point2D.Double origin = new Point2D.Double();
        Point2D.Double xAxis = new Point2D.Double(1.0, 0.0);
        mat.transform(origin, origin);
        mat.transform(xAxis, xAxis);
        double dx = ((Point2D)xAxis).getX() - ((Point2D)origin).getX();
        double dy = ((Point2D)xAxis).getY() - ((Point2D)origin).getY();
        double angle = this.getAngle() + Math.atan2(dy, dx);
        this.setDimension(p1, p2, pd, angle);
    }

    private AttributedShape getShape() {
        Vector2D voffs3;
        Vector2D voffs22;
        Path2D.Double path = new Path2D.Double();
        Line2D.Double dimLine = new Line2D.Double();
        Line2D.Double projLine1 = new Line2D.Double();
        Line2D.Double projLine2 = new Line2D.Double();
        this._getDimensionLine(dimLine, false);
        Line2D.Double line = new Line2D.Double();
        Vector2D pd2 = new Vector2D(this.m_pd);
        pd2.add(new Vector2D(this.m_angle));
        line.setLine(this.m_pd, pd2);
        Point2D _p1p = Geo2D.projection(this.m_p1, (Line2D)line, new Point2D.Double());
        Point2D _p2p = Geo2D.projection(this.m_p2, (Line2D)line, new Point2D.Double());
        Point2D p1 = this.getP1();
        Point2D p2 = this.getP2();
        projLine1.setLine(p1, ((Line2D)dimLine).getP1());
        projLine2.setLine(p2, ((Line2D)dimLine).getP2());
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale() / cs.getMillimetersPerNaturalUnit();
        double angle = Math.atan2(((Line2D)dimLine).getY2() - ((Line2D)dimLine).getY1(), ((Line2D)dimLine).getX2() - ((Line2D)dimLine).getX1());
        Vector2D vecDim = new Vector2D(angle);
        Vector2D vecRight = new Vector2D(vecDim);
        vecRight.right();
        double ext = this.m_dimensionLineExtension * scale;
        Vector2D vext = new Vector2D(vecDim);
        vext.scaleBy(ext);
        Vector2D v1 = new Vector2D(((Line2D)dimLine).getP1());
        Vector2D v2 = new Vector2D(((Line2D)dimLine).getP2());
        if (this.m_dimensionLineTerminator != 3 && this.m_dimensionLineTerminator != 4) {
            v1.subtract(vext);
            v2.add(vext);
        }
        dimLine.setLine(v1, v2);
        path.append(dimLine, false);
        ext = this.m_projectionLineExtension * scale;
        switch (this.m_projectionLineLeft) {
            case 0: {
                double offsLeft = this.m_projectionLineLeftValue * scale;
                try {
                    vext = new Vector2D(((Line2D)projLine1).getP1(), ((Line2D)projLine1).getP2());
                    vext.normalize();
                    voffs22 = new Vector2D(vext);
                    vext.scaleBy(ext);
                    if (offsLeft > 0.0) {
                        voffs22.scaleBy(offsLeft);
                    } else {
                        voffs22.scaleBy(-offsLeft);
                    }
                    v1 = new Vector2D(((Line2D)projLine1).getP1());
                    v1.add(voffs22);
                    v2 = new Vector2D(((Line2D)projLine1).getP2());
                    v2.add(vext);
                    projLine1.setLine(v1, v2);
                    path.append(projLine1, false);
                }
                catch (NullVectorException voffs22) {}
                break;
            }
            case 1: {
                double lengthLeft = this.m_projectionLineLeftValue * scale;
                try {
                    vext = new Vector2D(((Line2D)projLine1).getP2(), ((Line2D)projLine1).getP1());
                    vext.normalize();
                    voffs3 = new Vector2D(vext);
                    if (lengthLeft > 0.0) {
                        vext.scaleBy(-ext);
                    } else {
                        vext.scaleBy(ext);
                    }
                    voffs3.scaleBy(lengthLeft);
                    v1 = new Vector2D(((Line2D)projLine1).getP2());
                    v1.add(voffs3);
                    v2 = new Vector2D(((Line2D)projLine1).getP2());
                    v2.add(vext);
                    projLine1.setLine(v1, v2);
                    path.append(projLine1, false);
                }
                catch (NullVectorException voffs3) {}
                break;
            }
            default: {
                this.m_projectionLineLeft = 0;
                double offsLeft = this.m_projectionLineLeftValue * scale;
                try {
                    vext = new Vector2D(((Line2D)projLine1).getP1(), ((Line2D)projLine1).getP2());
                    vext.normalize();
                    voffs3 = new Vector2D(vext);
                    vext.scaleBy(ext);
                    if (offsLeft > 0.0) {
                        voffs3.scaleBy(offsLeft);
                    } else {
                        voffs3.scaleBy(-offsLeft);
                    }
                    v1 = new Vector2D(((Line2D)projLine1).getP1());
                    v1.add(voffs3);
                    v2 = new Vector2D(((Line2D)projLine1).getP2());
                    v2.add(vext);
                    projLine1.setLine(v1, v2);
                    path.append(projLine1, false);
                    break;
                }
                catch (NullVectorException voffs4) {
                    // empty catch block
                }
            }
        }
        switch (this.m_projectionLineRight) {
            case 0: {
                double offsRight = this.m_projectionLineRightValue * scale;
                try {
                    vext = new Vector2D(((Line2D)projLine2).getP1(), ((Line2D)projLine2).getP2());
                    vext.normalize();
                    voffs22 = new Vector2D(vext);
                    vext.scaleBy(ext);
                    if (offsRight > 0.0) {
                        voffs22.scaleBy(offsRight);
                    } else {
                        voffs22.scaleBy(-offsRight);
                    }
                    v1 = new Vector2D(((Line2D)projLine2).getP1());
                    v1.add(voffs22);
                    v2 = new Vector2D(((Line2D)projLine2).getP2());
                    v2.add(vext);
                    projLine2.setLine(v1, v2);
                    path.append(projLine2, false);
                }
                catch (NullVectorException voffs5) {}
                break;
            }
            case 1: {
                double lengthRight = this.m_projectionLineRightValue * scale;
                try {
                    vext = new Vector2D(((Line2D)projLine2).getP2(), ((Line2D)projLine2).getP1());
                    vext.normalize();
                    voffs3 = new Vector2D(vext);
                    if (lengthRight > 0.0) {
                        vext.scaleBy(-ext);
                    } else {
                        vext.scaleBy(ext);
                    }
                    voffs3.scaleBy(lengthRight);
                    v1 = new Vector2D(((Line2D)projLine2).getP2());
                    v1.add(voffs3);
                    v2 = new Vector2D(((Line2D)projLine2).getP2());
                    v2.add(vext);
                    projLine2.setLine(v1, v2);
                    path.append(projLine2, false);
                }
                catch (NullVectorException voffs6) {}
                break;
            }
            default: {
                this.m_projectionLineRight = 0;
                double offsRight = this.m_projectionLineRightValue * scale;
                try {
                    vext = new Vector2D(((Line2D)projLine2).getP1(), ((Line2D)projLine2).getP2());
                    vext.normalize();
                    voffs3 = new Vector2D(vext);
                    vext.scaleBy(ext);
                    if (offsRight > 0.0) {
                        voffs3.scaleBy(offsRight);
                    } else {
                        voffs3.scaleBy(-offsRight);
                    }
                    v1 = new Vector2D(((Line2D)projLine2).getP1());
                    v1.add(voffs3);
                    v2 = new Vector2D(((Line2D)projLine2).getP2());
                    v2.add(vext);
                    projLine2.setLine(v1, v2);
                    path.append(projLine2, false);
                    break;
                }
                catch (NullVectorException nullVectorException) {
                    // empty catch block
                }
            }
        }
        return this._attributeShape(new AttributedShape(path));
    }

    private AttributedShape getTerminators() {
        Path2D.Double path = new Path2D.Double();
        Line2D.Double dimLine = new Line2D.Double();
        this._getDimensionLine(dimLine, false);
        CoordSpace cs = CoordSpace.getCoordSpace();
        double scale = cs.getScale() / cs.getMillimetersPerNaturalUnit();
        double size = 0.5 * this.m_dimensionLineTerminatorSize * scale;
        double angle = Math.atan2(((Line2D)dimLine).getY2() - ((Line2D)dimLine).getY1(), ((Line2D)dimLine).getX2() - ((Line2D)dimLine).getX1());
        if (this.m_dimensionLineTerminator == 0) {
            Line2D.Double slash = new Line2D.Double(((Line2D)dimLine).getX1() - size, ((Line2D)dimLine).getY1() - size, ((Line2D)dimLine).getX1() + size, ((Line2D)dimLine).getY1() + size);
            AffineTransform rot = AffineTransform.getRotateInstance(angle, ((Line2D)dimLine).getX1(), ((Line2D)dimLine).getY1());
            path.append(rot.createTransformedShape(slash), false);
            ((Line2D)slash).setLine(((Line2D)dimLine).getX2() - size, ((Line2D)dimLine).getY2() - size, ((Line2D)dimLine).getX2() + size, ((Line2D)dimLine).getY2() + size);
            rot = AffineTransform.getRotateInstance(angle, ((Line2D)dimLine).getX2(), ((Line2D)dimLine).getY2());
            path.append(rot.createTransformedShape(slash), false);
            return this._attributeShape(new AttributedShape(path));
        }
        if (this.m_dimensionLineTerminator == 1 || this.m_dimensionLineTerminator == 2) {
            Ellipse2D.Double circle = new Ellipse2D.Double();
            circle.setFrameFromCenter(((Line2D)dimLine).getX1(), ((Line2D)dimLine).getY1(), ((Line2D)dimLine).getX1() + size / 1.5, ((Line2D)dimLine).getY1() + size / 1.5);
            path.append(circle, false);
            circle.setFrameFromCenter(((Line2D)dimLine).getX2(), ((Line2D)dimLine).getY2(), ((Line2D)dimLine).getX2() + size / 1.5, ((Line2D)dimLine).getY2() + size / 1.5);
            path.append(circle, false);
            if (this.m_dimensionLineTerminator == 1) {
                return this._attributeShape(new AttributedShape(path));
            }
            AttributedShape attShape = this._attributeShape(new AttributedShape(path));
            attShape.setFillPaint(attShape.getDrawPaint());
            return attShape;
        }
        if (this.m_dimensionLineTerminator == 3 || this.m_dimensionLineTerminator == 4) {
            Path2D.Double arrow = new Path2D.Double();
            ((Path2D)arrow).moveTo(((Line2D)dimLine).getX1(), ((Line2D)dimLine).getY1());
            ((Path2D)arrow).lineTo(((Line2D)dimLine).getX1() + size * 3.0, ((Line2D)dimLine).getY1() + size / 1.5);
            ((Path2D)arrow).lineTo(((Line2D)dimLine).getX1() + size * 3.0, ((Line2D)dimLine).getY1() - size / 1.5);
            arrow.closePath();
            AffineTransform rot = AffineTransform.getRotateInstance(angle, ((Line2D)dimLine).getX1(), ((Line2D)dimLine).getY1());
            path.append(rot.createTransformedShape(arrow), false);
            arrow = new Path2D.Double();
            ((Path2D)arrow).moveTo(((Line2D)dimLine).getX2(), ((Line2D)dimLine).getY2());
            ((Path2D)arrow).lineTo(((Line2D)dimLine).getX2() - size * 3.0, ((Line2D)dimLine).getY2() + size / 1.5);
            ((Path2D)arrow).lineTo(((Line2D)dimLine).getX2() - size * 3.0, ((Line2D)dimLine).getY2() - size / 1.5);
            arrow.closePath();
            rot = AffineTransform.getRotateInstance(angle, ((Line2D)dimLine).getX2(), ((Line2D)dimLine).getY2());
            path.append(rot.createTransformedShape(arrow), false);
            if (this.m_dimensionLineTerminator == 3) {
                return this._attributeShape(new AttributedShape(path));
            }
            AttributedShape attShape = this._attributeShape(new AttributedShape(path));
            attShape.setFillPaint(attShape.getDrawPaint());
            return attShape;
        }
        throw new IllegalArgumentException();
    }

    private AttributedText _getText(int iText) {
        this._updateText();
        AttributedText text = null;
        CoordSpace cs = CoordSpace.getCoordSpace();
        switch (iText) {
            case 0: {
                text = (AttributedText)this.m_text.clone();
                text.transformBy(cs.getWorldToUserTransform());
                break;
            }
            case 1: {
                if (this.getHeightText() == null || this.getHeightText().isEmpty()) {
                    return null;
                }
                AffineTransform trf = this.m_text.getTransform();
                double mmPerNU = cs.getMillimetersPerNaturalUnit();
                double scale = cs.getScale();
                double textOffset = this.m_dimensionTextOffset * scale / mmPerNU;
                AffineTransform trfOffset = AffineTransform.getTranslateInstance(0.0, -textOffset);
                trf.concatenate(trfOffset);
                text = new AttributedText(new AttributedString(this.getHeightText()), trf);
                switch (this.m_textJustification) {
                    case 1: {
                        text.setJustification(8);
                        break;
                    }
                    case 2: {
                        text.setJustification(2);
                        break;
                    }
                    case 3: {
                        text.setJustification(5);
                        break;
                    }
                    default: {
                        text.setJustification(5);
                    }
                }
                text.transformBy(cs.getWorldToUserTransform());
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong text index");
            }
        }
        return this._attributeText(text);
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return new NamedListIteratorAdapter<AttributedShape>(){

            @Override
            protected int _size() {
                return 2;
            }

            @Override
            protected AttributedShape _get(int index) {
                switch (index) {
                    case 0: {
                        return ComponentDimSingle.this.getShape();
                    }
                    case 1: {
                        return ComponentDimSingle.this.getTerminators();
                    }
                }
                throw new IllegalArgumentException();
            }
        };
    }

    @Override
    public NamedListIterator<AttributedText> textIterator() {
        return new NamedListIteratorAdapter<AttributedText>(){

            @Override
            protected int _size() {
                return ComponentDimSingle.this.getHeightText() == null || ComponentDimSingle.this.getHeightText().isEmpty() ? 1 : 2;
            }

            @Override
            protected AttributedText _get(int index) {
                switch (index) {
                    case 0: 
                    case 1: {
                        return ComponentDimSingle.this._getText(index);
                    }
                }
                throw new IllegalArgumentException();
            }
        };
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name >= 0 && name <= 5;
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        switch (name) {
            case 0: {
                return this.getP1();
            }
            case 1: {
                return this.getP2();
            }
            case 2: {
                return this.getPd();
            }
            case 3: {
                return this.getPt();
            }
            case 4: {
                return this.getProjP1();
            }
            case 5: {
                return this.getProjP2();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        switch (name) {
            case 0: {
                this.setDimension(pnt, this.getP2());
                break;
            }
            case 1: {
                this.setDimension(this.getP1(), pnt);
                break;
            }
            case 2: {
                this.setDimension(this.getP1(), this.getP2(), pnt);
                break;
            }
            case 3: {
                this.setPt(pnt);
                break;
            }
            case 4: {
                this.setProjP1(pnt);
                break;
            }
            case 5: {
                this.setProjP2(pnt);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 6;
            }

            @Override
            protected Point2D _get(int index) {
                switch (index) {
                    case 0: {
                        return ComponentDimSingle.this.getP1();
                    }
                    case 1: {
                        return ComponentDimSingle.this.getP2();
                    }
                    case 2: {
                        return ComponentDimSingle.this.getPd();
                    }
                    case 3: {
                        return ComponentDimSingle.this.getPt();
                    }
                    case 4: {
                        return ComponentDimSingle.this.getProjP1();
                    }
                    case 5: {
                        return ComponentDimSingle.this.getProjP2();
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            protected void _set(int index, Point2D p) {
                switch (index) {
                    case 0: {
                        ComponentDimSingle.this.setDimension(p, ComponentDimSingle.this.getP2());
                        break;
                    }
                    case 1: {
                        ComponentDimSingle.this.setDimension(ComponentDimSingle.this.getP1(), p);
                        break;
                    }
                    case 2: {
                        ComponentDimSingle.this.setDimension(ComponentDimSingle.this.getP1(), ComponentDimSingle.this.getP2(), p);
                        break;
                    }
                    case 3: {
                        ComponentDimSingle.this.setPt(p);
                        break;
                    }
                    case 4: {
                        ComponentDimSingle.this.setProjP1(p);
                        break;
                    }
                    case 5: {
                        ComponentDimSingle.this.setProjP2(p);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        };
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            return new Point2DFeature(FEATURE_NAMES[0], this.getP1());
        }
        if (name.equals(FEATURE_NAMES[1])) {
            return new Point2DFeature(FEATURE_NAMES[1], this.getP2());
        }
        if (name.equals(FEATURE_NAMES[2])) {
            return new AngleFeature(FEATURE_NAMES[2], this.getAngle());
        }
        if (name.equals(FEATURE_NAMES[3])) {
            return new Point2DFeature(FEATURE_NAMES[3], this.getPd());
        }
        if (name.equals(FEATURE_NAMES[4])) {
            char c;
            AttributedString as = this.m_text.getAttributedString();
            AttributedCharacterIterator ait = as.getIterator();
            StringBuilder sb = new StringBuilder();
            while ((c = ait.current()) != '\uffff') {
                sb.append(c);
                ait.next();
            }
            StringFeature sf = new StringFeature(FEATURE_NAMES[4], sb.toString());
            sf.setChangeable(false);
            return sf;
        }
        if (name.equals(FEATURE_NAMES[5])) {
            return new ChoiceFeature(FEATURE_NAMES[5], TERMINATORS, TERMINATORS.get(this.m_dimensionLineTerminator));
        }
        if (name.equals(FEATURE_NAMES[6])) {
            if (this._isP1Left()) {
                return new ChoiceFeature(FEATURE_NAMES[6], PROJECTION_LINE, PROJECTION_LINE.get(this.m_projectionLineLeft));
            }
            return new ChoiceFeature(FEATURE_NAMES[6], PROJECTION_LINE, PROJECTION_LINE.get(this.m_projectionLineRight));
        }
        if (name.equals(FEATURE_NAMES[7])) {
            if (this._isP1Left()) {
                return new ChoiceFeature(FEATURE_NAMES[7], PROJECTION_LINE, PROJECTION_LINE.get(this.m_projectionLineRight));
            }
            return new ChoiceFeature(FEATURE_NAMES[7], PROJECTION_LINE, PROJECTION_LINE.get(this.m_projectionLineLeft));
        }
        if (name.equals(FEATURE_NAMES[8])) {
            if (this._isP1Left()) {
                return new DoubleFeature(FEATURE_NAMES[8], this.m_projectionLineLeftValue);
            }
            return new DoubleFeature(FEATURE_NAMES[8], this.m_projectionLineRightValue);
        }
        if (name.equals(FEATURE_NAMES[9])) {
            if (this._isP1Left()) {
                return new DoubleFeature(FEATURE_NAMES[9], this.m_projectionLineRightValue);
            }
            return new DoubleFeature(FEATURE_NAMES[9], this.m_projectionLineLeftValue);
        }
        if (name.equals(FEATURE_NAMES[10])) {
            return new DoubleFeature(FEATURE_NAMES[10], this.m_projectionLineExtension);
        }
        if (name.equals(FEATURE_NAMES[11])) {
            Point2DFeature pf = new Point2DFeature(FEATURE_NAMES[11], this.getPt());
            return pf;
        }
        if (name.equals(FEATURE_NAMES[12])) {
            if (this._isP1Left()) {
                return new ChoiceFeature(FEATURE_NAMES[12], TEXT_JUSTIFICATION, TEXT_JUSTIFICATION.get(this.m_textJustification));
            }
            if (this.m_textJustification == 1) {
                return new ChoiceFeature(FEATURE_NAMES[12], TEXT_JUSTIFICATION, TEXT_JUSTIFICATION.get(2));
            }
            if (this.m_textJustification == 2) {
                return new ChoiceFeature(FEATURE_NAMES[12], TEXT_JUSTIFICATION, TEXT_JUSTIFICATION.get(1));
            }
            return new ChoiceFeature(FEATURE_NAMES[12], TEXT_JUSTIFICATION, TEXT_JUSTIFICATION.get(this.m_textJustification));
        }
        if (name.equals(FEATURE_NAMES[13])) {
            return new StringFeature(FEATURE_NAMES[13], this.getPrefix() == null ? "" : this.getPrefix());
        }
        if (name.equals(FEATURE_NAMES[14])) {
            return new StringFeature(FEATURE_NAMES[14], this.getPostfix() == null ? "" : this.getPostfix());
        }
        if (name.equals(FEATURE_NAMES[15])) {
            return new DoubleFeature(FEATURE_NAMES[15], this.getTextScale());
        }
        if (name.equals(FEATURE_NAMES[16])) {
            return new ChoiceFeature(FEATURE_NAMES[16], FORMATS, FORMATS.get(this.m_textUnit));
        }
        if (name.equals(FEATURE_NAMES[17])) {
            StringFeature f = new StringFeature(FEATURE_NAMES[17], this.getFormat() == null ? DEFAULT_FREE_FORMAT : this.getFormat());
            f.setChangeable(this.m_textUnit == 5);
            return f;
        }
        if (name.equals(FEATURE_NAMES[18])) {
            DoubleFeature f = new DoubleFeature(FEATURE_NAMES[18], this.getMMPerUnit());
            f.setChangeable(this.m_textUnit == 5);
            return f;
        }
        if (name.equals(FEATURE_NAMES[19])) {
            StringFeature f = new StringFeature(FEATURE_NAMES[19], this.getFreeText() == null ? DEFAULT_FREE_TEXT : this.getFreeText());
            f.setChangeable(this.m_textUnit == 6);
            return f;
        }
        if (name.equals(FEATURE_NAMES[20])) {
            return new StringFeature(FEATURE_NAMES[20], this.getHeightText() == null ? "" : this.getHeightText());
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        Point2D p1 = this.getP1();
        Point2D p2 = this.getP2();
        Point2D pd = this.getPd();
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            p1 = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[1])) {
            p2 = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[2])) {
            double angleNU = ((AngleFeature)feature).getAngle();
            this.setAngle(angleNU);
        } else if (feature.getName().equals(FEATURE_NAMES[3])) {
            pd = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[5])) {
            this.m_dimensionLineTerminator = ((ChoiceFeature)feature).valueIndex();
        } else if (feature.getName().equals(FEATURE_NAMES[6])) {
            if (this._isP1Left()) {
                this.m_projectionLineLeft = ((ChoiceFeature)feature).valueIndex();
            } else {
                this.m_projectionLineRight = ((ChoiceFeature)feature).valueIndex();
            }
        } else if (feature.getName().equals(FEATURE_NAMES[7])) {
            if (this._isP1Left()) {
                this.m_projectionLineRight = ((ChoiceFeature)feature).valueIndex();
            } else {
                this.m_projectionLineLeft = ((ChoiceFeature)feature).valueIndex();
            }
        } else if (feature.getName().equals(FEATURE_NAMES[8])) {
            if (this._isP1Left()) {
                this.m_projectionLineLeftValue = ((DoubleFeature)feature).getDoubleValue();
            } else {
                this.m_projectionLineRightValue = ((DoubleFeature)feature).getDoubleValue();
            }
        } else if (feature.getName().equals(FEATURE_NAMES[9])) {
            if (this._isP1Left()) {
                this.m_projectionLineRightValue = ((DoubleFeature)feature).getDoubleValue();
            } else {
                this.m_projectionLineLeftValue = ((DoubleFeature)feature).getDoubleValue();
            }
        } else if (feature.getName().equals(FEATURE_NAMES[10])) {
            this.m_projectionLineExtension = ((DoubleFeature)feature).getDoubleValue();
        } else if (feature.getName().equals(FEATURE_NAMES[11])) {
            this.setPt((Point2D)feature.getValue());
        } else if (feature.getName().equals(FEATURE_NAMES[12])) {
            int value = ((ChoiceFeature)feature).valueIndex();
            this.m_textJustification = this._isP1Left() ? value : (value == 1 ? 2 : (value == 2 ? 1 : value));
        } else if (feature.getName().equals(FEATURE_NAMES[13])) {
            this.setPrefix(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[14])) {
            this.setPostfix(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[15])) {
            this.setTextScale((Double)feature.getValue());
        } else if (feature.getName().equals(FEATURE_NAMES[16])) {
            this.m_textUnit = ((ChoiceFeature)feature).valueIndex();
        } else if (feature.getName().equals(FEATURE_NAMES[17])) {
            this.setFormat(feature.valueToString(), this.getMMPerUnit());
        } else if (feature.getName().equals(FEATURE_NAMES[18])) {
            this.setFormat(this.getFormat(), (Double)feature.getValue());
        } else if (feature.getName().equals(FEATURE_NAMES[19])) {
            this.setFreeText(feature.valueToString());
        } else if (feature.getName().equals(FEATURE_NAMES[20])) {
            this.setHeightText(feature.valueToString());
        } else {
            super.setFeature(feature);
            return;
        }
        this.setDimension(p1, p2, pd);
        this._notifyWasChanged();
    }

    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentDimSingle.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

