/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.layer.SelLayer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;

public class LayerSelector {
    private static LayerSelector s_instance = null;
    private Kernel m_krnl;
    private String m_layerName = null;
    private boolean m_aborted = false;

    private LayerSelector(Kernel krnl) {
        if (s_instance == null) {
            s_instance = this;
        }
        this.m_krnl = krnl;
    }

    public static LayerSelector getLayerSelector(Kernel krnl) {
        if (s_instance == null) {
            new LayerSelector(krnl);
        }
        return s_instance;
    }

    public String select() throws CmdAbortedException {
        return this.select(Messages.getString("db.layer.LayerSelector.0"));
    }

    public String select(String prompt) throws CmdAbortedException {
        final SelLayer selLayer = new SelLayer(this.m_krnl);
        selLayer.setPrompt(prompt);
        selLayer.addListener(new SelLayer.Listener(){

            @Override
            public void layerSelected(String name) {
                LayerSelector.this.m_layerName = name;
                LayerSelector.this.m_aborted = false;
                selLayer.dispose();
            }

            @Override
            public void dialogAborted() {
                LayerSelector.this.m_aborted = true;
                selLayer.dispose();
            }
        });
        selLayer.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return this.m_layerName;
    }
}

