/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.Marker;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.ComponentCircle2D;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.Layer;
import cib.cad.ext.dxf.ExportArc;
import cib.cad.ext.dxf.ExportBlockReference;
import cib.cad.ext.dxf.ExportCircle;
import cib.cad.ext.dxf.ExportEntityHeader;
import cib.cad.ext.dxf.ExportHatch;
import cib.cad.ext.dxf.ExportLWPolyline;
import cib.cad.ext.dxf.ExportLine;
import cib.cad.ext.dxf.ExportLinetypeEntries;
import cib.cad.ext.dxf.ExportStyleEntries;
import cib.cad.ext.dxf.ExportText;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.View;
import cib.cad.lang.Messages;
import cib.cad.view.BasicViewController;
import cib.cad.view.TextView;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ExportDXF
extends CmdAdapter {
    private DXFWriter m_writer = null;
    private double m_flatness = 0.005;
    private boolean m_textAsShape = false;
    private Graphics m_graphics = null;
    private int m_nCompsNotExportable = 0;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        String EXT = "dxf";
        File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".dxf");
            }

            @Override
            public String[] getExtensions() {
                return new String[]{"dxf"};
            }

            @Override
            public String getPrompt() {
                return Messages.getString("ext.dxf.ExportDXF.2");
            }

            @Override
            public boolean isOpenDialog() {
                return false;
            }

            @Override
            public File getCurrentFile() {
                return new File("out.dxf");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("ext.dxf.ExportDXF.3")) + " (*." + "dxf" + ")";
            }
        });
        if (file.exists()) {
            System.out.println(Messages.getString("ext.dxf.ExportDXF.6"));
        } else {
            System.out.println(Messages.getString("ext.dxf.ExportDXF.7"));
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return;
            }
        }
        if (!file.canWrite()) {
            System.err.println(String.valueOf(Messages.getString("ext.dxf.ExportDXF.8")) + file.getAbsolutePath());
            return;
        }
        this.m_flatness = krnl.readDouble(Messages.getString("ext.dxf.ExportDXF.9"), 0.005);
        this.m_textAsShape = krnl.readYesNo(Messages.getString("ext.dxf.ExportDXF.10"), 3);
        try {
            this.m_writer = new DXFWriter(file);
            BufferedImage img = new BufferedImage(1, 1, 2);
            this.m_graphics = ((Image)img).getGraphics();
            this.m_writer.startSection("HEADER");
            this.m_writer.writeGroup(GroupCode.GC9, "$ACADVER");
            this.m_writer.writeGroup(GroupCode.GC1, "AC1018");
            this.m_writer.writeGroup(GroupCode.GC9, "$HANDSEED");
            this.m_writer.writeGroup(GroupCode.GC5, "????????");
            this.m_writer.endSection();
            this.m_writer.startSection("TABLES");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "VPORT");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "LTYPE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "LTYPE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbLinetypeTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "ByBlock");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            this.m_writer.writeGroup(GroupCode.GC0, "LTYPE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbLinetypeTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "ByLayer");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            this.m_writer.writeGroup(GroupCode.GC0, "LTYPE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbLinetypeTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "Continuous");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            new ExportLinetypeEntries().commit(this.m_writer);
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "LAYER");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "LAYER");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbLayerTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "0");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            this.m_writer.writeGroup(GroupCode.GC390, "0");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "STYLE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "STYLE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbTextStyleTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "Standard");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            new ExportStyleEntries().commit(this.m_writer);
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "VIEW");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "UCS");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "APPID");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "APPID");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbRegAppTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "ACAD");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "DIMSTYLE");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC70, "1");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbDimStyleTable");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.writeGroup(GroupCode.GC0, "TABLE");
            this.m_writer.writeGroup(GroupCode.GC2, "BLOCK_RECORD");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTable");
            this.m_writer.writeGroup(GroupCode.GC0, "BLOCK_RECORD");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "*Model_Space");
            this.m_writer.writeGroup(GroupCode.GC0, "BLOCK_RECORD");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockTableRecord");
            this.m_writer.writeGroup(GroupCode.GC2, "*Paper_Space");
            HashMap<Group, String> groupNames = new HashMap<Group, String>();
            this._generateUniqueBlockNames(groupNames);
            Set groups = groupNames.keySet();
            for (Group group : groups) {
                this.m_writer.writeGroup(GroupCode.GC0, "BLOCK_RECORD");
                this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
                this.m_writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
                this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockTableRecord");
                this.m_writer.writeGroup(GroupCode.GC2, (String)groupNames.get(group));
            }
            this.m_writer.writeGroup(GroupCode.GC0, "ENDTAB");
            this.m_writer.endSection();
            this.m_writer.startSection("BLOCKS");
            this.m_writer.writeGroup(GroupCode.GC0, "BLOCK");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbEntity");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockBegin");
            this.m_writer.writeGroup(GroupCode.GC2, "*Model_Space");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDBLK");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbEntity");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockEnd");
            this.m_writer.writeGroup(GroupCode.GC0, "BLOCK");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbEntity");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockBegin");
            this.m_writer.writeGroup(GroupCode.GC2, "*Paper_Space");
            this.m_writer.writeGroup(GroupCode.GC70, "0");
            this.m_writer.writeGroup(GroupCode.GC0, "ENDBLK");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbEntity");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockEnd");
            this._exportBlocks(groupNames);
            this.m_writer.endSection();
            this.m_writer.startSection("ENTITIES");
            this._exportDatabase(groupNames);
            this.m_writer.endSection();
            this.m_writer.startSection("OBJECTS");
            this.m_writer.writeGroup(GroupCode.GC0, "DICTIONARY");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbDictionary");
            this.m_writer.writeGroup(GroupCode.GC3, "ACAD_GROUP");
            String handleACAD_GROUP = this.m_writer.nextHandle();
            this.m_writer.writeGroup(GroupCode.GC350, handleACAD_GROUP);
            this.m_writer.writeGroup(GroupCode.GC3, "ACAD_MLINESTYLE");
            String handleACAD_MLINESTYPE = this.m_writer.nextHandle();
            this.m_writer.writeGroup(GroupCode.GC350, handleACAD_MLINESTYPE);
            this.m_writer.writeGroup(GroupCode.GC0, "DICTIONARY");
            this.m_writer.writeGroup(GroupCode.GC5, handleACAD_GROUP);
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbDictionary");
            this.m_writer.writeGroup(GroupCode.GC0, "DICTIONARY");
            this.m_writer.writeGroup(GroupCode.GC5, handleACAD_MLINESTYPE);
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbDictionary");
            this.m_writer.endSection();
            this.m_writer.endFile();
            String status = this.m_nCompsNotExportable == 0 ? Messages.getString("ext.dxf.ExportDXF.124") : String.valueOf(Messages.getString("ext.dxf.ExportDXF.125")) + this.m_nCompsNotExportable + Messages.getString("ext.dxf.ExportDXF.126");
            krnl.readOK(Messages.getString("ext.dxf.ExportDXF.127"), Messages.getString("ext.dxf.ExportDXF.128"), status, 6);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                message = Messages.getString("ext.dxf.ExportDXF.129");
            }
            krnl.readOK(Messages.getString("ext.dxf.ExportDXF.130"), Messages.getString("ext.dxf.ExportDXF.131"), message, 14);
        }
    }

    private void _exportHeader(_DXFAttributes attr, ExportEntityHeader entity) throws IOException {
        Paint paint = attr.m_paint;
        if (paint instanceof Color) {
            entity.setColor((Color)paint);
        }
        entity.setLayer(attr.m_layerName);
        entity.setLineType(attr.m_linePatternName);
        entity.setLineWidthInMM(attr.m_lineWidthInMM);
        entity.setVisibility(attr.m_isVisible);
    }

    private boolean _exportGroup(String name, _DXFAttributes attr) throws IOException {
        ExportBlockReference entity = new ExportBlockReference(name);
        this._exportHeader(attr, entity);
        return entity.commit(this.m_writer);
    }

    private boolean _exportLine(double x1, double y1, double x2, double y2, _DXFAttributes attr) throws IOException {
        ExportLine entity = new ExportLine(x1, y1, x2, y2);
        this._exportHeader(attr, entity);
        return entity.commit(this.m_writer);
    }

    private boolean _exportCircle(double centerX, double centerY, double radius, _DXFAttributes attr) throws IOException {
        ExportCircle entity = new ExportCircle(centerX, centerY, radius);
        this._exportHeader(attr, entity);
        return entity.commit(this.m_writer);
    }

    private boolean _exportArc(double centerX, double centerY, double radius, double startAngle, double endAngle, _DXFAttributes attr) throws IOException {
        ExportArc entity = new ExportArc(centerX, centerY, radius, startAngle, endAngle);
        this._exportHeader(attr, entity);
        return entity.commit(this.m_writer);
    }

    private boolean _exportShape(AttributedShape shape, double flatness, _DXFAttributes attr) throws IOException {
        ExportLWPolyline entity = new ExportLWPolyline();
        this._exportHeader(attr, entity);
        entity.setShape(shape);
        entity.setFlatness(flatness);
        return entity.commit(this.m_writer);
    }

    private boolean _exportHatch(AttributedShape shape, double flatness, _DXFAttributes attr) throws IOException {
        ExportHatch entity = new ExportHatch(shape, flatness);
        this._exportHeader(attr, entity);
        return entity.commit(this.m_writer);
    }

    private boolean _exportText(AttributedText at, TextView tv, _DXFAttributes attr) throws IOException {
        ExportText entity = new ExportText(at, tv);
        this._exportHeader(attr, entity);
        return entity.commit(this.m_writer);
    }

    private void _generateUniqueBlockNames(Map<Group, String> groupNames) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this._generateUniqueBlockNames(cmpSet, groupNames, 0);
    }

    private int _generateUniqueBlockNames(Set<Component> cmpSet, Map<Group, String> groupNames, int inc) {
        Kernel krnl = Kernel.getInstance();
        for (Component comp : cmpSet) {
            if (!(comp instanceof Group)) continue;
            Group group = (Group)comp;
            groupNames.put(group, "CADEMIA-" + ++inc);
            cmpSet = group.getComponentSet();
            krnl.openGroup(group, true);
            inc = this._generateUniqueBlockNames(cmpSet, groupNames, inc);
        }
        krnl.closeGroup();
        return inc;
    }

    private void _exportBlocks(Map<Group, String> groupNames) throws IOException {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this._exportBlocks(cmpSet, groupNames);
    }

    private void _exportBlocks(Set<Component> cmpSet, Map<Group, String> groupNames) throws IOException {
        Kernel krnl = Kernel.getInstance();
        HashSet<Group> groups = new HashSet<Group>();
        for (Component comp : cmpSet) {
            if (!(comp instanceof Group)) continue;
            groups.add((Group)comp);
        }
        for (Group group : groups) {
            String blockName = groupNames.get(group);
            this.m_writer.writeGroup(GroupCode.GC0, "BLOCK");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbEntity");
            this.m_writer.writeGroup(GroupCode.GC8, "0");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockBegin");
            this.m_writer.writeGroup(GroupCode.GC2, blockName);
            this.m_writer.writeGroup(GroupCode.GC70, 0);
            this.m_writer.writeGroup(GroupCode.GC10, 0.0);
            this.m_writer.writeGroup(GroupCode.GC20, 0.0);
            this.m_writer.writeGroup(GroupCode.GC30, 0.0);
            this.m_writer.writeGroup(GroupCode.GC3, blockName);
            krnl.openGroup(group, true);
            this._exportDatabase(groupNames);
            krnl.closeGroup();
            this.m_writer.writeGroup(GroupCode.GC0, "ENDBLK");
            this.m_writer.writeGroup(GroupCode.GC5, this.m_writer.nextHandle());
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbEntity");
            this.m_writer.writeGroup(GroupCode.GC8, "0");
            this.m_writer.writeGroup(GroupCode.GC100, "AcDbBlockEnd");
        }
        for (Group group : groups) {
            ObservableSet<Component> _cmpSet = group.getComponentSet();
            krnl.openGroup(group, true);
            this._exportBlocks(_cmpSet, groupNames);
            krnl.closeGroup();
        }
    }

    private void _exportDatabase(Map<Group, String> groupNames) throws IOException {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        NameSpace ns = db.getNameSpace();
        AttributeManager atm = db.getAttributeManager();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        for (Component comp : cmpSet) {
            NamedListIterator<AttributedText> textIt;
            _DXFAttributes dxfAttr;
            block10: {
                AttributedShape shape;
                Paint fillPaint;
                block14: {
                    block16: {
                        Point2D ctr;
                        double sweepAngle;
                        double radius;
                        ComponentArc2D compArc;
                        block15: {
                            block12: {
                                block13: {
                                    block11: {
                                        block9: {
                                            Attributes attr = comp.getAttributes();
                                            dxfAttr = new _DXFAttributes();
                                            Layer l = (Layer)layerMap.get(comp);
                                            dxfAttr.m_layerName = ns.getName(l);
                                            String drawPaintName = attr.getDrawPaint();
                                            dxfAttr.m_paint = (Paint)(comp instanceof Group && drawPaintName.equals("DEFAULT") ? null : atm.getDrawPaint(drawPaintName));
                                            dxfAttr.m_linePatternName = attr.getLinePattern();
                                            String strLineWidth = attr.getLineWidth();
                                            dxfAttr.m_lineWidthInMM = atm.getLineWidth(strLineWidth);
                                            String strVisibility = attr.getVisibility();
                                            dxfAttr.m_isVisible = atm.getVisibility(strVisibility);
                                            String fillPaintName = attr.getFillPaint();
                                            Paint paint = fillPaint = fillPaintName.equals("DEFAULT") ? null : atm.getDrawPaint(fillPaintName);
                                            if (!(comp instanceof Group)) break block9;
                                            String name = groupNames.get(comp);
                                            if (!this._exportGroup(name, dxfAttr)) {
                                                ++this.m_nCompsNotExportable;
                                            }
                                            break block10;
                                        }
                                        if (!(comp instanceof ComponentLine2D)) break block11;
                                        ComponentLine2D compLine = (ComponentLine2D)comp;
                                        if (!this._exportLine(compLine.getX1(), compLine.getY1(), compLine.getX2(), compLine.getY2(), dxfAttr)) {
                                            ++this.m_nCompsNotExportable;
                                        }
                                        break block10;
                                    }
                                    if (!(comp instanceof ComponentCircle2D)) break block12;
                                    ComponentCircle2D compCircle = (ComponentCircle2D)comp;
                                    if (this._exportCircle(compCircle.getCenterX(), compCircle.getCenterY(), compCircle.getRadius(), dxfAttr)) break block13;
                                    ++this.m_nCompsNotExportable;
                                    break block10;
                                }
                                if (fillPaint == null) break block10;
                                dxfAttr.m_paint = fillPaint;
                                shape = comp.getShape(0);
                                this._exportHatch(shape, this.m_flatness, dxfAttr);
                                break block10;
                            }
                            if (!(comp instanceof ComponentArc2D)) break block14;
                            compArc = (ComponentArc2D)comp;
                            radius = compArc.radius();
                            if (!Double.isNaN(radius)) break block15;
                            Point2D sp = compArc.getStartPoint(new Point2D.Double());
                            Point2D ep = compArc.getEndPoint(new Point2D.Double());
                            if (!this._exportLine(sp.getX(), sp.getY(), ep.getX(), ep.getY(), dxfAttr)) {
                                ++this.m_nCompsNotExportable;
                            }
                            break block10;
                        }
                        double startAngle = Math.toDegrees(compArc.startAngle());
                        double endAngle = startAngle + (sweepAngle = Math.toDegrees(compArc.sweepAngle()));
                        if (endAngle < startAngle) {
                            double tmp = startAngle;
                            startAngle = endAngle;
                            endAngle = tmp;
                        }
                        if (this._exportArc((ctr = compArc.centerPoint(new Point2D.Double())).getX(), ctr.getY(), radius, startAngle, endAngle, dxfAttr)) break block16;
                        ++this.m_nCompsNotExportable;
                        break block10;
                    }
                    if (fillPaint == null) break block10;
                    dxfAttr.m_paint = fillPaint;
                    AttributedShape shape2 = comp.getShape(0);
                    this._exportHatch(shape2, this.m_flatness, dxfAttr);
                    break block10;
                }
                NamedListIterator<AttributedShape> shapeIt = comp.shapeIterator();
                while (shapeIt.hasNext()) {
                    shape = (AttributedShape)shapeIt.next();
                    if (!this._exportShape(shape, this.m_flatness, dxfAttr)) {
                        ++this.m_nCompsNotExportable;
                        continue;
                    }
                    if (fillPaint == null) continue;
                    dxfAttr.m_paint = fillPaint;
                    this._exportHatch(shape, this.m_flatness, dxfAttr);
                }
            }
            if (comp instanceof Group || !(textIt = comp.textIterator()).hasNext()) continue;
            BasicViewController vc = new BasicViewController();
            vc.setMinTextHeight(0.0);
            vc.setComponent(comp, new Marker(3), true);
            AffineTransform m2v = new AffineTransform();
            vc.updateViews(m2v, null, -1, this.m_graphics);
            ListIterator<View> viewIt = vc.viewIterator();
            while (viewIt.hasNext()) {
                View v = viewIt.next();
                if (!(v instanceof TextView)) continue;
                TextView tv = (TextView)v;
                if (this.m_textAsShape) {
                    Shape shape = tv.getBoundaryShape();
                    Paint paint = tv.getBoundaryBorderPaint();
                    AttributedShape as = new AttributedShape(shape, null, paint, null);
                    dxfAttr.m_lineWidthInMM = 0.0;
                    if (this._exportHatch(as, this.m_flatness, dxfAttr)) continue;
                    ++this.m_nCompsNotExportable;
                    continue;
                }
                AttributedText at = (AttributedText)textIt.next();
                if (this._exportText(at, tv, dxfAttr)) continue;
                ++this.m_nCompsNotExportable;
            }
        }
    }

    private class _DXFAttributes {
        private Paint m_paint = null;
        private String m_layerName = null;
        private String m_linePatternName = null;
        private double m_lineWidthInMM = -1.0;
        private boolean m_isVisible = true;

        private _DXFAttributes() {
        }
    }
}

