/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.Marker;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.comp.ComponentText2D;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.View;
import cib.cad.view.BasicViewController;
import cib.cad.view.TextView;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ImportText {
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
    private static final AffineTransform FLIP_Y = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static Graphics2D s_gfx = null;

    public static ComponentText2D create(Kernel krnl, Attributes atts, Map<String, Attributes> styles) {
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        double scale = cs.getScale();
        String text = atts.getValue(GroupCode.GC1);
        text = ImportText.replaceCtrlSequences(text);
        double encodedScale = ImportText.getEncodedScale(text);
        text = ImportText.removeBackslashSequences(text);
        AttributedString as = new AttributedString(text);
        String entityType = atts.getValue(GroupCode.GC0);
        int hJustification = atts.getIntValue(GroupCode.GC72, 0);
        int vJustification = entityType.equals("TEXT") ? atts.getIntValue(GroupCode.GC73, 0) : atts.getIntValue(GroupCode.GC74, 0);
        double _x0 = atts.getDoubleValue(GroupCode.GC10);
        double _y0 = atts.getDoubleValue(GroupCode.GC20);
        double _z0 = atts.getDoubleValue(GroupCode.GC30, 0.0);
        double _x1 = atts.getDoubleValue(GroupCode.GC11, _x0);
        double _y1 = atts.getDoubleValue(GroupCode.GC21, _y0);
        double _z1 = atts.getDoubleValue(GroupCode.GC31, _z0);
        double _angle = Math.toRadians(atts.getDoubleValue(GroupCode.GC50, 0.0));
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(atts);
        double x = ocs.getXinWCS(_x1, _y1, _z1);
        double y = ocs.getYinWCS(_x1, _y1, _z1);
        double xBase = ocs.getXinWCS(_x0, _y0, _z0);
        double yBase = ocs.getYinWCS(_x0, _y0, _z0);
        Vector2D vecAngleOCS = new Vector2D(_angle);
        Vector2D vecAngleWCS = new Vector2D(ocs.getXinWCS(vecAngleOCS.x, vecAngleOCS.y, 0.0), ocs.getYinWCS(vecAngleOCS.x, vecAngleOCS.y, 0.0));
        double angleWCS = Vector2D.X_UNIT.getAngleCCW(vecAngleWCS);
        AffineTransform at = new AffineTransform();
        if (hJustification == 3 || hJustification == 5) {
            at.translate(xBase, yBase);
        } else {
            at.translate(x, y);
        }
        at.rotate(angleWCS);
        int flip = atts.getIntValue(GroupCode.GC71, 0);
        if ((flip & 2) != 0) {
            at.concatenate(FLIP_Y);
        } else if ((flip & 4) != 0) {
            at.concatenate(FLIP_X);
        } else if ((flip & 6) != 0) {
            at.rotate(Math.PI);
        }
        cib.cad.db.att.Attributes attr = new cib.cad.db.att.Attributes();
        double height = atts.getDoubleValue(GroupCode.GC40) * encodedScale;
        double paperHeightInMm = height * cs.getMillimetersPerNaturalUnit() / scale;
        String textSizeName = ImportText.findOrCreateTextSize(paperHeightInMm);
        attr.setTextSize(textSizeName);
        String textStyle = atts.getValue(GroupCode.GC7, "STANDARD");
        Attributes fontAttributes = styles.get(textStyle);
        String fontFamilyName = "DEFAULT";
        if (fontAttributes != null) {
            fontFamilyName = fontAttributes.getValue(GroupCode.GC2, "DEFAULT");
        }
        attr.setFontFamily(fontFamilyName);
        ComponentText2D comp = new ComponentText2D(as, at);
        comp.setAttributes(attr);
        int justification = 0;
        block0 : switch (vJustification) {
            case 3: {
                switch (hJustification) {
                    case 2: {
                        justification = 8;
                        break block0;
                    }
                    case 1: {
                        justification = 5;
                        break block0;
                    }
                }
                justification = 2;
                break;
            }
            case 2: {
                switch (hJustification) {
                    case 2: {
                        justification = 7;
                        break block0;
                    }
                    case 1: {
                        justification = 4;
                        break block0;
                    }
                }
                justification = 1;
                break;
            }
            case 1: {
                switch (hJustification) {
                    case 2: {
                        justification = 11;
                        break block0;
                    }
                    case 1: {
                        justification = 10;
                        break block0;
                    }
                }
                justification = 9;
                break;
            }
            default: {
                switch (hJustification) {
                    case 2: {
                        justification = 6;
                        break block0;
                    }
                    case 3: 
                    case 5: {
                        justification = 0;
                        break block0;
                    }
                    case 1: 
                    case 4: {
                        justification = 3;
                        break block0;
                    }
                }
                justification = 0;
            }
        }
        comp.setJustification(justification);
        double scaleX = atts.getDoubleValue(GroupCode.GC41, 1.0);
        comp.setScaleInTextDirection(scaleX);
        if (hJustification > 2) {
            NamedListIterator<AttributedText> textIt;
            double textLen = Geo2D.distance(x, y, xBase, yBase);
            if (hJustification == 4) {
                textLen *= 2.0;
            }
            if ((textIt = comp.textIterator()).hasNext()) {
                TextView tv;
                double boundingWidth;
                View v;
                BasicViewController vc = new BasicViewController();
                vc.setMinTextHeight(0.0);
                vc.setComponent(comp, new Marker(3), true);
                AffineTransform m2v = new AffineTransform();
                vc.updateViews(m2v, null, -1, ImportText.getGraphics());
                ListIterator<View> viewIt = vc.viewIterator();
                if (viewIt.hasNext() && (v = viewIt.next()) instanceof TextView && (boundingWidth = (tv = (TextView)v).getBoundingWidth() * tv.getDotsPerPt()) > Geo2D.getEps()) {
                    scaleX = textLen / boundingWidth;
                    comp.setScaleInTextDirection(scaleX);
                }
            }
        }
        return comp;
    }

    public static String findOrCreateTextSize(double height) {
        AttributeManager atm = AttributeManager.getAttributeManager();
        if (height < 0.1) {
            height = 0.1;
        }
        Set<String> textSizeNames = atm.getTextSizes();
        for (String name : textSizeNames) {
            double size = atm.getTextSize(name);
            if (!(Math.abs(size - height) < 0.1)) continue;
            return name;
        }
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        nf.applyLocalizedPattern("0.0");
        String name = nf.format(height);
        try {
            height = Double.parseDouble(name);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        atm.addTextSize(name, height);
        return name;
    }

    public static String replaceCtrlSequences(String in) {
        StringBuffer out = new StringBuffer();
        int n = in.length();
        boolean underline = false;
        boolean overline = false;
        int i = 0;
        while (i < n) {
            if (i < n - 2 && in.charAt(i) == '%' && in.charAt(++i) == '%') {
                char c0;
                if ((c0 = in.charAt(++i)) == '%') {
                    out.append('%');
                } else if (c0 == 'd') {
                    out.append(272);
                } else if (c0 == 'p') {
                    out.append(261);
                } else if (c0 == 'c') {
                    out.append(330);
                } else if (c0 == 'u') {
                    underline = !underline;
                } else if (c0 == 'o') {
                    overline = !overline;
                } else if (i < n - 1) {
                    char c1 = in.charAt(++i);
                    char c2 = in.charAt(++i);
                    try {
                        int code = Integer.parseInt(new String(new char[]{c0, c1, c2}));
                        out.append((char)code);
                    }
                    catch (NumberFormatException e) {
                        out.append("%%" + c0 + c1 + c2);
                    }
                } else {
                    out.append("%%" + c0);
                }
            } else {
                out.append(in.charAt(i));
                if (underline) {
                    out.append('\u0332');
                }
                if (overline) {
                    out.append('\u0305');
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static double getEncodedScale(String text) {
        StringTokenizer strTok = new StringTokenizer(text, ";{}");
        while (strTok.hasMoreTokens()) {
            text = strTok.nextToken();
            if (!text.startsWith("\\H") || !text.endsWith("x")) continue;
            try {
                return Double.parseDouble(text.substring(2, text.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0;
    }

    public static String removeBackslashSequences(String in) {
        String out = in;
        StringTokenizer strTok = new StringTokenizer(out, ";{}");
        while (strTok.hasMoreTokens()) {
            out = strTok.nextToken();
        }
        return out;
    }

    private static Graphics2D getGraphics() {
        if (s_gfx == null) {
            BufferedImage img = new BufferedImage(1, 1, 2);
            s_gfx = (Graphics2D)((Image)img).getGraphics();
        }
        return s_gfx;
    }
}

