/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.SplitSegments;
import cib.cad.ext.mod.ToPath;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;

public class BreakSegments
extends UndoableCmd {
    private String m_toString = null;
    private ToPath m_toPathCmd = new ToPath();

    public static boolean isDoable() {
        return SplitSegments.isDoable();
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        boolean segmentNotBreakable = false;
        this.m_toPathCmd.doCmd(context);
        Iterator it = selSet.iterator();
        int nBrokenSegments = 0;
        while (it.hasNext()) {
            int name;
            Component comp = (Component)it.next();
            if (!(comp instanceof CtrlSegments) || !mm.hasMarkedPrimitives(comp, 2)) continue;
            CtrlSegments ctrlSegs = (CtrlSegments)comp;
            this._saveState(comp);
            HashSet<Integer> segNames = new HashSet<Integer>();
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                name = lit.previousName();
                if (mm.primitiveMarked(comp, 2, index) && (ctrlSegs.getCtrlType(name) & 0xFC) != 0) {
                    segNames.add(name);
                }
                mm.markPrimitive(comp, 2, index, false);
            }
            Iterator sit = segNames.iterator();
            comp.removeControlPointStarts();
            while (sit.hasNext()) {
                name = (Integer)sit.next();
                try {
                    int seg1 = ctrlSegs.split(name);
                    int seg2 = ctrlSegs.split(name);
                    ctrlSegs.split(seg1);
                    comp.removeControlPoint(seg2);
                    comp.removeControlPoint(seg1);
                    ++nBrokenSegments;
                }
                catch (UnsupportedOperationException e) {
                    segmentNotBreakable = true;
                }
            }
            comp.removeControlPointEnds();
        }
        String hints = "";
        if (segmentNotBreakable) {
            hints = String.valueOf(hints) + Messages.getString("ext.mod.BreakSegments.1");
        }
        if (!this.changesState()) {
            hints = String.valueOf(hints) + Messages.getString("ext.mod.BreakSegments.2");
        }
        if (hints.length() != 0) {
            krnl.readOK(Messages.getString("ext.mod.BreakSegments.3"), "CADEMIA", hints, 2);
        }
        if (this.changesState()) {
            this.m_toString = String.valueOf(Messages.getString("ext.mod.BreakSegments.5")) + nBrokenSegments + Messages.getString("ext.mod.BreakSegments.6");
            System.out.println(this);
        }
    }

    @Override
    public void undoCmd(Object context) {
        super.undoCmd(context);
        this.m_toPathCmd.undoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        this.m_toPathCmd.redoCmd(context);
        super.redoCmd(context);
    }

    @Override
    public boolean changesState() {
        return super.changesState() || this.m_toPathCmd.changesState();
    }

    @Override
    public boolean isUndoable() {
        return super.isUndoable() && this.m_toPathCmd.isUndoable();
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

