/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentGroup;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.binding.DefaultBindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class GroupComponents
implements Cmd {
    private ComponentGroup m_group = null;
    private BindingModel<Component> m_originalBindingModel = new DefaultBindingModel<Component>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return !selSet.isEmpty();
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            System.err.println(Messages.getString("ext.mod.GroupComponents.0"));
            return;
        }
        BindingModel<Component> bindingModel = db.getBindingModel();
        for (Component comp : selSet) {
            Binding binding = (Binding)bindingModel.get(comp);
            if (binding == null) continue;
            this.m_originalBindingModel.put(comp, (Binding)binding.clone());
        }
        this._createGroupFromSelectedComponents(context);
        System.out.println(this);
    }

    private void _createGroupFromSelectedComponents(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        BindingModel<Component> bindingModel = db.getBindingModel();
        DefaultBindingModel<Component> selBindingModel = new DefaultBindingModel<Component>();
        for (Component comp : selSet) {
            Binding binding = (Binding)bindingModel.get(comp);
            if (binding == null) continue;
            Set bindingComps = binding.getBindingObjects();
            bindingComps.retainAll(selSet);
            if (bindingComps.isEmpty()) continue;
            binding = (Binding)binding.clone();
            selBindingModel.put(comp, binding);
            bindingComps = binding.getBindingObjects();
            for (Component bindingComp : bindingComps) {
                if (selSet.contains(bindingComp)) continue;
                binding.removeBindingObject(bindingComp);
            }
        }
        NameSpace nameSpace = db.getNameSpace();
        HashMap<Component, String> compNames = new HashMap<Component, String>();
        ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
        HashMap<Component, Layer> compLayers = new HashMap<Component, Layer>();
        for (Component comp : selSet) {
            compNames.put(comp, nameSpace.getName(comp));
            compLayers.put(comp, (Layer)lm.get(comp));
        }
        this.m_group = new ComponentGroup(selSet, selBindingModel);
        this.m_group.setConfiguration(2);
        cmpSet.add(this.m_group);
        cmpSet.removeAll(selSet);
        ObservableSet<Component> comps = this.m_group.getComponentSet();
        for (Component comp : comps) {
            nameSpace.put(comp, (String)compNames.get(comp));
            lm.put(comp, (Layer)compLayers.get(comp));
        }
        selSet.add(this.m_group);
    }

    @Override
    public void undoCmd(Object context) {
        if (this.m_group != null) {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            ObservableSet<Component> selSet = db.getSelectSet();
            BindingModel<Component> bindingModel = db.getBindingModel();
            ObservableSet<Component> cmpSetGroup = this.m_group.getComponentSet();
            NameSpace nameSpace = db.getNameSpace();
            HashMap<Component, String> compNames = new HashMap<Component, String>();
            ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
            HashMap<Component, Layer> compLayers = new HashMap<Component, Layer>();
            for (Component comp : cmpSetGroup) {
                compNames.put(comp, nameSpace.getName(comp));
                compLayers.put(comp, (Layer)lm.get(comp));
            }
            cmpSet.remove(this.m_group);
            cmpSet.addAll(cmpSetGroup);
            selSet.addAll(cmpSetGroup);
            for (Component comp : cmpSetGroup) {
                nameSpace.put(comp, (String)compNames.get(comp));
                lm.put(comp, (Layer)compLayers.get(comp));
            }
            Collection bindings = this.m_originalBindingModel.values();
            for (Binding binding : bindings) {
                bindingModel.put((Component)binding.getBoundObject(), (Binding)binding.clone());
            }
        }
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_group != null) {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            ObservableSet<Component> selSet = db.getSelectSet();
            NameSpace nameSpace = db.getNameSpace();
            HashMap<Component, String> compNames = new HashMap<Component, String>();
            ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
            HashMap<Component, Layer> compLayers = new HashMap<Component, Layer>();
            for (Component comp : selSet) {
                compNames.put(comp, nameSpace.getName(comp));
                compLayers.put(comp, (Layer)lm.get(comp));
            }
            cmpSet.add(this.m_group);
            cmpSet.removeAll(selSet);
            ObservableSet<Component> comps = this.m_group.getComponentSet();
            for (Component comp : comps) {
                nameSpace.put(comp, (String)compNames.get(comp));
                lm.put(comp, (Layer)compLayers.get(comp));
            }
            selSet.add(this.m_group);
        }
    }

    @Override
    public boolean changesState() {
        return this.m_group != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("ext.mod.GroupComponents.1");
    }
}

