/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.CancelToken;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.NormDigitizeToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.CoordSpace;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CmdJournaler
extends Kernel.Listener {
    private String m_cmdName = null;
    private StringBuffer m_args = new StringBuffer();
    private File m_file = null;
    private FileWriter m_writer = null;
    private Set<Listener> m_listener = new HashSet<Listener>();
    private Kernel m_krnl = null;

    public CmdJournaler(File file, Kernel krnl) {
        this.m_krnl = krnl;
        try {
            this.m_file = file;
            this.m_writer = new FileWriter(this.m_file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cmdStarts(String cmdName) {
        this.m_cmdName = cmdName.equalsIgnoreCase("play") || cmdName.equalsIgnoreCase("stop") || cmdName.equalsIgnoreCase("suspend") || cmdName.equalsIgnoreCase("resume") || cmdName.equalsIgnoreCase("record") || cmdName.equalsIgnoreCase("contextmenu") ? null : cmdName;
    }

    @Override
    public void cmdEnds(String cmdName) {
        if (this.m_cmdName != null) {
            try {
                if (this.m_file.canWrite() && this.m_file.exists()) {
                    String record = String.valueOf(this.m_cmdName) + this.m_args.toString() + ';' + '\n';
                    this.m_writer.write(record);
                    this.m_writer.flush();
                    Iterator<Listener> it = this.m_listener.iterator();
                    while (it.hasNext()) {
                        it.next().cmdRecorded(record);
                    }
                } else {
                    System.err.println(String.valueOf(Messages.getString("kernel.CmdJournaler.6")) + this.m_file.getPath() + Messages.getString("kernel.CmdJournaler.7"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_cmdName = null;
        this.m_args.delete(0, this.m_args.length());
    }

    @Override
    public void tokenConsumed(CmdLineToken token) {
        if (token instanceof CancelToken) {
            this.m_cmdName = null;
        } else if (token instanceof DigitizeToken) {
            DigitizeToken t = (DigitizeToken)token;
            GeometryPanel gp = null;
            Iterator<GeometryPanel> pit = this.m_krnl.getUserInterface().geometryPanelIterator();
            int id = t.getWindow();
            while (gp == null && pit.hasNext()) {
                GeometryPanel _gp = pit.next();
                if (_gp.getId() != id) continue;
                gp = _gp;
            }
            if (gp == null) {
                throw new IllegalArgumentException(Messages.getString("kernel.CmdJournaler.8"));
            }
            this.m_args.append(" " + NormDigitizeToken.getNormDigitizeToken(gp, t));
        } else if (token instanceof TextToken) {
            this.m_args.append(" " + ((TextToken)token).toLiteral());
        } else {
            this.m_args.append(" " + token);
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public void init() {
        Iterator<Listener> lit;
        Iterator<GeometryPanel> it = this.m_krnl.getUserInterface().geometryPanelIterator();
        while (it.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)it.next();
            Rectangle2D viewPort = drawPanel.getProjection().getViewPort();
            try {
                if (this.m_file.canWrite() && this.m_file.exists()) {
                    String record = "setviewport " + viewPort.getMinX() + ' ' + viewPort.getMinY() + ' ' + viewPort.getMaxX() + ' ' + viewPort.getMaxY() + ' ' + drawPanel.getId() + ';' + '\n';
                    this.m_writer.write(record);
                    this.m_writer.flush();
                    lit = this.m_listener.iterator();
                    while (lit.hasNext()) {
                        lit.next().cmdRecorded(record);
                    }
                    continue;
                }
                System.err.println(String.valueOf(Messages.getString("kernel.CmdJournaler.13")) + this.m_file.getPath() + Messages.getString("kernel.CmdJournaler.14"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.m_file.canWrite() && this.m_file.exists()) {
                String record = "setconsettings";
                ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
                record = ConPoint2D.getRelCoordFlag() ? String.valueOf(record) + " #menu(Relative)" : String.valueOf(record) + " #menu(Absolute)";
                record = ConLineSeg2D.isOrthogonalMode() ? String.valueOf(record) + " #menu(Orthogonal)" : String.valueOf(record) + " #menu(Angular)";
                record = String.valueOf(record) + " #menu(Done);\n";
                this.m_writer.write(record);
                CoordSpace cs = CoordSpace.getCoordSpace();
                this.m_writer.write("setnaturalunit " + cs.getMillimetersPerNaturalUnit() + ";\n");
                this.m_writer.flush();
                lit = this.m_listener.iterator();
                while (lit.hasNext()) {
                    lit.next().cmdRecorded(record);
                }
            } else {
                System.err.println(String.valueOf(Messages.getString("kernel.CmdJournaler.28")) + this.m_file.getPath() + Messages.getString("kernel.CmdJournaler.29"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addListener(Listener l) {
        this.m_listener.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listener.remove(l);
    }

    public void removeAllListener() {
        this.m_listener.clear();
    }

    public static class Listener {
        public void cmdRecorded(String cmd) {
        }
    }
}

