/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentSymbol;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.AddText;
import cib.cad.lang.Messages;
import cib.util.AttributedShapeSerializable;
import cib.util.AttributedText;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.text.AttributedString;

public class AddSymbol
implements Cmd {
    private final double PT_PER_IN = 72.0;
    private final double IN_PER_M = 39.37;
    private final double PT_PER_MM = 2.83464;
    private ComponentSymbol m_comp = null;
    private transient Object m_input = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Point2D.Double plp = new Point2D.Double();
        krnl.getConstruction().point2D(plp);
        this.m_comp = new ComponentSymbol();
        this.m_comp.setControlPoint(plp, 0);
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
        try {
            block8: while (true) {
                CmdLineDialog dlg = ui.getCmdLineDialog();
                dlg.setUniqueName("kernel.cmds.AddSymbol-menu0");
                dlg.setPrompt(Messages.getString("kernel.cmds.AddSymbol.1"));
                dlg.enableTextInput(false);
                dlg.enableDigitize(0);
                dlg.setDefaultChoice(dlg.addChoice("Shape"));
                dlg.addChoice("Text");
                dlg.addChoice("Image");
                dlg.setChoiceEnabled(2, false);
                dlg.addSeparator();
                dlg.addChoice("Done");
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void choiceSelected(int iChoice) {
                        AddSymbol.this.m_input = new Integer(iChoice);
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        AddSymbol.this.m_input = new CmdAbortedException();
                        ui.disposeCmdLineDialog();
                    }
                });
                ui.showCmdLineDialog(dlg);
                if (this.m_input instanceof Integer) {
                    int iChoice = (Integer)this.m_input;
                    switch (iChoice) {
                        case 0: {
                            this._addShape();
                            continue block8;
                        }
                        case 1: {
                            this._addText();
                            continue block8;
                        }
                        case 2: {
                            continue block8;
                        }
                        case 3: {
                            System.out.println(this);
                            return;
                        }
                    }
                    System.err.println(Messages.getString("kernel.cmds.AddSymbol.6"));
                    continue;
                }
                if (this.m_input instanceof CmdAbortedException) break;
            }
            throw (CmdAbortedException)this.m_input;
        }
        catch (CmdAbortedException e) {
            cmpSet.remove(this.m_comp);
            throw (CmdAbortedException)this.m_input;
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        if (this.m_comp == null) {
            return super.toString();
        }
        Point2D plp = this.m_comp.getControlPoint(0);
        return String.valueOf(Messages.getString("kernel.cmds.AddSymbol.7")) + Geo2D.formatCoordinate(plp.getX()) + Messages.getString("kernel.cmds.AddSymbol.8") + Geo2D.formatCoordinate(plp.getY()) + Messages.getString("kernel.cmds.AddSymbol.9");
    }

    private void _addShape() throws CmdAbortedException {
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        BasicStroke stroke = null;
        Color drawPaint = null;
        Color fillPaint = null;
        boolean done = false;
        while (!done) {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.AddSymbol-menu1");
            dlg.setPrompt(Messages.getString("kernel.cmds.AddSymbol.11"));
            dlg.enableTextInput(false);
            dlg.enableDigitize(0);
            dlg.addChoice("Line width");
            dlg.setChoiceChecked(0, stroke != null);
            dlg.addChoice("Draw color");
            dlg.setChoiceChecked(1, drawPaint != null);
            dlg.addChoice("Fill color");
            dlg.setChoiceChecked(2, fillPaint != null);
            dlg.addSeparator();
            dlg.addChoice("Done");
            dlg.setDefaultChoice(3);
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    AddSymbol.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    AddSymbol.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        stroke = stroke != null ? null : new BasicStroke((float)krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.16"), 0.25), 1, 1);
                        break;
                    }
                    case 1: {
                        drawPaint = drawPaint != null ? null : krnl.readColor(Messages.getString("kernel.cmds.AddSymbol.17"));
                        break;
                    }
                    case 2: {
                        fillPaint = fillPaint != null ? null : krnl.readColor(Messages.getString("kernel.cmds.AddSymbol.18"));
                        break;
                    }
                    case 3: {
                        done = true;
                        break;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddSymbol.19"));
                        break;
                    }
                }
                continue;
            }
            if (!(this.m_input instanceof CmdAbortedException)) continue;
            throw (CmdAbortedException)this.m_input;
        }
        Path2D.Double path = new Path2D.Double();
        AttributedShapeSerializable attributedShape = new AttributedShapeSerializable((Shape)path, stroke, drawPaint, fillPaint);
        int iShape = this.m_comp.addPaperUnitsShape(attributedShape);
        double x = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.20"));
        double y = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.21"));
        ((Path2D)path).moveTo(x, y);
        while (true) {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.AddSymbol-menu2");
            dlg.setPrompt(Messages.getString("kernel.cmds.AddSymbol.23"));
            dlg.enableTextInput(false);
            dlg.enableDigitize(0);
            dlg.addChoice("Move");
            dlg.setDefaultChoice(dlg.addChoice("Line"));
            dlg.addChoice("Arc");
            dlg.addChoice("Close");
            dlg.addSeparator();
            dlg.addChoice("Done");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    AddSymbol.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    AddSymbol.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        x = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.29"));
                        y = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.30"));
                        ((Path2D)path).moveTo(x, y);
                        break;
                    }
                    case 1: {
                        x = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.31"));
                        y = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.32"));
                        ((Path2D)path).lineTo(x, y);
                        break;
                    }
                    case 2: {
                        double cx = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.33"));
                        double cy = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.34"));
                        double sweepAngle = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.35"));
                        double r = Math.sqrt((cx - x) * (cx - x) + (cy - y) * (cy - y));
                        double startAngle = Math.toDegrees(Math.atan2(y - cy, x - cx));
                        Arc2D.Double arc = new Arc2D.Double(cx - r, cy - r, r + r, r + r, -startAngle, -sweepAngle, 0);
                        path.append(arc, true);
                        break;
                    }
                    case 3: {
                        path.closePath();
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddSymbol.36"));
                        break;
                    }
                }
            } else if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            this.m_comp.setPaperUnitsShape(attributedShape, iShape);
            ui.updateUserInterface();
        }
    }

    private void _addText() throws CmdAbortedException {
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        double x = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.37"));
        double y = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.38"));
        double size = 3.5;
        Color paint = Color.BLACK;
        String fontFamily = "SansSerif";
        double angle = 0.0;
        int justification = 0;
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.AddSymbol-menu3");
            dlg.setPrompt(Messages.getString("kernel.cmds.AddSymbol.41"));
            dlg.enableTextInput(false);
            dlg.enableDigitize(0);
            dlg.addChoice("Size");
            dlg.setChoiceChecked(0, size < 3.5 - Geo2D.getEps() || size > 3.5 + Geo2D.getEps());
            dlg.addChoice("Family");
            dlg.setChoiceChecked(1, !fontFamily.equalsIgnoreCase("SansSerif"));
            dlg.addChoice("Color");
            dlg.setChoiceChecked(2, !paint.equals(Color.BLACK));
            dlg.addSeparator();
            dlg.addChoice("Angle");
            dlg.setChoiceChecked(3, angle < -Geo2D.getEps() || angle > Geo2D.getEps());
            dlg.addChoice("Justification");
            dlg.setChoiceChecked(4, justification != 0);
            dlg.addSeparator();
            dlg.addChoice("Done");
            dlg.setDefaultChoice(5);
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    AddSymbol.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    AddSymbol.this.m_input = text;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    AddSymbol.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        if (3.5 - Geo2D.getEps() < size && size < 3.5 + Geo2D.getEps()) {
                            do {
                                if (!((size = krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.49"))) < Geo2D.getEps())) continue;
                                System.err.println(Messages.getString("kernel.cmds.AddSymbol.50"));
                            } while (size < Geo2D.getEps());
                            break;
                        }
                        size = 3.5;
                        break;
                    }
                    case 1: {
                        fontFamily = fontFamily.equalsIgnoreCase("SansSerif") ? krnl.readFontFamily(Messages.getString("kernel.cmds.AddSymbol.52")) : "SansSerif";
                        break;
                    }
                    case 2: {
                        paint = paint.equals(Color.BLACK) ? krnl.readColor(Messages.getString("kernel.cmds.AddSymbol.54")) : Color.BLACK;
                        break;
                    }
                    case 3: {
                        angle = -Geo2D.getEps() < angle && angle < Geo2D.getEps() ? Math.toRadians(krnl.readDouble(Messages.getString("kernel.cmds.AddSymbol.55"), 0.0)) : 0.0;
                        break;
                    }
                    case 4: {
                        justification = justification == 0 ? AddText.textJustificationDialog() : 0;
                        break;
                    }
                    case 5: {
                        this.m_input = null;
                        break;
                    }
                    default: {
                        System.err.println(Messages.getString("kernel.cmds.AddSymbol.56"));
                        break;
                    }
                }
                continue;
            }
            if (!(this.m_input instanceof CmdAbortedException)) continue;
            throw (CmdAbortedException)this.m_input;
        } while (this.m_input != null);
        String text = krnl.readString(Messages.getString("kernel.cmds.AddSymbol.57"));
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.SIZE, new Double(size *= 2.83464));
        as.addAttribute(TextAttribute.FAMILY, fontFamily);
        AffineTransform trf = AffineTransform.getTranslateInstance(x, y);
        trf.rotate(angle);
        AttributedText at = new AttributedText(as, trf);
        at.setJustification(justification);
        at.setDrawPaint(paint);
        at.setFillPaint(paint);
        this.m_comp.addPaperUnitsText(at);
        ui.updateUserInterface();
    }
}

