/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerSet;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.AttriSave;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class AttriRestore
implements Cmd {
    private Attributes m_savedAttributes = null;
    private Layer m_savedLayer = null;
    private String m_savedLayerName = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        AttributeManager atm = db.getAttributeManager();
        LayerSet layerSet = db.getLayerSet();
        Attributes att = AttriSave.getSavedAttributes();
        Layer layer = AttriSave.getSavedLayer();
        if (att == null || layer == null) {
            System.err.println(Messages.getString("kernel.cmds.AttriRestore.0"));
            return;
        }
        this.m_savedAttributes = (Attributes)atm.getDefaultAttributes().clone();
        this.m_savedLayer = layerSet.getDefaultLayer();
        if (this.m_savedLayer != null) {
            this.m_savedLayerName = ns.getName(this.m_savedLayer);
            this.m_savedLayer = (Layer)layerSet.getDefaultLayer().clone();
        }
        atm.setDefaultAttributes(att);
        layerSet.setDefaultLayer(layer);
        this.m_toString = Messages.getString("kernel.cmds.AttriRestore.1");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        AttributeManager atm = db.getAttributeManager();
        LayerSet layerSet = db.getLayerSet();
        Attributes temp = (Attributes)atm.getDefaultAttributes().clone();
        atm.setDefaultAttributes(this.m_savedAttributes);
        this.m_savedAttributes = temp;
        Layer currentLayer = layerSet.getDefaultLayer();
        String currentLayerName = currentLayer != null ? ns.getName(currentLayer) : null;
        Layer layer = (Layer)ns.getObject(this.m_savedLayerName);
        layer.setAttributes(this.m_savedLayer.getAttributes());
        layerSet.setDefaultLayer(layer);
        this.m_savedLayerName = currentLayerName;
        this.m_savedLayer = currentLayer != null ? (Layer)currentLayer.clone() : null;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_savedAttributes != null && this.m_savedLayer != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

