/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.Instance;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.StoreAs;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class CheckForUpdates
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        try {
            String instanceVersionRobustness;
            URL versionFile = new URL("http://www.cademia.org/frontend/version.txt");
            InputStream is = versionFile.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String bf = br.readLine();
            String availableVersionMajor = bf.substring(0, 1);
            if ('.' != bf.charAt(1)) {
                System.err.println(Messages.getString("kernel.cmds.CheckForUpdates.1"));
                return;
            }
            String availableVersionMinor = bf.substring(2, 3);
            String availableVersionRobustness = bf.substring(3, 4);
            String availableVersionBuild = bf.substring(4);
            String availableVersion = String.valueOf(availableVersionMajor) + "." + availableVersionMinor;
            if (availableVersionRobustness.compareTo("a") == 0) {
                availableVersion = String.valueOf(availableVersion) + " a";
            } else if (availableVersionRobustness.compareTo("b") == 0) {
                availableVersion = String.valueOf(availableVersion) + " b";
            } else if (availableVersionRobustness.compareTo("c") == 0) {
                availableVersion = String.valueOf(availableVersion) + " RC";
            } else if (availableVersionRobustness.compareTo("d") == 0) {
                availableVersion = String.valueOf(availableVersion) + " ";
            } else {
                System.err.println(Messages.getString("kernel.cmds.CheckForUpdates.11"));
                return;
            }
            availableVersion = String.valueOf(availableVersion) + availableVersionBuild;
            int compare = availableVersionMajor.compareTo(Instance.VERSION_MAJOR);
            if (compare < 0) {
                this.versionMessage(null);
                return;
            }
            if (compare > 0) {
                this.versionMessage(availableVersion);
                return;
            }
            compare = availableVersionMinor.compareTo(Instance.VERSION_MINOR);
            if (compare < 0) {
                this.versionMessage(null);
                return;
            }
            if (compare > 0) {
                this.versionMessage(availableVersion);
                return;
            }
            if (Instance.VERSION_ROBUSTNESS.compareTo("a") == 0) {
                instanceVersionRobustness = "a";
            } else if (Instance.VERSION_ROBUSTNESS.compareTo("b") == 0) {
                instanceVersionRobustness = "b";
            } else if (Instance.VERSION_ROBUSTNESS.compareTo("RC") == 0) {
                instanceVersionRobustness = "c";
            } else if (Instance.VERSION_ROBUSTNESS.compareTo("") == 0) {
                instanceVersionRobustness = "d";
            } else {
                System.err.println(Messages.getString("kernel.cmds.CheckForUpdates.16"));
                return;
            }
            compare = availableVersionRobustness.compareTo(instanceVersionRobustness);
            if (compare < 0) {
                this.versionMessage(null);
                return;
            }
            if (compare > 0) {
                this.versionMessage(availableVersion);
                return;
            }
            try {
                int availableVersionBuildNumber = Integer.parseInt(availableVersionBuild);
                int versionBuildNumber = Integer.parseInt(Instance.VERSION_BUILD);
                if (availableVersionBuildNumber <= versionBuildNumber) {
                    this.versionMessage(null);
                    return;
                }
                this.versionMessage(availableVersion);
                return;
            }
            catch (NumberFormatException e) {
                System.err.println(Messages.getString("kernel.cmds.CheckForUpdates.17"));
                return;
            }
        }
        catch (MalformedURLException e) {
            System.err.println(Messages.getString("kernel.cmds.CheckForUpdates.18"));
        }
        catch (IOException e) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.CheckForUpdates.19")) + Messages.getString("kernel.cmds.CheckForUpdates.20"));
        }
    }

    private void versionMessage(String availableVersion) throws CmdAbortedException {
        Kernel krnl = Kernel.getInstance();
        String msg = "";
        String prompt = "";
        if (availableVersion != null) {
            if (krnl.databaseChanged() && krnl.readYesNo(Messages.getString("kernel.cmds.CheckForUpdates.21"), 2)) {
                StoreAs storeCmd = new StoreAs();
                storeCmd.doCmd(krnl);
            }
            msg = String.valueOf(msg) + Messages.getString("kernel.cmds.CheckForUpdates.22") + Instance.VERSION_STRING + ".\n\n" + Messages.getString("kernel.cmds.CheckForUpdates.24") + availableVersion + Messages.getString("kernel.cmds.CheckForUpdates.25");
            prompt = Messages.getString("kernel.cmds.CheckForUpdates.27b");
        } else {
            msg = String.valueOf(msg) + Messages.getString("kernel.cmds.CheckForUpdates.26");
            prompt = Messages.getString("kernel.cmds.CheckForUpdates.27a");
        }
        krnl.readOK(prompt, Messages.getString("kernel.cmds.CheckForUpdates.28"), msg, 6);
        if (availableVersion != null && Desktop.isDesktopSupported()) {
            Desktop dt = Desktop.getDesktop();
            try {
                URI uri = new URI(Messages.getString("kernel.cmds.CheckForUpdates.29"));
                dt.browse(uri);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            krnl.exit();
        }
    }
}

