/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.cmds.AddPath;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;

public class ContinuePath
extends UndoableCmd {
    private ComponentPath2D m_path = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.size() == 1) {
            Component comp = (Component)selSet.iterator().next();
            if (comp instanceof ComponentPath2D) {
                this.m_path = (ComponentPath2D)comp;
                this._saveState(this.m_path);
                AddPath addPath = new AddPath();
                try {
                    addPath.addSegments(this.m_path);
                    System.out.println(this);
                }
                catch (CmdAbortedException e) {
                    this._clearAllSavedStates();
                    this.m_path = null;
                    throw e;
                }
                return;
            }
        } else {
            System.err.println(Messages.getString("kernel.cmds.ContinuePath.0"));
        }
    }

    public String toString() {
        if (this.m_path == null) {
            return super.toString();
        }
        Point2D sp = this.m_path.getStartVertexLocation();
        return String.valueOf(Messages.getString("kernel.cmds.ContinuePath.1")) + Geo2D.formatCoordinate(sp.getX()) + Messages.getString("kernel.cmds.ContinuePath.2") + Geo2D.formatCoordinate(sp.getY()) + Messages.getString("kernel.cmds.ContinuePath.3");
    }
}

