/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentImage;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class ModifyImages
implements Cmd {
    private Map<ComponentImage, double[]> m_imageSizes = new HashMap<ComponentImage, double[]>();
    private transient int m_iChoice = -1;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        boolean keepWidth;
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            System.err.println(Messages.getString("kernel.cmds.ModifyImages.0"));
            throw new CmdAbortedException();
        }
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.ModifyImages-menu0");
        dlg.setPrompt(Messages.getString("kernel.cmds.ModifyImages.2"));
        dlg.setDefaultChoice(dlg.addChoice("Keep width"));
        dlg.addChoice("Keep height");
        dlg.enableTextInput(false);
        dlg.enableDigitize(0);
        this.m_iChoice = -1;
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                ModifyImages.this.m_iChoice = iChoice;
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ModifyImages.this.m_iChoice = -1;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (this.m_iChoice == 0) {
            keepWidth = true;
        } else if (this.m_iChoice == 1) {
            keepWidth = false;
        } else {
            throw new CmdAbortedException();
        }
        for (Component comp : selSet) {
            if (!(comp instanceof ComponentImage)) continue;
            ComponentImage compImage = (ComponentImage)comp;
            double w = compImage.getWidth();
            double h = compImage.getHeight();
            this.m_imageSizes.put(compImage, new double[]{w, h});
            BufferedImage bi = compImage.getImage();
            if (keepWidth) {
                h = w * (double)bi.getHeight() / (double)bi.getWidth();
            } else {
                w = h * (double)bi.getWidth() / (double)bi.getHeight();
            }
            compImage.setImageSize(w, h);
        }
        if (this.m_imageSizes.isEmpty()) {
            System.err.println(Messages.getString("kernel.cmds.ModifyImages.5"));
        } else {
            System.out.println(this);
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            if (!(comp instanceof ComponentImage)) continue;
            ComponentImage compImage = (ComponentImage)comp;
            double[] wh = this.m_imageSizes.get(compImage);
            double w = wh[0];
            double h = wh[1];
            wh[0] = compImage.getWidth();
            wh[1] = compImage.getHeight();
            compImage.setImageSize(w, h);
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_imageSizes.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.m_imageSizes.size()) + Messages.getString("kernel.cmds.ModifyImages.6");
    }
}

