/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.kernel.interpreter.CmdLineInterpreter;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.TokenMgrError;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Play
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final Kernel krnl = (Kernel)context;
        File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                if (!fileName.endsWith(".cademia_macro")) {
                    return false;
                }
                if (!f.exists()) {
                    System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.Play.1"));
                    return false;
                }
                if (!f.canRead()) {
                    System.err.println(String.valueOf(Messages.getString("kernel.cmds.Play.2")) + f.getAbsolutePath());
                    return false;
                }
                return true;
            }

            @Override
            public String[] getExtensions() {
                return new String[]{"cademia_macro"};
            }

            @Override
            public String getPrompt() {
                return Messages.getString("kernel.cmds.Play.3");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("kernel.cmds.Play.4")) + " (*." + "cademia_macro" + ")";
            }
        });
        try {
            CmdLineInterpreter interpreter = new CmdLineInterpreter(System.in);
            interpreter.addListener(new CmdLineInterpreter.Listener(){
                private String m_cmdName = null;
                private String m_args = "";

                @Override
                public void parsingCommand(String cmdName) {
                    this.m_cmdName = cmdName;
                    this.m_args = " ";
                }

                @Override
                public void parsingArgument(String arg) {
                    this.m_args = String.valueOf(this.m_args) + arg + " ";
                }

                @Override
                public void parsingEndOfCommand() {
                    krnl.doCmd(this.m_cmdName, this.m_args);
                }
            });
            interpreter.ReInit(new FileInputStream(file));
            try {
                interpreter.start();
            }
            catch (TokenMgrError e) {
                System.err.println(e);
            }
            catch (ParseException e) {
                System.err.println(e);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.Play.10")) + file + Messages.getString("kernel.cmds.Play.11"));
        }
        catch (Exception e) {
            System.err.println(Messages.getString("kernel.cmds.Play.12"));
            e.printStackTrace();
        }
    }
}

