/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import java.util.Iterator;

public class PosSwap
implements Cmd {
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.size() != 2) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.PosSwap.0")) + selSet.size() + Messages.getString("kernel.cmds.PosSwap.1"));
            return;
        }
        this._swap();
        this.m_toString = Messages.getString("kernel.cmds.PosSwap.2");
        System.out.println(this);
    }

    @Override
    public void redoCmd(Object context) {
        this._swap();
    }

    @Override
    public void undoCmd(Object context) {
        this._swap();
    }

    @Override
    public boolean changesState() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return selSet.size() == 2;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _swap() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        SwappableList<Component> cmpList = db.getComponentList();
        Iterator it = selSet.iterator();
        Component c1 = (Component)it.next();
        Component c2 = (Component)it.next();
        int i1 = cmpList.indexOf(c1);
        int i2 = cmpList.indexOf(c2);
        cmpList.swap(i1, i2);
    }
}

