/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.AddableFeatures;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.db.feature.Feature;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoveFeature
implements Cmd {
    private Map<AddableFeatures, Feature> m_operandFeatures = new HashMap<AddableFeatures, Feature>();
    private transient int t_input = -1;

    public static boolean isDoable() {
        Component comp2;
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp2 : selSet) {
            if (!(comp2 instanceof AddableFeatures)) continue;
            return true;
        }
        return selSet.isEmpty() && (comp2 = krnl.getOpenGroup()) instanceof AddableFeatures;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        String name3;
        Group group;
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        HashSet<AddableFeatures> operands = new HashSet<AddableFeatures>();
        for (Component comp : selSet) {
            if (!(comp instanceof AddableFeatures)) continue;
            operands.add((AddableFeatures)comp);
        }
        if (operands.isEmpty() && (group = krnl.getOpenGroup()) instanceof AddableFeatures) {
            operands.add((AddableFeatures)((Object)group));
        }
        if (operands.isEmpty()) {
            krnl.readOK(Messages.getString("kernel.cmds.RemoveFeature.0"), Messages.getString("kernel.cmds.RemoveFeature.1"), Messages.getString("kernel.cmds.RemoveFeature.2"), 6);
            return;
        }
        ArrayList<String> addedFeatures = new ArrayList<String>();
        for (AddableFeatures comp : operands) {
            Iterator<Feature> it = comp.featureIterator();
            while (it.hasNext()) {
                Feature f = it.next();
                String name2 = f.getName();
                if (!comp.isAddedFeature(name2)) continue;
                addedFeatures.add(name2);
            }
        }
        if (addedFeatures.isEmpty()) {
            krnl.readOK(Messages.getString("kernel.cmds.RemoveFeature.3"), Messages.getString("kernel.cmds.RemoveFeature.4"), Messages.getString("kernel.cmds.RemoveFeature.5"), 6);
            return;
        }
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.RemoveFeature-menu0");
        dlg.setPrompt(Messages.getString("kernel.cmds.RemoveFeature.6"));
        for (String name3 : addedFeatures) {
            dlg.addChoice(name3);
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                RemoveFeature.this.t_input = iChoice;
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                RemoveFeature.this.t_input = -1;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (this.t_input < 0) {
            throw new CmdAbortedException();
        }
        name3 = (String)addedFeatures.get(this.t_input);
        for (AddableFeatures comp : operands) {
            if (!comp.hasFeature(name3) || !comp.isAddedFeature(name3)) continue;
            Feature f = comp.getFeature(name3);
            this.m_operandFeatures.put(comp, (Feature)f.clone());
            comp.removeFeature(name3);
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Set<AddableFeatures> comps = this.m_operandFeatures.keySet();
        for (AddableFeatures comp : comps) {
            Feature f = this.m_operandFeatures.get(comp);
            comp.addFeature(f);
        }
    }

    @Override
    public void redoCmd(Object context) {
        Set<AddableFeatures> comps = this.m_operandFeatures.keySet();
        for (AddableFeatures comp : comps) {
            Feature f = this.m_operandFeatures.get(comp);
            comp.removeFeature(f.getName());
        }
    }

    @Override
    public boolean changesState() {
        return !this.m_operandFeatures.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("kernel.cmds.RemoveFeature.7");
    }
}

