/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.SelectFilter;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.IteratorFilter;
import cib.util.coll.ObservableSet;

public class SelectByName
extends UndoableCmd {
    private String m_toString = null;
    private int m_action = -1;
    private String m_name = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Database db;
        NameSpace nameSpace;
        Component o;
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        IteratorFilter<Component> filter = null;
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.SelectByName-menu0");
            dlg.setPrompt(Messages.getString("kernel.cmds.SelectByName.1"));
            int iChoice = dlg.addChoice("Filter");
            if (filter != null) {
                dlg.setChoiceChecked(iChoice);
            }
            dlg.enableTextInput();
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void textEntered(String text) {
                    SelectByName.this.m_action = -2;
                    SelectByName.this.m_name = text;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void choiceSelected(int iChoice) {
                    if (iChoice == 0) {
                        SelectByName.this.m_action = iChoice;
                        ui.disposeCmdLineDialog();
                    }
                }

                @Override
                public void dialogAborted() {
                    SelectByName.this.m_action = -1;
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_action == 0) {
                filter = filter == null ? new SelectFilter().showDialog() : null;
                continue;
            }
            if (this.m_action != -1) continue;
            throw new CmdAbortedException();
        } while (this.m_name == null);
        if (filter == null) {
            filter = new IteratorFilter<Component>(){
                private AttributeManager m_atm = AttributeManager.getAttributeManager();

                @Override
                public boolean matches(Component c) {
                    if (c == null) {
                        return false;
                    }
                    Attributes attr = c.getAttributes();
                    return attr == null ? true : this.m_atm.getVisibility(attr.getVisibility());
                }
            };
        }
        if (!filter.matches(o = (Component)(nameSpace = (db = krnl.getDatabase()).getNameSpace()).getObject(this.m_name))) {
            o = null;
        }
        ObservableSet<Component> selSet = db.getSelectSet();
        if (o == null) {
            this.m_toString = Messages.getString("kernel.cmds.SelectByName.3");
        } else if (!selSet.contains(o)) {
            this._saveSelectState(o);
            selSet.add(o);
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SelectByName.4")) + this.m_name + Messages.getString("kernel.cmds.SelectByName.5");
        } else {
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SelectByName.6")) + this.m_name + Messages.getString("kernel.cmds.SelectByName.7");
        }
        System.out.println(this);
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

