/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public abstract class Transform
extends UndoableCmd {
    protected AffineTransform m_mat = null;

    protected abstract AffineTransform _getTransform(Kernel var1) throws CmdAbortedException;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            System.err.println(Messages.getString("kernel.cmds.Transform.0"));
            return;
        }
        this.m_mat = this._getTransform(krnl);
        if (this.m_mat == null || this.m_mat.isIdentity()) {
            return;
        }
        try {
            this.m_mat.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new CmdAbortedException(Messages.getString("kernel.cmds.Transform.1"));
        }
        this.transform(krnl, this.m_mat);
    }

    @Override
    public void undoCmd(Object context) {
        AffineTransform invMat;
        Kernel krnl = (Kernel)context;
        try {
            invMat = this.m_mat.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new InternalError(Messages.getString("kernel.cmds.Transform.2"));
        }
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            if (this._hasSavedObjectState(comp)) continue;
            comp.transformBy(invMat);
        }
        super.undoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        this._transform(krnl, this.m_mat, false);
    }

    @Override
    public boolean changesState() {
        return this.m_mat != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    protected void transform(Kernel krnl, AffineTransform mat) {
        this._transform(krnl, mat, true);
    }

    private void _transform(Kernel krnl, AffineTransform mat, boolean saveObjectStateOnlyOnce) {
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        for (Component comp : selSet) {
            if (mm.hasMarkedPrimitives(comp, 2)) {
                if (!saveObjectStateOnlyOnce || !this._hasSavedObjectState(comp)) {
                    this._saveObjectState(comp);
                }
                comp.setControlPointStarts();
                NamedListIterator<Point2D> lit = comp.controlPointIterator();
                while (lit.hasNext()) {
                    Point2D p = (Point2D)lit.next();
                    int index = lit.previousIndex();
                    if (!mm.primitiveMarked(comp, 2, index)) continue;
                    mat.transform(p, p);
                    lit.set(p);
                }
                comp.setControlPointEnds();
                continue;
            }
            comp.transformBy(mat);
        }
    }
}

