/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.JPanel;

public class OrthoConstraintIndicator
implements GeometryPanel.AnnotationRenderer {
    private Point2D m_pnt = new Point2D.Double();
    private double m_angle = 0.0;

    public OrthoConstraintIndicator() {
    }

    public OrthoConstraintIndicator(double x, double y, double angle) {
        this.m_pnt.setLocation(x, y);
        this.m_angle = angle;
    }

    public void setPoint(double x, double y) {
        this.m_pnt.setLocation(x, y);
    }

    public double getX() {
        return this.m_pnt.getX();
    }

    public double getY() {
        return this.m_pnt.getY();
    }

    public void setAngel(double angle) {
        this.m_angle = angle;
    }

    public double getAngle() {
        return this.m_angle;
    }

    public void addToAllPanels() {
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.addAnnotationRenderer(this);
        }
    }

    public void removeFromAllPanels() {
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeAnnotationRenderer(this);
        }
    }

    @Override
    public synchronized void paint(GeometryPanel p, Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        g.setPaint(Kernel.getInstance().getTempGeometryDrawPaint());
        BasicStroke stroke = new BasicStroke(1.0f);
        g.setStroke(stroke);
        Line2D dir = this._getLineInScreenUnits(p, this.m_pnt.getX(), this.m_pnt.getY(), this.m_angle);
        Vector2D vec = new Vector2D(dir.getP1(), dir.getP2());
        if (Geo2D.isNull(vec)) {
            return;
        }
        vec.left();
        vec.normalize();
        vec.scaleBy(2.0);
        Line2D.Double l = new Line2D.Double(dir.getX1() + vec.x, dir.getY1() + vec.y, dir.getX2() + vec.x, dir.getY2() + vec.y);
        g.draw(l);
        ((Line2D)l).setLine(dir.getX1() - vec.x, dir.getY1() - vec.y, dir.getX2() - vec.x, dir.getY2() - vec.y);
        g.draw(l);
        dir = this._getLineInScreenUnits(p, this.m_pnt.getX(), this.m_pnt.getY(), this.m_angle + 1.5707963267948966);
        vec.left();
        ((Line2D)l).setLine(dir.getX1() + vec.x, dir.getY1() + vec.y, dir.getX2() + vec.x, dir.getY2() + vec.y);
        g.draw(l);
        ((Line2D)l).setLine(dir.getX1() - vec.x, dir.getY1() - vec.y, dir.getX2() - vec.x, dir.getY2() - vec.y);
        g.draw(l);
    }

    private Line2D _getLineInScreenUnits(GeometryPanel p, double x, double y, double angle) {
        Vector2D vec = new Vector2D(angle);
        double scale = Math.max(1.0, Math.sqrt(x * x + y * y));
        vec.scaleBy(scale);
        Line2D.Double dir = new Line2D.Double(x, y, x + vec.x, y + vec.y);
        Projection2D prj2D = p.getProjection();
        AffineTransform m2v = prj2D.getModelToView();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        m2v.transform(((Line2D)dir).getP1(), p1);
        m2v.transform(((Line2D)dir).getP2(), p2);
        JPanel panel = (JPanel)((Object)p);
        double maxDx = Math.abs(((Point2D)p1).getX()) + (double)panel.getWidth();
        double maxDy = Math.abs(((Point2D)p1).getY()) + (double)panel.getHeight();
        double maxD = maxDx + maxDy;
        Vector2D v = new Vector2D(p2, p1);
        v.normalize();
        v.scaleBy(maxD);
        Vector2D q1 = new Vector2D(p1);
        q1.add(v);
        maxDx = Math.abs(((Point2D)p2).getX()) + (double)panel.getWidth();
        maxDy = Math.abs(((Point2D)p2).getY()) + (double)panel.getHeight();
        maxD = maxDx + maxDy;
        v.setLocation(p1, p2);
        v.normalize();
        v.scaleBy(maxD);
        Vector2D q2 = new Vector2D(p2);
        q2.add(v);
        return new Line2D.Double(q1, q2);
    }
}

