/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.interpreter;

import cib.cad.kernel.TextToken;
import cib.cad.kernel.interpreter.CmdLineInterpreterConstants;
import cib.cad.kernel.interpreter.CmdLineInterpreterTokenManager;
import cib.cad.kernel.interpreter.JavaCharStream;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.Token;
import cib.cad.kernel.interpreter.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class CmdLineInterpreter
implements CmdLineInterpreterConstants {
    private Set<Listener> m_listeners = new HashSet<Listener>();
    public CmdLineInterpreterTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        CmdLineInterpreter.jj_la1_0();
    }

    public static void main(String[] args) throws ParseException {
        CmdLineInterpreter interpreter = new CmdLineInterpreter(System.in);
        interpreter.addListener(new Listener(){

            @Override
            public void parsingCommand(String cmdName) {
                System.out.println("Parsing command: " + cmdName);
            }

            @Override
            public void parsingArgument(String arg) {
                System.out.println("Parsing argument: " + arg);
            }

            @Override
            public void parsingEndOfCommand() {
                System.out.println("Parsing EOC");
            }
        });
        while (true) {
            interpreter.ReInit(System.in);
            System.out.print("Enter expression: ");
            System.out.flush();
            try {
                interpreter.start();
                continue;
            }
            catch (TokenMgrError e) {
                System.out.println(e);
                continue;
            }
            catch (ParseException e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public final void start() throws ParseException {
        this.cmdList();
    }

    public final void cmdList() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    this.cmd();
                    break;
                }
                case 6: {
                    this.interrupt();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(14);
        }
    }

    public final void interrupt() throws ParseException {
        Token arg = null;
        Token ir = this.jj_consume_token(6);
        this.jj_consume_token(17);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 16: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg = this.jj_consume_token(15);
                        break block0;
                    }
                    case 16: {
                        arg = this.jj_consume_token(16);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(18);
        String _arg = arg == null ? "" : arg.image;
        String _str = TextToken.literalToString(_arg);
        String command = String.valueOf(_str) + ";";
        CmdLineInterpreter interpreter = new CmdLineInterpreter(new StringReader(command));
        interpreter.addListener(new Listener(){

            @Override
            public void parsingCommand(String cmdName) {
                for (Listener l : CmdLineInterpreter.this.m_listeners) {
                    l.parsingCommand(cmdName);
                }
            }

            @Override
            public void parsingArgument(String arg) {
                for (Listener l : CmdLineInterpreter.this.m_listeners) {
                    l.parsingArgument(arg);
                }
            }

            @Override
            public void parsingEndOfCommand() {
                for (Listener l : CmdLineInterpreter.this.m_listeners) {
                    l.parsingEndOfCommand();
                }
            }
        });
        interpreter.start();
    }

    public final void cmd() throws ParseException {
        this.cmdName();
        this.argList();
        for (Listener l : this.m_listeners) {
            l.parsingEndOfCommand();
        }
    }

    public final void cmdName() throws ParseException {
        Token name = this.jj_consume_token(15);
        for (Listener l : this.m_listeners) {
            l.parsingCommand(name.image);
        }
    }

    public final void argList() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            String str = this.arg();
            Iterator<Listener> iterator = this.m_listeners.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                Listener l = iterator.next();
                l.parsingArgument(str);
            }
            break;
        }
    }

    public final String arg() throws ParseException {
        Token arg1 = null;
        Token arg2 = null;
        Token arg3 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token argToken = this.jj_consume_token(15);
                return argToken.image;
            }
            case 16: {
                Token argToken = this.jj_consume_token(16);
                return argToken.image;
            }
            case 6: {
                Token ir = this.jj_consume_token(6);
                this.jj_consume_token(17);
                block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: {
                                arg1 = this.jj_consume_token(15);
                                break block12;
                            }
                            case 16: {
                                arg1 = this.jj_consume_token(16);
                                break block12;
                            }
                        }
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "(" + (arg1 == null ? "" : arg1.image) + ")";
            }
            case 7: {
                Token ir = this.jj_consume_token(7);
                this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg1 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg1 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "(" + arg1.image + ")";
            }
            case 8: {
                Token ir = this.jj_consume_token(8);
                this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg1 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg1 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg2 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg2 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg3 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg3 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "(" + arg1.image + " " + arg2.image + " " + arg3.image + ")";
            }
            case 9: {
                Token ir = this.jj_consume_token(9);
                this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg1 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg1 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg2 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg2 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg3 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg3 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "(" + arg1.image + " " + arg2.image + " " + arg3.image + ")";
            }
            case 10: {
                Token ir = this.jj_consume_token(10);
                this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        arg1 = this.jj_consume_token(15);
                        break;
                    }
                    case 16: {
                        arg1 = this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "(" + arg1.image + ")";
            }
            case 11: {
                Token ir = this.jj_consume_token(11);
                this.jj_consume_token(17);
                arg1 = this.jj_consume_token(15);
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "(" + arg1.image + ")";
            }
            case 12: {
                Token ir = this.jj_consume_token(12);
                this.jj_consume_token(17);
                this.jj_consume_token(18);
                return String.valueOf(ir.image) + "()";
            }
            case 13: {
                Token ir = this.jj_consume_token(13);
                return ir.image;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{32832, 32832, 98304, 98304, 114624, 98304, 98304, 98304, 98304, 98304, 98304, 98304, 98304, 98304, 98304, 114624};
    }

    public CmdLineInterpreter(InputStream stream) {
        this(stream, null);
    }

    public CmdLineInterpreter(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CmdLineInterpreterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public CmdLineInterpreter(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new CmdLineInterpreterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public CmdLineInterpreter(CmdLineInterpreterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(CmdLineInterpreterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[19];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 16) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 19) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    public static interface Listener {
        public void parsingCommand(String var1);

        public void parsingArgument(String var1);

        public void parsingEndOfCommand();
    }
}

