/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.cad.view.cmds.AddToolBar;
import cib.util.view.ViewUtilities;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class AddFileToolBar
extends AddToolBar {
    public static final String NAME = "File";

    @Override
    protected void _addToolBar(Object context) {
        Kernel krnl = (Kernel)context;
        GraphicalUserInterface gui = (GraphicalUserInterface)krnl.getUserInterface();
        JPanel tbp = gui.getToolBarPanel();
        if (this.containsToolBar(tbp, NAME)) {
            System.err.println(String.valueOf(Messages.getString("view.cmds.AddFileToolBar.1")) + NAME + Messages.getString("view.cmds.AddFileToolBar.2"));
            return;
        }
        gui.addInputDevice(this.m_inputDevice);
        this.m_toolBar = new JToolBar(NAME);
        this.m_toolBar.setRollover(true);
        final JButton newButton = ViewUtilities.createImageButton("New", this.getImageURL("cib/cad/img/new.gif"), Messages.getString("view.cmds.AddFileToolBar.5"));
        newButton.addActionListener(new AddToolBar._CmdListener(this, "new", 1));
        this.m_toolBar.add(newButton);
        final JButton loadButton = ViewUtilities.createImageButton("Open", this.getImageURL("cib/cad/img/load.gif"), Messages.getString("view.cmds.AddFileToolBar.9"));
        loadButton.addActionListener(new AddToolBar._CmdListener(this, "load", 1));
        this.m_toolBar.add(loadButton);
        final JButton storeButton = ViewUtilities.createImageButton("Save", this.getImageURL("cib/cad/img/store.gif"), Messages.getString("view.cmds.AddFileToolBar.13"));
        storeButton.addActionListener(new AddToolBar._CmdListener(this, "store", 1));
        this.m_toolBar.add(storeButton);
        this.m_toolBar.addSeparator();
        final JButton printButton = ViewUtilities.createImageButton("Print", this.getImageURL("cib/cad/img/print.gif"), Messages.getString("view.cmds.AddFileToolBar.17"));
        printButton.addActionListener(new AddToolBar._CmdListener(this, "print", 1));
        this.m_toolBar.add(printButton);
        this.m_toolBar.addSeparator();
        JButton playButton = ViewUtilities.createImageButton("Run", this.getImageURL("cib/cad/img/play.gif"), Messages.getString("view.cmds.AddFileToolBar.21"));
        playButton.addActionListener(new AddToolBar._CmdListener(this, "play"));
        this.m_toolBar.add(playButton);
        final JButton recordButton = ViewUtilities.createImageButton("Record", this.getImageURL("cib/cad/img/record.gif"), Messages.getString("view.cmds.AddFileToolBar.25"));
        recordButton.addActionListener(new AddToolBar._CmdListener(this, "record"));
        this.m_toolBar.add(recordButton);
        final JButton suspendButton = ViewUtilities.createImageButton("Suspend", this.getImageURL("cib/cad/img/suspend.gif"), Messages.getString("view.cmds.AddFileToolBar.29"));
        suspendButton.addActionListener(new AddToolBar._CmdListener(this, "suspend"));
        this.m_toolBar.add(suspendButton);
        final JButton resumeButton = ViewUtilities.createImageButton("Resume", this.getImageURL("cib/cad/img/resume.gif"), Messages.getString("view.cmds.AddFileToolBar.33"));
        resumeButton.addActionListener(new AddToolBar._CmdListener(this, "resume"));
        this.m_toolBar.add(resumeButton);
        final JButton stopButton = ViewUtilities.createImageButton("Stop", this.getImageURL("cib/cad/img/stop.gif"), Messages.getString("view.cmds.AddFileToolBar.37"));
        stopButton.addActionListener(new AddToolBar._CmdListener(this, "stop"));
        this.m_toolBar.add(stopButton);
        krnl.addListener(new Kernel.Listener(){
            private static final int NOT_RECORDING = 0;
            private static final int RECORDING = 1;
            private static final int RECORDING_SUSPENDED = 2;
            private int m_recorderStatus = 0;

            @Override
            public void waitingForCmd() {
                newButton.setEnabled(true);
                loadButton.setEnabled(true);
                storeButton.setEnabled(true);
                printButton.setEnabled(true);
            }

            @Override
            public void cmdStarts(String cmdName) {
                newButton.setEnabled(false);
                loadButton.setEnabled(false);
                storeButton.setEnabled(false);
                printButton.setEnabled(false);
                if (cmdName.equalsIgnoreCase("record")) {
                    this.m_recorderStatus = 1;
                } else if (cmdName.equalsIgnoreCase("suspend")) {
                    this.m_recorderStatus = 2;
                } else if (cmdName.equalsIgnoreCase("resume")) {
                    this.m_recorderStatus = 1;
                } else if (cmdName.equalsIgnoreCase("stop")) {
                    this.m_recorderStatus = 0;
                }
                recordButton.setEnabled(this.m_recorderStatus == 0);
                suspendButton.setEnabled(this.m_recorderStatus == 1);
                resumeButton.setEnabled(this.m_recorderStatus == 2);
                stopButton.setEnabled(this.m_recorderStatus == 1 || this.m_recorderStatus == 2);
            }
        });
        tbp.add(this.m_toolBar);
    }
}

