/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.db.Database;
import cib.cad.ext.mod.Chamfer;
import cib.cad.ext.mod.DragPreferences;
import cib.cad.ext.mod.Extend;
import cib.cad.ext.mod.Fillet;
import cib.cad.ext.mod.Join;
import cib.cad.ext.mod.Offset;
import cib.cad.ext.mod.Smash;
import cib.cad.ext.mod.SplitSegments;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.ChangeFeatures;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPaintComboBox;
import cib.cad.view.FillPaintComboBox;
import cib.cad.view.FontFamilyComboBox;
import cib.cad.view.GraphicalUserInterface;
import cib.cad.view.LayerComboBox;
import cib.cad.view.LinePatternComboBox;
import cib.cad.view.LineWidthComboBox;
import cib.cad.view.TextSizeComboBox;
import cib.cad.view.VisibilityComboBox;
import cib.util.ExtendedMouseAdapter;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.ObservableSet;
import cib.util.view.ScrollableJPopupMenu;
import cib.util.view.SingleRowLayout;
import cib.util.view.ViewUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;

public class AddModernToolBar
extends CmdAdapter {
    public static final int INPUT = 0;
    public static final int COMMAND = 1;
    public static final int INTERRUPTING_COMMAND = 2;
    public static final String NAME = "Windows tools";
    private InputDeviceAdapter m_inputDevice = new InputDeviceAdapter();
    private static Dimension m_buttonDim = new Dimension(48, 32);
    private static boolean MAC_OS = false;
    private static boolean WINDOWS = false;
    private static boolean LINUX = false;

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x")) {
            MAC_OS = true;
        } else if (os.startsWith("windows")) {
            WINDOWS = true;
        } else if (os.startsWith("linux")) {
            LINUX = true;
        }
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        final Kernel krnl = (Kernel)context;
        GraphicalUserInterface gui = (GraphicalUserInterface)krnl.getUserInterface();
        gui.addInputDevice(this.m_inputDevice);
        this.m_inputDevice.setEnabled(false);
        ViewUtilities.enableMenuIcons(false);
        JPanel tbp = gui.createToolBarPanel();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    b.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JButton)e.getSource()).setBorderPainted(false);
            }
        };
        JButton continuationButton = new JButton("\u00bb");
        continuationButton.setFocusable(false);
        continuationButton.setBorderPainted(false);
        continuationButton.setBorder(new EmptyBorder(0, 2, 0, 2));
        continuationButton.setFont(new Font("sansserif", 0, 20));
        tbp.setLayout(new SingleRowLayout(continuationButton, 4));
        final JButton buttonUndo = AddModernToolBar._button("Tool_Undo.png", ml, null);
        buttonUndo.setEnabled(false);
        ExtendedMouseAdapter xma = new ExtendedMouseAdapter(1){

            @Override
            public void mouseHolding(MouseEvent e) {
                final ScrollableJPopupMenu popupMenu = new ScrollableJPopupMenu();
                popupMenu.removeAll();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int undoIndex = popupMenu.getSelectedIndex();
                        String cmd = "";
                        int i = 0;
                        while (i <= undoIndex) {
                            cmd = String.valueOf(cmd) + "undo;";
                            ++i;
                        }
                        AddModernToolBar.this.m_inputDevice.fireInput(cmd);
                        popupMenu.setVisible(false);
                    }
                };
                Iterator<Cmd> undoableCmds = krnl.undoableCommandsIterator();
                while (undoableCmds.hasNext()) {
                    Cmd cmd = undoableCmds.next();
                    JMenuItem item = new JMenuItem(cmd.toString());
                    item.addActionListener(al);
                    popupMenu.add(item);
                }
                popupMenu.show(buttonUndo, 0, buttonUndo.getHeight());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 0) {
                    AddModernToolBar.this.m_inputDevice.fireInput("undo");
                }
            }
        };
        buttonUndo.addMouseListener(xma.asMouseInputListener());
        buttonUndo.addMouseMotionListener(xma.asMouseInputListener());
        tbp.add(AddModernToolBar._componentWithDescription(buttonUndo, Messages.getString("view.cmds.AddModernToolBar.11")));
        final JButton buttonRedo = AddModernToolBar._button("Tool_Redo.png", ml, null);
        buttonRedo.setEnabled(false);
        xma = new ExtendedMouseAdapter(1){

            @Override
            public void mouseHolding(MouseEvent e) {
                final ScrollableJPopupMenu popupMenu = new ScrollableJPopupMenu();
                popupMenu.removeAll();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int redoIndex = popupMenu.getSelectedIndex();
                        String cmd = "";
                        int i = 0;
                        while (i <= redoIndex) {
                            cmd = String.valueOf(cmd) + "redo;";
                            ++i;
                        }
                        AddModernToolBar.this.m_inputDevice.fireInput(cmd);
                        popupMenu.setVisible(false);
                    }
                };
                Iterator<Cmd> redoableCmds = krnl.redoableCommandsIterator();
                while (redoableCmds.hasNext()) {
                    Cmd cmd = redoableCmds.next();
                    JMenuItem item = new JMenuItem(cmd.toString());
                    item.addActionListener(al);
                    popupMenu.add(item);
                }
                popupMenu.show(buttonRedo, 0, buttonRedo.getHeight());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 0) {
                    AddModernToolBar.this.m_inputDevice.fireInput("redo");
                }
            }
        };
        buttonRedo.addMouseListener(xma.asMouseInputListener());
        buttonRedo.addMouseMotionListener(xma.asMouseInputListener());
        tbp.add(AddModernToolBar._componentWithDescription(buttonRedo, Messages.getString("view.cmds.AddModernToolBar.16")));
        final JButton buttonAgain = AddModernToolBar._button("Tool_Again.png", ml, new _CmdListener("again", 1));
        tbp.add(AddModernToolBar._componentWithDescription(buttonAgain, Messages.getString("view.cmds.AddModernToolBar.19")));
        final JButton buttonRemove = AddModernToolBar._button("Tool_Remove.png", ml, new _CmdListener("remove", 1));
        tbp.add(AddModernToolBar._componentWithDescription(buttonRemove, Messages.getString("view.cmds.AddModernToolBar.22")));
        JButton buttonAdd = AddModernToolBar._button("Tool_Add.png", ml, null);
        tbp.add(AddModernToolBar._componentWithDescription(buttonAdd, Messages.getString("view.cmds.AddModernToolBar.24")));
        final JPopupMenu popupAdd = new JPopupMenu();
        JMenuItem item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.25"));
        item.addActionListener(new _CmdListener("addline"));
        popupAdd.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.27"));
        item.addActionListener(new _CmdListener("addcircle"));
        popupAdd.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.29"));
        item.addActionListener(new _CmdListener("addarc"));
        popupAdd.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.31"));
        item.addActionListener(new _CmdListener("addpath"));
        popupAdd.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.33"));
        item.addActionListener(new _CmdListener("addbeziercurve"));
        popupAdd.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.35"));
        item.addActionListener(new _CmdListener("addrectangle"));
        popupAdd.add(item);
        popupAdd.addSeparator();
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.36"));
        item.addActionListener(new _CmdListener("addtext"));
        popupAdd.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.37"));
        item.addActionListener(new _CmdListener("addimage"));
        popupAdd.add(item);
        JMenu subMenu = new JMenu(Messages.getString("view.cmds.AddModernToolBar.39"));
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.40"));
        item.addActionListener(new _CmdListener("adddxfgroup #menu(mm)"));
        subMenu.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.41"));
        item.addActionListener(new _CmdListener("addmacrocell"));
        subMenu.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.42"));
        item.addActionListener(new _CmdListener("adddxfgroup"));
        subMenu.add(item);
        popupAdd.add(subMenu);
        subMenu = new JMenu(Messages.getString("view.cmds.AddModernToolBar.43"));
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.44"));
        item.addActionListener(new _CmdListener("adddim 0"));
        subMenu.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.46"));
        item.addActionListener(new _CmdListener("adddim 90"));
        subMenu.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.48"));
        item.addActionListener(new _CmdListener("adddim"));
        subMenu.add(item);
        item = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.50"));
        item.addActionListener(new _CmdListener("adddimpar"));
        subMenu.add(item);
        popupAdd.add(subMenu);
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!popupAdd.isVisible()) {
                    JButton button = (JButton)e.getSource();
                    popupAdd.show(button, 0, button.getHeight());
                } else {
                    popupAdd.setVisible(false);
                }
            }
        });
        final JButton buttonSelect = AddModernToolBar._button("Tool_Select.png", ml, null);
        tbp.add(AddModernToolBar._componentWithDescription(buttonSelect, Messages.getString("view.cmds.AddModernToolBar.53")));
        final JPopupMenu popupSelect = new JPopupMenu();
        final JMenuItem selectAllItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.54"));
        selectAllItem.addActionListener(new _CmdListener("selectall"));
        popupSelect.add(selectAllItem);
        final JMenuItem selectByNameItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.56"));
        selectByNameItem.addActionListener(new _CmdListener("selectbyname"));
        popupSelect.add(selectByNameItem);
        final JMenuItem selectByPickIntersectItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.58"));
        selectByPickIntersectItem.addActionListener(new _CmdListener("selectbypick"));
        popupSelect.add(selectByPickIntersectItem);
        final JMenuItem selectByPickInsideItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.60"));
        selectByPickInsideItem.addActionListener(new _CmdListener("selectbypickinside"));
        popupSelect.add(selectByPickInsideItem);
        final JMenuItem selectControlPointsItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.62"));
        selectControlPointsItem.addActionListener(new _CmdListener("selectPoints"));
        popupSelect.add(selectControlPointsItem);
        popupSelect.addSeparator();
        final JMenuItem unselectAllItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.64"));
        unselectAllItem.addActionListener(new _CmdListener("unselectall"));
        popupSelect.add(unselectAllItem);
        final JMenuItem unselectByNameItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.66"));
        unselectByNameItem.addActionListener(new _CmdListener("unselectbyname"));
        popupSelect.add(unselectByNameItem);
        final JMenuItem unselectByPickIntersectItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.68"));
        unselectByPickIntersectItem.addActionListener(new _CmdListener("unselectbypick"));
        popupSelect.add(unselectByPickIntersectItem);
        final JMenuItem unselectByPickInsideItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.70"));
        unselectByPickInsideItem.addActionListener(new _CmdListener("unselectbypickinside"));
        popupSelect.add(unselectByPickInsideItem);
        final JMenuItem unselectControlPointsItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.72"));
        unselectControlPointsItem.addActionListener(new _CmdListener("unselectPoints"));
        popupSelect.add(unselectControlPointsItem);
        popupSelect.addSeparator();
        final JMenuItem pickNearItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.74"));
        pickNearItem.addActionListener(new _CmdListener("picknear"));
        popupSelect.add(pickNearItem);
        buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!popupSelect.isVisible()) {
                    JButton button = (JButton)e.getSource();
                    popupSelect.show(button, 0, button.getHeight());
                } else {
                    popupSelect.setVisible(false);
                }
            }
        });
        final JButton buttonModify = AddModernToolBar._button("Tool_Modify.png", ml, null);
        tbp.add(AddModernToolBar._componentWithDescription(buttonModify, Messages.getString("view.cmds.AddModernToolBar.77")));
        final JPopupMenu popupModify = new JPopupMenu();
        final JMenuItem translateItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.78"));
        translateItem.addActionListener(new _CmdListener("translate"));
        popupModify.add(translateItem);
        final JMenuItem rotateItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.80"));
        rotateItem.addActionListener(new _CmdListener("rotate"));
        popupModify.add(rotateItem);
        popupModify.addSeparator();
        final JMenuItem copyTranslateItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.82"));
        copyTranslateItem.addActionListener(new _CmdListener("copy"));
        popupModify.add(copyTranslateItem);
        final JMenuItem copyRotateItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.84"));
        copyRotateItem.addActionListener(new _CmdListener("copyRotate"));
        popupModify.add(copyRotateItem);
        popupModify.addSeparator();
        final JMenuItem extendItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.86"));
        extendItem.addActionListener(new _CmdListener("extend"));
        popupModify.add(extendItem);
        final JMenuItem trimItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.88"));
        trimItem.addActionListener(new _CmdListener("trim"));
        popupModify.add(trimItem);
        final JMenuItem offsetItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.90"));
        offsetItem.addActionListener(new _CmdListener("offset"));
        popupModify.add(offsetItem);
        popupModify.addSeparator();
        final JMenuItem connectItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.92"));
        connectItem.addActionListener(new _CmdListener("fillet 0"));
        popupModify.add(connectItem);
        final JMenuItem filletItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.94"));
        filletItem.addActionListener(new _CmdListener("fillet"));
        popupModify.add(filletItem);
        final JMenuItem chamferItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.96"));
        chamferItem.addActionListener(new _CmdListener("chamfer"));
        popupModify.add(chamferItem);
        popupModify.addSeparator();
        final JMenuItem splitItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.98"));
        splitItem.addActionListener(new _CmdListener("split"));
        popupModify.add(splitItem);
        final JMenuItem breakItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.100"));
        breakItem.addActionListener(new _CmdListener("break"));
        popupModify.add(breakItem);
        final JMenuItem changeTypeItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.102"));
        changeTypeItem.addActionListener(new _CmdListener("changeType"));
        popupModify.add(changeTypeItem);
        popupModify.addSeparator();
        final JMenuItem joinItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.104"));
        joinItem.addActionListener(new _CmdListener("join"));
        popupModify.add(joinItem);
        final JMenuItem smashItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.106"));
        smashItem.addActionListener(new _CmdListener("smash"));
        popupModify.add(smashItem);
        popupModify.addSeparator();
        final JMenuItem changeFeaturesItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.108"));
        changeFeaturesItem.addActionListener(new _CmdListener("changefeatures"));
        popupModify.add(changeFeaturesItem);
        buttonModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!popupModify.isVisible()) {
                    JButton button = (JButton)e.getSource();
                    popupModify.show(button, 0, button.getHeight());
                } else {
                    popupModify.setVisible(false);
                }
            }
        });
        JButton buttonPrefs = AddModernToolBar._button("Tool_Config.png", ml, null);
        final JPopupMenu popupPrefs = new JPopupMenu();
        final JCheckBoxMenuItem itemPrefsAbsolute = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109a"));
        itemPrefsAbsolute.addActionListener(new _CmdListener("prefs #menu(Construction) #menu(Absolute)"));
        popupPrefs.add(itemPrefsAbsolute);
        final JCheckBoxMenuItem itemPrefsRelative = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109b"));
        itemPrefsRelative.addActionListener(new _CmdListener("prefs #menu(Construction) #menu(Relative)"));
        popupPrefs.add(itemPrefsRelative);
        popupPrefs.addSeparator();
        final JCheckBoxMenuItem itemPrefsAngular = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109c"));
        itemPrefsAngular.addActionListener(new _CmdListener("prefs #menu(Construction) #menu(Angular)"));
        popupPrefs.add(itemPrefsAngular);
        final JCheckBoxMenuItem itemPrefsOrthogonal = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109d"));
        itemPrefsOrthogonal.addActionListener(new _CmdListener("prefs #menu(Construction) #menu(Orthogonal)"));
        popupPrefs.add(itemPrefsOrthogonal);
        popupPrefs.addSeparator();
        final JCheckBoxMenuItem itemPrefsDragMoveComp = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109e"));
        itemPrefsDragMoveComp.addActionListener(new _CmdListener("prefs #menu(Drag) #menu(\"Move comp\")"));
        popupPrefs.add(itemPrefsDragMoveComp);
        final JCheckBoxMenuItem itemPrefsDragMovePoint = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109f"));
        itemPrefsDragMovePoint.addActionListener(new _CmdListener("prefs #menu(Drag) #menu(\"Move point\")"));
        popupPrefs.add(itemPrefsDragMovePoint);
        final JCheckBoxMenuItem itemPrefsDragOffset = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109g"));
        itemPrefsDragOffset.addActionListener(new _CmdListener("prefs #menu(Drag) #menu(Offset)"));
        popupPrefs.add(itemPrefsDragOffset);
        final JCheckBoxMenuItem itemPrefsDragExtend = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109h"));
        itemPrefsDragExtend.addActionListener(new _CmdListener("prefs #menu(Drag) #menu(Extend)"));
        popupPrefs.add(itemPrefsDragExtend);
        popupPrefs.addSeparator();
        final JCheckBoxMenuItem itemPrefsDragOriginal = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109i"));
        itemPrefsDragOriginal.addActionListener(new _CmdListener("prefs #menu(Drag) #menu(Original)"));
        popupPrefs.add(itemPrefsDragOriginal);
        final JCheckBoxMenuItem itemPrefsDragClone = new JCheckBoxMenuItem(Messages.getString("view.cmds.AddModernToolBar.109j"));
        itemPrefsDragClone.addActionListener(new _CmdListener("prefs #menu(Drag) #menu(Clone)"));
        popupPrefs.add(itemPrefsDragClone);
        buttonPrefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!popupPrefs.isVisible()) {
                    JButton button = (JButton)e.getSource();
                    popupPrefs.show(button, 0, button.getHeight());
                } else {
                    popupPrefs.setVisible(false);
                }
            }
        });
        tbp.add(AddModernToolBar._componentWithDescription(buttonPrefs, Messages.getString("view.cmds.AddModernToolBar.111")));
        JButton buttonInfo = AddModernToolBar._button("Tool_Info.png", ml, null);
        final JPopupMenu popupInfo = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.112a"));
        menuItem.addActionListener(new _CmdListener("condistance"));
        popupInfo.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.112b"));
        menuItem.addActionListener(new _CmdListener("conangle"));
        popupInfo.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("view.cmds.AddModernToolBar.112c"));
        menuItem.addActionListener(new _CmdListener("conpoint"));
        popupInfo.add(menuItem);
        buttonInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!popupInfo.isVisible()) {
                    JButton button = (JButton)e.getSource();
                    popupInfo.show(button, 0, button.getHeight());
                } else {
                    popupInfo.setVisible(false);
                }
            }
        });
        tbp.add(AddModernToolBar._componentWithDescription(buttonInfo, Messages.getString("view.cmds.AddModernToolBar.112d")));
        tbp.add(AddModernToolBar._componentWithDescription(new LayerComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.113")));
        tbp.add(AddModernToolBar._componentWithDescription(new LineWidthComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.114")));
        tbp.add(AddModernToolBar._componentWithDescription(new LinePatternComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.115")));
        tbp.add(AddModernToolBar._componentWithDescription(new DrawPaintComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.116")));
        tbp.add(AddModernToolBar._componentWithDescription(new FillPaintComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.117")));
        tbp.add(AddModernToolBar._componentWithDescription(new FontFamilyComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.118")));
        tbp.add(AddModernToolBar._componentWithDescription(new TextSizeComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.119")));
        tbp.add(AddModernToolBar._componentWithDescription(new VisibilityComboBox(krnl, this.m_inputDevice), Messages.getString("view.cmds.AddModernToolBar.120")));
        krnl.addListener(new Kernel.Listener(){

            @Override
            public void waitingForCmd() {
                Iterator<Cmd> it;
                Iterator<Cmd> it2;
                boolean canUndoMore = krnl.canUndoMore();
                if (canUndoMore && (it2 = krnl.undoableCommandsIterator()).hasNext()) {
                    buttonUndo.setToolTipText(it2.next().toString());
                }
                buttonUndo.setEnabled(canUndoMore);
                boolean canRedoMore = krnl.canRedoMore();
                if (canRedoMore && (it = krnl.redoableCommandsIterator()).hasNext()) {
                    buttonRedo.setToolTipText(it.next().toString());
                }
                buttonRedo.setEnabled(canRedoMore);
                String againCmd = krnl.getLastCmd();
                if (againCmd != null) {
                    if (againCmd.equalsIgnoreCase("undo") && !canUndoMore || againCmd.equalsIgnoreCase("redo") && !canRedoMore) {
                        againCmd = null;
                    }
                    buttonAgain.setToolTipText(againCmd);
                }
                buttonAgain.setEnabled(againCmd != null);
            }

            @Override
            public void cmdStarts(String cmdName) {
                buttonUndo.setEnabled(false);
                buttonUndo.setToolTipText(null);
                buttonRedo.setEnabled(false);
                buttonRedo.setToolTipText(null);
                buttonAgain.setEnabled(false);
                buttonAgain.setToolTipText(null);
            }

            @Override
            public void cmdEnds(String cmdName) {
                Database db = krnl.getDatabase();
                ObservableSet<cib.cad.db.comp.Component> compSet = db.getComponentSet();
                ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
                buttonRemove.setEnabled(!selSet.isEmpty());
                buttonSelect.setEnabled(!compSet.isEmpty());
                selectAllItem.setEnabled(compSet.size() != selSet.size());
                selectByNameItem.setEnabled(compSet.size() != selSet.size());
                selectByPickIntersectItem.setEnabled(compSet.size() != selSet.size());
                selectByPickInsideItem.setEnabled(compSet.size() != selSet.size());
                unselectAllItem.setEnabled(!selSet.isEmpty());
                unselectByNameItem.setEnabled(!selSet.isEmpty());
                unselectByPickIntersectItem.setEnabled(!selSet.isEmpty());
                unselectByPickInsideItem.setEnabled(!selSet.isEmpty());
                pickNearItem.setEnabled(!compSet.isEmpty());
                selectControlPointsItem.setEnabled(!compSet.isEmpty());
                unselectControlPointsItem.setEnabled(!selSet.isEmpty());
                translateItem.setEnabled(!selSet.isEmpty());
                rotateItem.setEnabled(!selSet.isEmpty());
                copyTranslateItem.setEnabled(!selSet.isEmpty());
                copyRotateItem.setEnabled(!selSet.isEmpty());
                boolean toExtend = Extend.isDoable();
                extendItem.setEnabled(toExtend);
                trimItem.setEnabled(toExtend);
                offsetItem.setEnabled(Offset.isDoable());
                boolean toFillet = Fillet.isDoable();
                connectItem.setEnabled(toFillet);
                filletItem.setEnabled(toFillet);
                chamferItem.setEnabled(Chamfer.isDoable());
                boolean segmentsChangeable = SplitSegments.isDoable();
                splitItem.setEnabled(segmentsChangeable);
                breakItem.setEnabled(segmentsChangeable);
                changeTypeItem.setEnabled(segmentsChangeable);
                joinItem.setEnabled(Join.isDoable());
                smashItem.setEnabled(Smash.isDoable());
                changeFeaturesItem.setEnabled(ChangeFeatures.isDoable());
                buttonModify.setEnabled(false);
                int nMenuItems = popupModify.getComponentCount();
                int i = 0;
                while (i < nMenuItems) {
                    Component comp = popupModify.getComponent(i);
                    if (comp instanceof JMenuItem && comp.isEnabled()) {
                        buttonModify.setEnabled(true);
                        break;
                    }
                    ++i;
                }
                itemPrefsAbsolute.setState(!ConPoint2D.getRelCoordFlag());
                itemPrefsRelative.setState(ConPoint2D.getRelCoordFlag());
                itemPrefsAngular.setState(!ConLineSeg2D.isOrthogonalMode());
                itemPrefsOrthogonal.setState(ConLineSeg2D.isOrthogonalMode());
                itemPrefsDragMoveComp.setState(DragPreferences.getDragMode() == 0);
                itemPrefsDragMovePoint.setState(DragPreferences.getDragMode() == 1);
                itemPrefsDragOffset.setState(DragPreferences.getDragMode() == 2);
                itemPrefsDragExtend.setState(DragPreferences.getDragMode() == 3);
                itemPrefsDragOriginal.setState(!DragPreferences.getIsCloning());
                itemPrefsDragClone.setState(DragPreferences.getIsCloning());
            }
        });
        this.m_inputDevice.setEnabled(true);
    }

    private static URL getImageURL(String path) {
        return AddModernToolBar.class.getClassLoader().getResource(path);
    }

    private static JPanel _componentWithDescription(JComponent component, String text) {
        JLabel lb = new JLabel(text);
        lb.setFont(new Font("sansserif", 0, 10));
        lb.setAlignmentX(0.5f);
        lb.setAlignmentY(1.0f);
        component.setAlignmentX(0.5f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(component);
        if (component instanceof JComboBox) {
            panel.setBorder(new EmptyBorder(9, 0, 0, 0));
            if (WINDOWS) {
                panel.add(Box.createVerticalStrut(3));
            } else if (LINUX) {
                panel.add(Box.createVerticalStrut(1));
            }
        } else {
            panel.setBorder(new EmptyBorder(4, 0, 0, 0));
        }
        panel.add(lb);
        panel.setName(text);
        return panel;
    }

    private static JButton _button(String name, MouseListener ml, _CmdListener cl) {
        URL url = AddModernToolBar.getImageURL("cib/cad/img/" + name);
        JButton button = new JButton(new ImageIcon(url));
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setPreferredSize(m_buttonDim);
        if (!MAC_OS) {
            button.addMouseListener(ml);
        }
        if (cl != null) {
            button.addActionListener(cl);
        }
        return button;
    }

    protected class _CmdListener
    implements ActionListener {
        private String m_cmd = null;
        private int m_inputType = 2;

        public _CmdListener(String cmd) {
            this.m_cmd = cmd;
        }

        public _CmdListener(String cmd, int inputType) {
            this.m_cmd = cmd;
            this.m_inputType = inputType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddModernToolBar.this.m_inputDevice.isEnabled()) {
                switch (this.m_inputType) {
                    case 1: {
                        AddModernToolBar.this.m_inputDevice.fireInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    case 2: {
                        AddModernToolBar.this.m_inputDevice.fireInterruptingInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    default: {
                        AddModernToolBar.this.m_inputDevice.fireInput(this.m_cmd);
                    }
                }
            }
        }
    }
}

