/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.cad.view.cmds.AddToolBar;
import cib.util.cmd.Cmd;
import cib.util.view.ViewUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class AddUndoToolBar
extends AddToolBar {
    private Kernel m_krnl;
    private ActionListener m_undoListener;
    private ActionListener m_redoListener;
    private JComboBox m_undoList = null;
    private JComboBox m_redoList = null;
    private JButton m_undoListButton;
    private JButton m_redoListButton;
    private JButton m_undoButton;
    private JButton m_redoButton;
    public static final String NAME = "Undo";

    @Override
    protected void _addToolBar(Object context) {
        this.m_krnl = (Kernel)context;
        GraphicalUserInterface gui = (GraphicalUserInterface)this.m_krnl.getUserInterface();
        JPanel tbp = gui.getToolBarPanel();
        if (this.containsToolBar(tbp, NAME)) {
            System.err.println(String.valueOf(Messages.getString("view.cmds.AddUndoToolBar.1")) + NAME + Messages.getString("view.cmds.AddUndoToolBar.2"));
            return;
        }
        gui.addInputDevice(this.m_inputDevice);
        this.m_toolBar = new JToolBar(NAME);
        this.m_toolBar.setRollover(true);
        this.m_krnl.addListener(new Kernel.Listener(){

            @Override
            public void waitingForCmd() {
                AddUndoToolBar.this.m_undoButton.setEnabled(AddUndoToolBar.this.m_krnl.canUndoMore());
                AddUndoToolBar.this.m_undoListButton.setEnabled(AddUndoToolBar.this.m_krnl.canUndoMore());
                AddUndoToolBar.this.m_redoButton.setEnabled(AddUndoToolBar.this.m_krnl.canRedoMore());
                AddUndoToolBar.this.m_redoListButton.setEnabled(AddUndoToolBar.this.m_krnl.canRedoMore());
            }

            @Override
            public void cmdStarts(String cmdName) {
                AddUndoToolBar.this.m_undoButton.setEnabled(false);
                AddUndoToolBar.this.m_undoListButton.setEnabled(false);
                AddUndoToolBar.this.m_redoButton.setEnabled(false);
                AddUndoToolBar.this.m_redoListButton.setEnabled(false);
            }
        });
        JButton b = ViewUtilities.createImageButton("UndoMore", this.getImageURL("cib/cad/img/more.gif"), Messages.getString("view.cmds.AddUndoToolBar.5"));
        this.m_undoListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                if (cb.getSelectedIndex() >= 0) {
                    String _cmd = "";
                    int i = 0;
                    while (i <= cb.getSelectedIndex()) {
                        _cmd = String.valueOf(_cmd) + "undo;";
                        ++i;
                    }
                    if (_cmd.length() != 0) {
                        AddUndoToolBar.this.fireInput(_cmd);
                    }
                }
            }
        };
        this.m_undoList = new JComboBox();
        this.m_undoList.setEditable(true);
        this.m_undoList.addActionListener(this.m_undoListener);
        this.m_undoListButton = ViewUtilities.createPopupButton(b, this.m_undoList, true);
        this.m_undoListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUndoToolBar.this._setUndoHistory();
            }
        });
        this.m_toolBar.add(this.m_undoListButton);
        this.m_undoButton = ViewUtilities.createImageButton(NAME, this.getImageURL("cib/cad/img/undo.gif"), Messages.getString("view.cmds.AddUndoToolBar.10"));
        this.m_undoButton.addActionListener(new AddToolBar._CmdListener(this, "undo", 1));
        this.m_toolBar.add(this.m_undoButton);
        this.m_redoButton = ViewUtilities.createImageButton("Redo", this.getImageURL("cib/cad/img/redo.gif"), Messages.getString("view.cmds.AddUndoToolBar.14"));
        this.m_redoButton.addActionListener(new AddToolBar._CmdListener(this, "redo", 1));
        this.m_toolBar.add(this.m_redoButton);
        b = ViewUtilities.createImageButton("RedoMore", this.getImageURL("cib/cad/img/more.gif"), Messages.getString("view.cmds.AddUndoToolBar.18"));
        this.m_redoListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                if (cb.getSelectedIndex() >= 0) {
                    String _cmd = "";
                    int i = 0;
                    while (i <= cb.getSelectedIndex()) {
                        _cmd = String.valueOf(_cmd) + "redo;";
                        ++i;
                    }
                    if (!_cmd.equals("")) {
                        AddUndoToolBar.this.fireInput(_cmd);
                    }
                }
            }
        };
        this.m_redoList = new JComboBox();
        this.m_redoList.addActionListener(this.m_redoListener);
        this.m_redoListButton = ViewUtilities.createPopupButton(b, this.m_redoList, true);
        this.m_redoListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUndoToolBar.this._setRedoHistory();
            }
        });
        this.m_toolBar.add(this.m_redoListButton);
        tbp.add(this.m_toolBar);
    }

    private void _setUndoHistory() {
        this.m_undoList.removeActionListener(this.m_undoListener);
        Iterator<Cmd> undoableCmds = this.m_krnl.undoableCommandsIterator();
        this.m_undoList.removeAllItems();
        while (undoableCmds.hasNext()) {
            this.m_undoList.addItem(undoableCmds.next().toString());
        }
        this.m_undoList.setSelectedIndex(-1);
        this.m_undoList.addActionListener(this.m_undoListener);
    }

    private void _setRedoHistory() {
        this.m_redoList.removeActionListener(this.m_redoListener);
        Iterator<Cmd> redoableCmds = this.m_krnl.redoableCommandsIterator();
        this.m_redoList.removeAllItems();
        while (redoableCmds.hasNext()) {
            this.m_redoList.addItem(redoableCmds.next().toString());
        }
        this.m_redoList.setSelectedIndex(-1);
        this.m_redoList.addActionListener(this.m_redoListener);
    }
}

