/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Set;

public class AttributedText
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final int JUST_LEFT_BASELINE = 0;
    public static final int JUST_LEFT_BOTTOM = 9;
    public static final int JUST_LEFT_CENTER = 1;
    public static final int JUST_LEFT_TOP = 2;
    public static final int JUST_CENTER_BASELINE = 3;
    public static final int JUST_CENTER_BOTTOM = 10;
    public static final int JUST_CENTER_CENTER = 4;
    public static final int JUST_CENTER_TOP = 5;
    public static final int JUST_RIGHT_BASELINE = 6;
    public static final int JUST_RIGHT_BOTTOM = 11;
    public static final int JUST_RIGHT_CENTER = 7;
    public static final int JUST_RIGHT_TOP = 8;
    public static final double MIN_SCALE_IN_TEXT_DIRECTION = 0.01;
    private AffineTransform m_trf;
    private int m_just = 0;
    private double m_scaleInTextDirection = 1.0;
    private transient AttributedString m_as;
    private static final int END_OF_ATTRIBUTED_STRING = -1;
    private Paint m_draw = null;
    private Paint m_fill = null;

    public AttributedText(AttributedString as, AffineTransform trf) {
        if (as == null || trf == null) {
            throw new IllegalArgumentException();
        }
        this.m_as = as;
        this.m_trf = trf;
    }

    public Object clone() {
        AttributedText cp = new AttributedText(new AttributedString(this.m_as.getIterator()), new AffineTransform(this.m_trf));
        cp.m_just = this.m_just;
        cp.m_scaleInTextDirection = this.m_scaleInTextDirection;
        cp.m_draw = this.m_draw;
        cp.m_fill = this.m_fill;
        return cp;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        AttributedCharacterIterator acit = this.m_as.getIterator();
        StringBuffer buf = new StringBuffer();
        char c = acit.first();
        while (c != '\uffff') {
            buf.append(c);
            c = acit.next();
        }
        out.writeObject(buf);
        int runLimit = 0;
        while (acit.setIndex(runLimit) != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> map = acit.getAttributes();
            int runStart = acit.getRunStart();
            runLimit = acit.getRunLimit();
            out.writeInt(runStart);
            out.writeInt(runLimit);
            Set<Map.Entry<AttributedCharacterIterator.Attribute, Object>> entrySet = map.entrySet();
            out.writeInt(entrySet.size());
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : entrySet) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
        out.writeInt(-1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int runStart;
        in.defaultReadObject();
        StringBuffer buf = (StringBuffer)in.readObject();
        this.m_as = new AttributedString(buf.toString());
        while ((runStart = in.readInt()) != -1) {
            int runLimit = in.readInt();
            int nAttr = in.readInt();
            int iAttr = 0;
            while (iAttr < nAttr) {
                AttributedCharacterIterator.Attribute attr = (AttributedCharacterIterator.Attribute)in.readObject();
                Object value = in.readObject();
                this.m_as.addAttribute(attr, value, runStart, runLimit);
                ++iAttr;
            }
        }
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.m_trf.clone();
    }

    public void setTransform(AffineTransform trf) {
        this.m_trf = trf;
    }

    public int getJustification() {
        return this.m_just;
    }

    public void setJustification(int just) {
        this.m_just = just;
    }

    public double getScaleInTextDirection() {
        return this.m_scaleInTextDirection < 0.01 ? 1.0 : this.m_scaleInTextDirection;
    }

    public void setScaleInTextDirection(double scale) {
        if (scale > 0.01) {
            this.m_scaleInTextDirection = scale;
        }
    }

    public Paint getDrawPaint() {
        return this.m_draw;
    }

    public void setDrawPaint(Paint paint) {
        this.m_draw = paint;
    }

    public Paint getFillPaint() {
        return this.m_fill;
    }

    public void setFillPaint(Paint paint) {
        this.m_fill = paint;
    }

    public AttributedString getAttributedString() {
        return this.m_as;
    }

    public void setAttributedString(AttributedString as) {
        this.m_as = as;
    }

    public void transformBy(AffineTransform at) {
        this.m_trf.preConcatenate(at);
    }
}

