/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import cib.util.CoordSpace;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Properties;

public class Grid
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    private double m_dx = 1.0;
    private double m_dy = 1.0;
    private double m_ox = 0.0;
    private double m_oy = 0.0;
    private double m_angle = 0.0;

    public static void main(String[] args) {
        Grid grd = new Grid(2.0, 1.0);
        System.out.println("All snaps should be (2, 1):");
        System.out.println("\t" + grd.snap(new Point2D.Double(1.1, 0.6), null));
        System.out.println("\t" + grd.snap(new Point2D.Double(1.1, 1.4), null));
        System.out.println("\t" + grd.snap(new Point2D.Double(2.9, 0.6), null));
        System.out.println("\t" + grd.snap(new Point2D.Double(2.9, 1.4), null));
    }

    public Grid() {
    }

    public Grid(double dx, double dy) {
        this.setGrid(dx, dy);
    }

    public Grid(Grid grid) {
        this.m_dx = grid.m_dx;
        this.m_dy = grid.m_dy;
        this.m_ox = grid.m_ox;
        this.m_oy = grid.m_oy;
        this.m_angle = grid.m_angle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setGrid(double dx, double dy) {
        this.m_dx = this._toMeter(dx);
        this.m_dy = this._toMeter(dy);
    }

    public void setOrigin(Point2D pnt) {
        this.setOrigin(pnt.getX(), pnt.getY());
    }

    public void setOrigin(double x, double y) {
        this.m_ox = this._toMeter(x);
        this.m_oy = this._toMeter(y);
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
    }

    public double getDx() {
        return this._toNU(this.m_dx);
    }

    public double getDy() {
        return this._toNU(this.m_dy);
    }

    public Point2D getOrigin() {
        return this.getOrigin(null);
    }

    public Point2D getOrigin(Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        dst.setLocation(this.getOriginX(), this.getOriginY());
        return dst;
    }

    public double getOriginX() {
        return this._toNU(this.m_ox);
    }

    public double getOriginY() {
        return this._toNU(this.m_oy);
    }

    public double getAngle() {
        return this.m_angle;
    }

    public void toProperties(Properties prop, String prefix) {
        prop.setProperty(String.valueOf(prefix) + "grid_dx", Double.toString(this.m_dx));
        prop.setProperty(String.valueOf(prefix) + "grid_dy", Double.toString(this.m_dy));
        prop.setProperty(String.valueOf(prefix) + "grid_ox", Double.toString(this.m_ox));
        prop.setProperty(String.valueOf(prefix) + "grid_oy", Double.toString(this.m_oy));
        prop.setProperty(String.valueOf(prefix) + "grid_angle", Double.toString(this.m_angle));
    }

    public void fromProperties(Properties prop, String prefix) {
        try {
            this.m_dx = Double.parseDouble(prop.getProperty(String.valueOf(prefix) + "grid_dx", "1"));
            this.m_dy = Double.parseDouble(prop.getProperty(String.valueOf(prefix) + "grid_dy", "1"));
            this.m_ox = Double.parseDouble(prop.getProperty(String.valueOf(prefix) + "grid_ox", "0"));
            this.m_oy = Double.parseDouble(prop.getProperty(String.valueOf(prefix) + "grid_oy", "0"));
            this.m_angle = Double.parseDouble(prop.getProperty(String.valueOf(prefix) + "grid_angle", "0"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Point2D snap(Point2D pntSrc, Point2D pntDst) {
        if (pntDst == null) {
            pntDst = new Point2D.Double();
        }
        double ox = this.getOriginX();
        double oy = this.getOriginY();
        double dx = this.getDx();
        double dy = this.getDy();
        double nx = Math.rint((pntSrc.getX() - ox) / dx);
        double ny = Math.rint((pntSrc.getY() - oy) / dy);
        pntDst.setLocation(ox + nx * dx, oy + ny * dy);
        return pntDst;
    }

    private double _mPerNU() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        return cs != null ? 0.001 * cs.getMillimetersPerNaturalUnit() : 1.0;
    }

    private double _toMeter(double inNU) {
        return inNU * this._mPerNU();
    }

    private double _toNU(double inM) {
        return inM / this._mPerNU();
    }
}

