/*
 * Decompiled with CFR 0.152.
 */
package cib.util.msg;

import cib.util.Dbg;
import cib.util.msg.Msg;
import cib.util.msg.MsgBrokenConnection;
import cib.util.msg.MsgReactor;
import cib.util.msg._MessageData;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class MsgHandler
extends Thread {
    private static Set<MsgHandler> s_allHandlers = Collections.synchronizedSet(new HashSet());
    private Boolean m_connectionBroken = Boolean.TRUE;
    private OutputStream m_out = null;
    private InputStream m_in = null;
    private Hashtable<Class, HashSet<_MessageData>> m_reactors = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgHandler(InputStream in, OutputStream out) {
        Set<MsgHandler> set = s_allHandlers;
        synchronized (set) {
            s_allHandlers.add(this);
        }
        this.m_connectionBroken = Boolean.FALSE;
        this.m_out = out;
        this.m_in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = s_allHandlers;
        synchronized (object) {
            s_allHandlers.remove(this);
        }
        object = this.m_reactors;
        synchronized (object) {
            this.m_reactors.clear();
        }
        try {
            if (this.m_in != null) {
                this.m_in.close();
                this.m_in = null;
            }
            if (this.m_out != null) {
                this.m_out.close();
                this.m_out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<MsgHandler> getAllMsgHandlers() {
        Set<MsgHandler> set = s_allHandlers;
        synchronized (set) {
            return s_allHandlers;
        }
    }

    public void send(Msg m) {
        if (this.connectionBroken() || this.m_out == null) {
            return;
        }
        if (m instanceof MsgBrokenConnection) {
            return;
        }
        Dbg.println(this, "Send Msg of type " + m.getClass().getName());
        try {
            ObjectOutputStream oout = new ObjectOutputStream(this.m_out);
            oout.writeObject(m);
            oout.flush();
        }
        catch (IOException e) {
            Dbg.println(e);
            this.handleBrokenConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcast(Msg m) {
        Set<MsgHandler> set = s_allHandlers;
        synchronized (set) {
            for (MsgHandler mh : s_allHandlers) {
                if (mh == null) continue;
                mh.send(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReactor(Class msgClass, MsgReactor r, Object context) {
        _MessageData data = new _MessageData(r, context);
        Hashtable<Class, HashSet<_MessageData>> hashtable = this.m_reactors;
        synchronized (hashtable) {
            HashSet<_MessageData> set = this.m_reactors.get(msgClass);
            if (set == null) {
                set = new HashSet();
            }
            set.add(data);
            this.m_reactors.put(msgClass, set);
        }
    }

    public void registerReactor(Class msgClass, MsgReactor r) {
        this.registerReactor(msgClass, r, null);
    }

    public void registerReactor(Msg m, MsgReactor r, Object context) {
        this.registerReactor(m.getClass(), r, context);
    }

    public void registerReactor(Msg m, MsgReactor r) {
        this.registerReactor(m.getClass(), r, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReactor(MsgReactor r) {
        Hashtable<Class, HashSet<_MessageData>> hashtable = this.m_reactors;
        synchronized (hashtable) {
            Enumeration<Class> e = this.m_reactors.keys();
            while (e.hasMoreElements()) {
                Class cls = e.nextElement();
                HashSet<_MessageData> set = this.m_reactors.get(cls);
                Iterator<_MessageData> it = set.iterator();
                while (it.hasNext()) {
                    _MessageData data = it.next();
                    if (r != data.getReactor()) continue;
                    Dbg.println(this, "unregisterReactor " + cls);
                    it.remove();
                }
                if (!set.isEmpty()) continue;
                this.m_reactors.remove(cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllReactors() {
        Hashtable<Class, HashSet<_MessageData>> hashtable = this.m_reactors;
        synchronized (hashtable) {
            this.m_reactors.clear();
        }
    }

    @Override
    public void run() {
        try {
            while (this.m_in != null) {
                ObjectInputStream oin = new ObjectInputStream(this.m_in);
                Msg msg = (Msg)oin.readObject();
                this.notifyReactors(msg);
            }
        }
        catch (IOException e) {
            this.handleBrokenConnection();
        }
        catch (ClassNotFoundException e) {
            this.handleBrokenConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connectionBroken() {
        Boolean bl = this.m_connectionBroken;
        synchronized (bl) {
            return this.m_connectionBroken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectionBroken() {
        Boolean bl = this.m_connectionBroken;
        synchronized (bl) {
            this.m_connectionBroken = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReactors(Msg msg) {
        Hashtable<Class, HashSet<_MessageData>> hashtable = this.m_reactors;
        synchronized (hashtable) {
            HashSet<_MessageData> dataObjects = new HashSet<_MessageData>();
            Class<?> _class = msg.getClass();
            while (_class != null) {
                HashSet<_MessageData> set = this.m_reactors.get(_class);
                if (set != null) {
                    for (_MessageData messageData : set) {
                        dataObjects.add(messageData);
                    }
                }
                _class = _class.getSuperclass();
            }
            for (_MessageData messageData2 : dataObjects) {
                MsgReactor r = messageData2.getReactor();
                r.notify(msg, messageData2.getContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBrokenConnection() {
        Set<MsgHandler> set = s_allHandlers;
        synchronized (set) {
            s_allHandlers.remove(this);
        }
        this.setConnectionBroken();
        this.notifyReactors(new MsgBrokenConnection());
        this.close();
    }
}

