/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.awt;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.diylc.awt.ShadedPaintContext;

public class ShadedPaint
implements Paint {
    private ShadedPaintContext context;
    private Point2D p1;
    private Point2D p2;
    private Color c1;
    private Color c2;

    public ShadedPaint(Point2D p1, Point2D p2, Color c, double shadeFactor) {
        this.p1 = p1;
        this.p2 = p2;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        this.c1 = new Color(Math.max((int)((double)r * shadeFactor), 0), Math.max((int)((double)g * shadeFactor), 0), Math.max((int)((double)b * shadeFactor), 0));
        int i = (int)(1.0 / (1.0 - shadeFactor));
        if (r == 0 && g == 0 && b == 0) {
            this.c2 = new Color(i, i, i);
        } else {
            if (r > 0 && r < i) {
                r = i;
            }
            if (g > 0 && g < i) {
                g = i;
            }
            if (b > 0 && b < i) {
                b = i;
            }
            this.c2 = new Color(Math.min((int)((double)r / shadeFactor), 255), Math.min((int)((double)g / shadeFactor), 255), Math.min((int)((double)b / shadeFactor), 255));
        }
    }

    public ShadedPaint(Point2D p1, Point2D p2, Color c2) {
        this(p1, p2, c2, 0.9f);
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (this.context == null || !this.context.getColorModel().equals(cm)) {
            this.context = new ShadedPaintContext(cm, this.p1, this.p2, xform, this.c1, this.c2);
        }
        return this.context;
    }
}

