/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.VerticalAlignment;

public class StringUtils {
    public static void drawWrappedText(String text, Graphics2D g2d, int x, int y, int maxWidth, HorizontalAlignment horizontalAlignment) {
        FontMetrics textMetrics = g2d.getFontMetrics();
        List<String> lines = StringUtils.wrap(text, textMetrics, maxWidth);
        int lineHeight = textMetrics.getHeight();
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            x += maxWidth / 2;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            x += maxWidth;
        }
        for (String line : lines) {
            StringUtils.drawCenteredText(g2d, line, x, y, horizontalAlignment, VerticalAlignment.BOTTOM);
            y += lineHeight;
        }
    }

    public static List<String> wrap(String str, FontMetrics fm, int maxWidth) {
        List<String> lines = StringUtils.splitIntoLines(str);
        if (lines.size() == 0) {
            return lines;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            StringUtils.wrapLineInto(iter.next(), strings, fm, maxWidth);
        }
        return strings;
    }

    public static void wrapLineInto(String line, List<String> list, FontMetrics fm, int maxWidth) {
        int width;
        int len = line.length();
        while (len > 0 && (width = fm.stringWidth(line)) > maxWidth) {
            int pos;
            int guess = len * maxWidth / width;
            String before = line.substring(0, guess).trim();
            if ((width = fm.stringWidth(before)) > maxWidth) {
                pos = StringUtils.findBreakBefore(line, guess);
            } else {
                pos = StringUtils.findBreakAfter(line, guess);
                if (pos != -1 && fm.stringWidth(before = line.substring(0, pos).trim()) > maxWidth) {
                    pos = StringUtils.findBreakBefore(line, guess);
                }
            }
            if (pos == -1) {
                pos = guess;
            }
            list.add(line.substring(0, pos).trim());
            line = line.substring(pos).trim();
            len = line.length();
        }
        if (len > 0) {
            list.add(line);
        }
    }

    public static int findBreakBefore(String line, int start) {
        for (int i = start; i >= 0; --i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static int findBreakAfter(String line, int start) {
        int len = line.length();
        for (int i = start; i < len; ++i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitIntoLines(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int len = str.length();
        if (len == 0) {
            strings.add("");
            return strings;
        }
        int lineStart = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\r') {
                int newlineLength = 1;
                if (i + 1 < len && str.charAt(i + 1) == '\n') {
                    newlineLength = 2;
                }
                strings.add(str.substring(lineStart, i));
                lineStart = i + newlineLength;
                if (newlineLength != 2) continue;
                ++i;
                continue;
            }
            if (c != '\n') continue;
            strings.add(str.substring(lineStart, i));
            lineStart = i + 1;
        }
        if (lineStart < len) {
            strings.add(str.substring(lineStart));
        }
        return strings;
    }

    public static void drawCenteredText(Graphics2D g2d, String text, int x, int y, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        String[] parts = text.split("\n");
        if (parts.length > 1) {
            FontMetrics fontMetrics = g2d.getFontMetrics();
            Rectangle stringBounds = fontMetrics.getStringBounds(parts[0], g2d).getBounds();
            for (int i = 0; i < parts.length; ++i) {
                StringUtils.drawCenteredText(g2d, parts[i], x, (int)((double)y - (double)(stringBounds.height * (parts.length - 1)) / 2.0 + (double)(i * stringBounds.height)), horizontalAlignment, verticalAlignment);
            }
            return;
        }
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle stringBounds = fontMetrics.getStringBounds(text, g2d).getBounds();
        Font font = g2d.getFont();
        FontRenderContext renderContext = g2d.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(renderContext, text);
        Rectangle visualBounds = glyphVector.getVisualBounds().getBounds();
        int textX = 0;
        switch (horizontalAlignment) {
            case CENTER: {
                textX = x - stringBounds.width / 2;
                break;
            }
            case LEFT: {
                textX = x;
                break;
            }
            case RIGHT: {
                textX = x - stringBounds.width;
            }
        }
        int textY = 0;
        switch (verticalAlignment) {
            case TOP: {
                textY = y + stringBounds.height;
                break;
            }
            case CENTER: {
                textY = y - visualBounds.height / 2 - visualBounds.y;
                break;
            }
            case BOTTOM: {
                textY = y - visualBounds.y;
            }
        }
        g2d.drawString(text, textX, textY);
    }
}

