/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.components.semiconductors.SymbolFlipping;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class Abstract3LegSymbol
extends AbstractComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color COLOR = Color.black;
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected Color color = COLOR;
    protected SymbolFlipping flip = SymbolFlipping.NONE;
    protected Display display = Display.NAME;
    protected transient Shape[] body;
    protected Orientation orientation = Orientation.DEFAULT;
    protected boolean moveLabel = false;

    public Abstract3LegSymbol() {
        this.updateControlPoints();
        this.controlPoints[3] = this.getDefaultLabelPosition(this.controlPoints);
    }

    public Point[] getControlPoints() {
        if (this.controlPoints.length == 3) {
            this.controlPoints = new Point[]{this.controlPoints[0], this.controlPoints[1], this.controlPoints[2], this.getDefaultLabelPosition(this.controlPoints)};
        }
        return this.controlPoints;
    }

    protected Point getDefaultLabelPosition(Point[] oldControlPoints) {
        int f = this.flip == SymbolFlipping.X ? -1 : 1;
        int d = this.flip == SymbolFlipping.X ? (int)PIN_SPACING.convertToPixels() / 2 : 0;
        return new Point(oldControlPoints[0].x + f * (int)(PIN_SPACING.convertToPixels() * 1.5 + (double)d), oldControlPoints[0].y);
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            finalColor = SELECTION_COLOR;
        } else if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalColor = theme.getOutlineColor();
        } else {
            finalColor = this.color;
        }
        g2d.setColor(finalColor);
        if (this.body == null) {
            this.body = this.getBody();
            this.applyOrientation(this.body);
        }
        AffineTransform old = g2d.getTransform();
        Point[] controlPoints = this.getControlPoints();
        if (this.flip == SymbolFlipping.Y) {
            g2d.translate(0, controlPoints[0].y);
            g2d.scale(1.0, -1.0);
            g2d.translate(0, -1 * controlPoints[0].y);
        } else if (this.flip == SymbolFlipping.X) {
            g2d.translate(controlPoints[0].x, 0);
            g2d.scale(-1.0, 1.0);
            g2d.translate(-1 * controlPoints[0].x, 0);
        }
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.draw(this.body[0]);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(this.body[1]);
        g2d.fill(this.body[2]);
        g2d.setTransform(old);
        g2d.setFont(project.getFont());
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR;
        }
        g2d.setColor(finalLabelColor);
        String label = "";
        String string = this.display == Display.NAME ? this.getName() : (label = this.getValue() == null ? "" : this.getValue().toString());
        if (this.display == Display.NONE) {
            label = "";
        }
        if (this.display == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D textRect = fontMetrics.getStringBounds(label, g2d);
        Rectangle shapeRect = this.body[0].getBounds().union(this.body[1].getBounds()).union(this.body[2].getBounds());
        if (this.getMoveLabel()) {
            StringUtils.drawCenteredText(g2d, label, controlPoints[3].x, controlPoints[3].y, this.flip == SymbolFlipping.X ? HorizontalAlignment.RIGHT : HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        } else {
            StringUtils.drawCenteredText(g2d, label, this.getLabelX(shapeRect, textRect, fontMetrics, outlineMode), this.getLabelY(shapeRect, textRect, fontMetrics, outlineMode), this.flip == SymbolFlipping.X ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
        }
    }

    public Point getControlPoint(int index) {
        return this.getControlPoints()[index];
    }

    public int getControlPointCount() {
        return this.getControlPoints().length;
    }

    protected int getLabelX(Rectangle2D shapeRect, Rectangle2D textRect, FontMetrics fontMetrics, boolean outlineMode) {
        int f = this.flip == SymbolFlipping.X ? -1 : 1;
        int d = this.flip == SymbolFlipping.X ? (int)PIN_SPACING.convertToPixels() / 2 : 0;
        return this.getControlPoints()[0].x + f * (int)(PIN_SPACING.convertToPixels() * 1.5 + (double)d);
    }

    protected int getLabelY(Rectangle2D shapeRect, Rectangle2D textRect, FontMetrics fontMetrics, boolean outlineMode) {
        return this.getControlPoints()[0].y;
    }

    protected void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        Point[] controlPoints = this.getControlPoints();
        int x = controlPoints[0].x;
        int y = controlPoints[0].y;
        controlPoints[1].x = x + pinSpacing * 2;
        controlPoints[1].y = y - pinSpacing * 2;
        controlPoints[2].x = x + pinSpacing * 2;
        controlPoints[2].y = y + pinSpacing * 2;
        controlPoints[3].x = x + (int)(PIN_SPACING.convertToPixels() * 2.0);
        controlPoints[3].y = y;
        if (this.getOrientation() != Orientation.DEFAULT) {
            Point first = controlPoints[0];
            double angle = Double.parseDouble(this.getOrientation().name().replace("_", ""));
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), first.x, first.y);
            for (int i = 1; i < controlPoints.length; ++i) {
                rotate.transform(controlPoints[i], controlPoints[i]);
            }
        }
        if (this.flip == SymbolFlipping.X) {
            controlPoints[1].x = controlPoints[0].x - (controlPoints[1].x - controlPoints[0].x);
            controlPoints[2].x = controlPoints[0].x - (controlPoints[2].x - controlPoints[0].x);
            controlPoints[3].x = controlPoints[0].x - (controlPoints[3].x - controlPoints[0].x);
        }
        if (this.flip == SymbolFlipping.Y) {
            controlPoints[1].y = controlPoints[0].y - (controlPoints[1].y - controlPoints[0].y);
            controlPoints[2].y = controlPoints[0].y - (controlPoints[2].y - controlPoints[0].y);
            controlPoints[3].y = controlPoints[0].y - (controlPoints[3].y - controlPoints[0].y);
        }
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return index < 3 || this.getMoveLabel() ? VisibilityPolicy.WHEN_SELECTED : VisibilityPolicy.NEVER;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isControlPointSticky(int index) {
        return index < 3;
    }

    public void setControlPoint(Point point, int index) {
        this.getControlPoints()[index].setLocation(point);
        this.body = null;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return pointIndex == 3;
    }

    public boolean canControlPointOverlap(int index) {
        return index >= 3;
    }

    @EditableProperty
    public SymbolFlipping getFlip() {
        return this.flip;
    }

    public void setFlip(SymbolFlipping flip) {
        this.flip = flip;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Moveable Label")
    public boolean getMoveLabel() {
        return this.moveLabel;
    }

    public void setMoveLabel(boolean moveLabel) {
        this.moveLabel = moveLabel;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty
    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = Orientation.DEFAULT;
        }
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    protected void applyOrientation(Shape[] body) {
        if (this.getOrientation() == Orientation.DEFAULT) {
            return;
        }
        Point first = this.getControlPoints()[0];
        double angle = Double.parseDouble(this.getOrientation().name().replace("_", ""));
        AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), first.x, first.y);
        if (body != null) {
            for (int i = 0; i < body.length; ++i) {
                body[i] = rotate.createTransformedShape(body[i]);
            }
        }
    }

    public String getControlPointNodeName(int index) {
        if (index >= 3) {
            return null;
        }
        return Integer.toString(index + 1);
    }

    protected abstract Shape[] getBody();
}

