/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.chassis;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.shapes.AbstractShape;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Chassis Panel", author="Branislav Stojkovic", category="Electro-Mechanical", instanceNamePrefix="CP", description="One side of a chassis, with or withouth rounded edges", zOrder=1.0, bomPolicy=BomPolicy.SHOW_ONLY_TYPE_NAME, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class ChassisPanel
extends AbstractShape {
    private static final long serialVersionUID = 1L;
    protected Size edgeRadius = new Size(Double.valueOf(0.0), SizeUnit.mm);

    public ChassisPanel() {
        this.color = LIGHT_METAL_COLOR;
        this.borderColor = LIGHT_METAL_COLOR.darker();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)((int)this.borderThickness.convertToPixels())));
        int radius = (int)this.edgeRadius.convertToPixels();
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(this.color);
            g2d.fillRoundRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y, radius, radius);
            g2d.setComposite(oldComposite);
        }
        drawingObserver.stopTracking();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.drawRoundRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y, radius, radius);
    }

    @EditableProperty(name="Radius")
    public Size getEdgeRadius() {
        return this.edgeRadius;
    }

    public void setEdgeRadius(Size edgeRadius) {
        this.edgeRadius = edgeRadius;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(LIGHT_METAL_COLOR);
        g2d.fillRect(2 / factor, 4 / factor, width - 4 / factor, height - 8 / factor);
        g2d.setColor(LIGHT_METAL_COLOR.darker());
        g2d.drawRect(2 / factor, 4 / factor, width - 4 / factor, height - 8 / factor);
    }
}

