/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.poi.util.IOUtils;
import org.diylc.appframework.miscutils.IconImageConverter;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PercentEditor;
import sun.awt.image.ToolkitImage;

@ComponentDescriptor(name="Image", author="Branislav Stojkovic", category="Misc", description="User defined image", instanceNamePrefix="Img", zOrder=4.0, flexibleZOrder=true, bomPolicy=BomPolicy.NEVER_SHOW)
public class Image
extends AbstractTransparentComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static String DEFAULT_TEXT = "Double click to edit text";
    private static ImageIcon ICON;
    private static byte DEFAULT_SCALE;
    private Point point = new Point(0, 0);
    @XStreamConverter(value=IconImageConverter.class)
    @Deprecated
    private ImageIcon image;
    private byte[] data;
    private Byte scale;
    private byte newScale = DEFAULT_SCALE;

    public String getControlPointNodeName(int index) {
        return null;
    }

    public Image() {
        try {
            this.data = IOUtils.toByteArray((InputStream)Image.class.getResourceAsStream("image.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        double s = 1.0 * (double)this.getScale() / (double)DEFAULT_SCALE;
        Rectangle clip = g2d.getClip().getBounds();
        if (!clip.intersects(new Rectangle2D.Double(this.point.getX(), this.point.getY(), (double)this.getImage().getIconWidth() * s, (double)this.getImage().getIconHeight() * s))) {
            return;
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.scale(s, s);
        g2d.drawImage(this.getImage().getImage(), (int)((double)this.point.x / s), (int)((double)this.point.y / s), null);
        if (componentState == ComponentState.SELECTED) {
            g2d.setComposite(oldComposite);
            g2d.scale(1.0 / s, 1.0 / s);
            g2d.setColor(SELECTION_COLOR);
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            g2d.drawRect(this.point.x, this.point.y, (int)((double)this.getImage().getIconWidth() * s), (int)((double)this.getImage().getIconHeight() * s));
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.drawImage(ICON.getImage(), this.point.x, this.point.y, null);
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    public ImageIcon getImage() {
        if (this.image != null) {
            BufferedImage bi = ((ToolkitImage)this.image.getImage()).getBufferedImage();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bi, "png", baos);
                this.data = baos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.image = null;
        }
        return new ImageIcon(this.data);
    }

    @EditableProperty(name="Image")
    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.image = null;
    }

    @PercentEditor(_100PercentValue=25)
    @EditableProperty(defaultable=false)
    public byte getScale() {
        if (this.scale != null) {
            this.newScale = (byte)(this.scale / 2);
            this.scale = null;
        }
        return this.newScale;
    }

    public void setScale(byte scale) {
        this.newScale = scale;
    }

    public String getName() {
        return super.getName();
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    static {
        DEFAULT_SCALE = (byte)25;
        String name = "image.png";
        URL imgURL = Image.class.getResource(name);
        if (imgURL != null) {
            ICON = new ImageIcon(imgURL, name);
        }
    }
}

