/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractRadialComponent;
import org.diylc.components.passive.Voltage;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Ceramic Capacitor (Radial)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="C", description="Standard radial ceramic capacitor", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class RadialCeramicDiskCapacitor
extends AbstractRadialComponent<Capacitance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.25), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Color BODY_COLOR = Color.decode("#F0E68C");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    private Capacitance value = null;
    @Deprecated
    private Voltage voltage = Voltage._63V;
    private org.diylc.core.measures.Voltage voltageNew = null;

    public RadialCeramicDiskCapacitor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Capacitance getValue() {
        return this.value;
    }

    public void setValue(Capacitance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getVoltageNew() == null ? "" : " " + this.getVoltageNew().toString());
    }

    @EditableProperty(name="Voltage")
    public org.diylc.core.measures.Voltage getVoltageNew() {
        return this.voltageNew;
    }

    public void setVoltageNew(org.diylc.core.measures.Voltage voltageNew) {
        this.voltageNew = voltageNew;
    }

    @Deprecated
    public Voltage getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        g2d.fillOval(4, height / 2 - 3, width - 8, 6);
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(4, height / 2 - 3, width - 8, 6);
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    @Override
    protected Shape getBodyShape() {
        return new Ellipse2D.Double(0.0, 0.0, this.getLength().convertToPixels(), this.getClosestOdd(this.getWidth().convertToPixels()));
    }
}

