/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.core.measures.Voltage;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Transformer Coil", author="Branislav Stojkovic", category="Schematic Symbols", instanceNamePrefix="L", description="Transformer coil symbol. Use multiple instances together with \"Transformer Core Symbol\"<br>to draw transformer schematics.", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Schematic")
public class TransformerCoil
extends AbstractComponent<Voltage> {
    private static final long serialVersionUID = 1L;
    public static Size TAP_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    public static Size LEAD_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Size OFFSET = new Size(Double.valueOf(0.025), SizeUnit.in);
    public static Color COLOR = Color.blue;
    public static Color LEAD_COLOR = Color.black;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0)};
    private Orientation orientation = Orientation.DEFAULT;
    private Voltage voltage = null;
    private Color color = COLOR;
    private Size tapSpacing = TAP_SPACING;
    private Shape[] body = null;

    public TransformerCoil() {
        this.updateControlPoints();
    }

    private void updateControlPoints() {
        double spacing = this.getTapSpacing().convertToPixels();
        int fx = 1;
        int fy = 1;
        switch (this.orientation) {
            case DEFAULT: {
                fx = 0;
                break;
            }
            case _90: {
                fx = -1;
                fy = 0;
                break;
            }
            case _180: {
                fx = 0;
                fy = -1;
                break;
            }
            case _270: {
                fy = 0;
                break;
            }
        }
        Point refPoint = this.controlPoints[0];
        for (int i = 1; i < this.controlPoints.length; ++i) {
            this.controlPoints[i].setLocation((double)refPoint.x + (double)(i * fx) * spacing, (double)refPoint.y + (double)(i * fy) * spacing);
        }
    }

    @EditableProperty
    public Voltage getValue() {
        return this.voltage;
    }

    public void setValue(Voltage value) {
        this.voltage = value;
    }

    @EditableProperty(defaultable=true)
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Size", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getTapSpacing() {
        return this.tapSpacing;
    }

    public void setTapSpacing(Size tapSpacing) {
        this.tapSpacing = tapSpacing;
        this.body = null;
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Shape[] body = this.getBody();
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            finalColor = SELECTION_COLOR;
        } else if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalColor = theme.getOutlineColor();
        } else {
            finalColor = this.color;
        }
        g2d.setColor(LEAD_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(body[0]);
        g2d.setColor(finalColor);
        g2d.draw(body[1]);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR);
        g2d.drawLine(width / 8, height / 2, width / 8, height * 6 / 8);
        g2d.drawLine(width * 7 / 8, height / 2, width * 7 / 8, height * 6 / 8);
        g2d.setColor(COLOR);
        GeneralPath polyline = new GeneralPath();
        polyline.moveTo(width / 8, height / 2);
        polyline.curveTo(width / 8, height / 4, width * 3 / 8, height / 4, width * 3 / 8, height / 2);
        polyline.curveTo(width * 3 / 8, height / 4, width * 5 / 8, height / 4, width * 5 / 8, height / 2);
        polyline.curveTo(width * 5 / 8, height / 4, width * 7 / 8, height / 4, width * 7 / 8, height / 2);
        g2d.draw(polyline);
    }

    public Shape[] getBody() {
        if (this.body == null) {
            double spacing = LEAD_SPACING.convertToPixels();
            int fx = 1;
            int fy = 1;
            switch (this.orientation) {
                case DEFAULT: {
                    fy = 0;
                    break;
                }
                case _90: {
                    fx = 0;
                    break;
                }
                case _180: {
                    fx = -1;
                    fy = 0;
                    break;
                }
                case _270: {
                    fx = 0;
                    fy = -1;
                    break;
                }
            }
            GeneralPath leads = new GeneralPath();
            GeneralPath coil = new GeneralPath();
            int coilsPerTap = (int)Math.round(4.0 * this.tapSpacing.convertToPixels() / TAP_SPACING.convertToPixels());
            double offset = OFFSET.convertToPixels();
            int i = 0;
            leads.moveTo(this.controlPoints[i].x, this.controlPoints[i].y);
            leads.lineTo((double)this.controlPoints[i].x + (double)fx * (spacing + offset), (double)this.controlPoints[i].y + (double)fy * (spacing + offset));
            leads.moveTo(this.controlPoints[i + 1].x, this.controlPoints[i + 1].y);
            leads.lineTo((double)this.controlPoints[i + 1].x + (double)fx * (spacing + offset), (double)this.controlPoints[i + 1].y + (double)fy * (spacing + offset));
            double dx = this.controlPoints[i + 1].getX() - this.controlPoints[i].getX();
            double dy = this.controlPoints[i + 1].getY() - this.controlPoints[i].getY();
            double d = Math.max(Math.abs(dx), Math.abs(dy)) / (double)coilsPerTap;
            double x1 = this.controlPoints[i].getX() + (double)fx * (spacing + d + offset);
            double y1 = this.controlPoints[i].getY() + (double)fy * (spacing + d + offset);
            double x2 = this.controlPoints[i + 1].getX() + (double)fx * (spacing + d + offset);
            double y2 = (double)this.controlPoints[i + 1].y + (double)fy * (spacing + d + offset);
            double dxa = x2 - x1;
            double dya = y2 - y1;
            coil.moveTo(this.controlPoints[i].getX() + (double)fx * (spacing + offset), this.controlPoints[i].getY() + (double)fy * (spacing + offset));
            for (int j = 0; j < coilsPerTap; ++j) {
                coil.curveTo(x1 + dxa / (double)coilsPerTap * (double)j, y1 + dya / (double)coilsPerTap * (double)j, x1 + dxa / (double)coilsPerTap * (double)(j + 1), y1 + dya / (double)coilsPerTap * (double)(j + 1), this.controlPoints[i].getX() + (double)fx * (spacing + offset) + dx / (double)coilsPerTap * (double)(j + 1), this.controlPoints[i].getY() + (double)fy * (spacing + offset) + dy / (double)coilsPerTap * (double)(j + 1));
            }
            this.body = new Shape[2];
            this.body[0] = leads;
            this.body[1] = coil;
        }
        return this.body;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

