/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Area;
import org.diylc.common.Display;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.semiconductors.TransistorPinout;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.netlist.ISpiceMapper;

public abstract class AbstractTransistorPackage
extends AbstractTransparentComponent<String>
implements ISpiceMapper {
    private static final long serialVersionUID = 1L;
    protected String value = "";
    protected TransistorPinout pinout;
    protected Orientation orientation = Orientation.DEFAULT;
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected transient Area[] body;
    protected Color bodyColor;
    protected Color borderColor;
    protected Color labelColor = LABEL_COLOR;
    protected Display display = Display.NAME;

    protected abstract void updateControlPoints();

    @Override
    public int mapToSpiceNode(int index) {
        if (this.getPinout() == null) {
            return index;
        }
        switch (this.getPinout()) {
            case BJT_CBE: {
                return index;
            }
            case BJT_EBC: {
                return 2 - index;
            }
            case JFET_DGS: 
            case MOSFET_DGS: {
                return index;
            }
            case JFET_DSG: 
            case MOSFET_DSG: {
                switch (index) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                }
            }
            case JFET_GSD: 
            case MOSFET_GSD: {
                switch (index) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                }
            }
            case JFET_SGD: 
            case MOSFET_SGD: {
                return 2 - index;
            }
        }
        return index;
    }

    @Override
    public String getComment() {
        return this.getPinout() == null ? "Pinout not configured, validate this line" : this.getPinout().toString() + " pinout";
    }

    @Override
    public String getPrefix() {
        if (this.getPinout() == null) {
            return null;
        }
        return this.getPinout().name().substring(0, 1);
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.NAME;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty
    public TransistorPinout getPinout() {
        return this.pinout;
    }

    public void setPinout(TransistorPinout pinout) {
        this.pinout = pinout;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public String getControlPointNodeName(int index) {
        if (index >= 3) {
            return null;
        }
        return Integer.toString(index + 1);
    }
}

