/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.transform;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import org.diylc.common.IComponentTransformer;
import org.diylc.common.Orientation;
import org.diylc.components.misc.Label;
import org.diylc.components.misc.PCBText;
import org.diylc.core.IDIYComponent;

public class TextTransformer
implements IComponentTransformer {
    public boolean canRotate(IDIYComponent<?> component) {
        return component.getClass().equals(Label.class) || component.getClass().equals(PCBText.class);
    }

    public boolean canMirror(IDIYComponent<?> component) {
        return false;
    }

    public boolean mirroringChangesCircuit() {
        return false;
    }

    public void rotate(IDIYComponent<?> component, Point center, int direction) {
        Orientation o;
        AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966 * (double)direction, center.x, center.y);
        for (int index = 0; index < component.getControlPointCount(); ++index) {
            Point p = new Point(component.getControlPoint(index));
            rotate.transform(p, p);
            component.setControlPoint(p, index);
        }
        if (component instanceof Label) {
            Label snap = (Label)component;
            o = snap.getOrientation();
            int oValue = o.ordinal();
            if ((oValue += direction) < 0) {
                oValue = Orientation.values().length - 1;
            }
            if (oValue >= Orientation.values().length) {
                oValue = 0;
            }
            o = Orientation.values()[oValue];
            snap.setOrientation(o);
        } else if (component instanceof PCBText) {
            PCBText snap = (PCBText)component;
            o = snap.getOrientation();
            int oValue = o.ordinal();
            if ((oValue += direction) < 0) {
                oValue = Orientation.values().length - 1;
            }
            if (oValue >= Orientation.values().length) {
                oValue = 0;
            }
            o = Orientation.values()[oValue];
            snap.setOrientation(o);
        }
    }

    public void mirror(IDIYComponent<?> component, Point center, int direction) {
        throw new RuntimeException("Unexpected call to mirror() in LabelTransformer");
    }
}

