/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.diylc.common.INetlistAnalyzer;
import org.diylc.core.IDIYComponent;
import org.diylc.netlist.ISpiceMapper;
import org.diylc.netlist.Netlist;
import org.diylc.netlist.NetlistAnalyzer;
import org.diylc.netlist.Node;
import org.diylc.netlist.Summary;
import org.diylc.netlist.TreeException;

public class SpiceAnalyzer
extends NetlistAnalyzer
implements INetlistAnalyzer {
    public String getName() {
        return "Generate Spice Netlist (beta)";
    }

    public String getIconName() {
        return "JarBeanInto";
    }

    public String getFontName() {
        return "Courier New";
    }

    protected Summary summarize(Netlist netlist, Node preferredOutput) throws TreeException {
        ArrayList allComponents = new ArrayList(SpiceAnalyzer.extractComponents((Netlist)netlist));
        Collections.sort(allComponents, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> o1, IDIYComponent<?> o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        StringBuilder sb = new StringBuilder();
        List groups = netlist.getSortedGroups();
        int unconnectedIndex = groups.size();
        int maxLen = 0;
        for (IDIYComponent c : allComponents) {
            if (c.getName().length() <= maxLen) continue;
            maxLen = c.getName().length();
        }
        for (IDIYComponent c : allComponents) {
            String comment;
            int i;
            String name = c.getName();
            String prefix = null;
            if (c instanceof ISpiceMapper) {
                prefix = ((ISpiceMapper)c).getPrefix();
            }
            if (prefix != null && !name.toLowerCase().startsWith(prefix.toLowerCase())) {
                name = prefix + name;
            }
            sb.append(this.fill(name, (int)(Math.ceil((double)maxLen / 5.0) * 5.0)));
            sb.append(" ");
            int[] nodeIndices = new int[c.getControlPointCount()];
            for (i = 0; i < c.getControlPointCount(); ++i) {
                int pointIndex = i;
                int nodeIndex = this.find(new Node(c, pointIndex), groups);
                if (nodeIndex < 0) {
                    nodeIndex = unconnectedIndex++;
                }
                ++nodeIndex;
                if (c instanceof ISpiceMapper) {
                    pointIndex = ((ISpiceMapper)c).mapToSpiceNode(pointIndex);
                }
                nodeIndices[pointIndex] = nodeIndex;
            }
            for (i = 0; i < c.getControlPointCount(); ++i) {
                sb.append(this.fill(SpiceAnalyzer.formatSpiceNode(nodeIndices[i]), 5));
                sb.append(" ");
            }
            sb.append(c.getValue());
            if (c instanceof ISpiceMapper && (comment = ((ISpiceMapper)c).getComment()) != null) {
                sb.append(" ; ").append(comment);
            }
            sb.append("<br>");
        }
        return new Summary(netlist, sb.toString());
    }

    private static String formatSpiceNode(int i) {
        return String.format("N%03d", i);
    }

    private String fill(String source, int desiredLength) {
        String res = source;
        for (int i = 0; i < desiredLength - source.length(); ++i) {
            res = res + "&nbsp;";
        }
        return res;
    }
}

