/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.parsing;

import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.boards.AbstractBoard;
import org.diylc.components.boards.BlankBoard;
import org.diylc.components.boards.PerfBoard;
import org.diylc.components.boards.VeroBoard;
import org.diylc.components.connectivity.CopperTrace;
import org.diylc.components.connectivity.HookupWire;
import org.diylc.components.connectivity.Jumper;
import org.diylc.components.connectivity.SolderPad;
import org.diylc.components.connectivity.TraceCut;
import org.diylc.components.electromechanical.MiniToggleSwitch;
import org.diylc.components.electromechanical.ToggleSwitchType;
import org.diylc.components.misc.BOM;
import org.diylc.components.misc.Label;
import org.diylc.components.passive.PotentiometerPanel;
import org.diylc.components.passive.RadialElectrolytic;
import org.diylc.components.passive.RadialFilmCapacitor;
import org.diylc.components.passive.Resistor;
import org.diylc.components.passive.Taper;
import org.diylc.components.passive.TrimmerPotentiometer;
import org.diylc.components.semiconductors.DIL_IC;
import org.diylc.components.semiconductors.DiodePlastic;
import org.diylc.components.semiconductors.LED;
import org.diylc.components.semiconductors.SIL_IC;
import org.diylc.components.semiconductors.TransistorTO92;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.parsing.IOldFileParser;
import org.diylc.presenter.CalcUtils;
import org.diylc.presenter.ComparatorFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class V1FileParser
implements IOldFileParser {
    private static final Logger LOG = Logger.getLogger(V1FileParser.class);
    private static final Size V1_GRID_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    private static final Map<String, Color> V1_COLOR_MAP = new HashMap<String, Color>();
    private long randSeed = 0L;

    public boolean canParse(String version) {
        return version == null || version.trim().isEmpty();
    }

    public Project parseFile(Element root, List<String> warnings) {
        AbstractBoard board;
        Project project = new Project();
        project.setTitle(root.getAttribute("Project"));
        project.setAuthor(root.getAttribute("Credits"));
        project.setGridSpacing(V1_GRID_SPACING);
        project.setDescription("Automatically converted from V1 format.");
        String type = root.getAttribute("Type");
        int width = Integer.parseInt(root.getAttribute("Width")) + 1;
        int height = Integer.parseInt(root.getAttribute("Height")) + 1;
        int boardWidth = (int)((double)(width * 200) * V1_GRID_SPACING.getValue());
        int boardHeight = (int)((double)(height * 200) * V1_GRID_SPACING.getValue());
        int projectWidth = (int)project.getWidth().convertToPixels();
        int projectHeight = (int)project.getHeight().convertToPixels();
        int x = (projectWidth - boardWidth) / 2;
        int y = (projectHeight - boardHeight) / 2;
        if (type.equalsIgnoreCase("pcb")) {
            board = new BlankBoard();
            board.setBoardColor(Color.white);
            board.setBorderColor(Color.black);
        } else if (type.equalsIgnoreCase("perfboard")) {
            board = new PerfBoard();
        } else if (type.equalsIgnoreCase("stripboard")) {
            board = new VeroBoard();
        } else {
            throw new IllegalArgumentException("Unrecognized board type: " + type);
        }
        board.setName("Main board");
        Point referencePoint = new Point(CalcUtils.roundToGrid((double)x, (Size)V1_GRID_SPACING), CalcUtils.roundToGrid((double)y, (Size)V1_GRID_SPACING));
        board.setControlPoint(referencePoint, 0);
        board.setControlPoint(new Point(CalcUtils.roundToGrid((double)(x + boardWidth), (Size)V1_GRID_SPACING), CalcUtils.roundToGrid((double)(y + boardHeight), (Size)V1_GRID_SPACING)), 1);
        project.getComponents().add(board);
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            int dy;
            int dx;
            int sizeY;
            AbstractTransparentComponent ic;
            AbstractLeadedComponent capacitor;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName();
            String nameAttr = node.getAttributes().getNamedItem("Name").getNodeValue();
            Node valueNode = node.getAttributes().getNamedItem("Value");
            String valueAttr = valueNode == null ? null : valueNode.getNodeValue();
            int x1Attr = Integer.parseInt(node.getAttributes().getNamedItem("X1").getNodeValue());
            int y1Attr = Integer.parseInt(node.getAttributes().getNamedItem("Y1").getNodeValue());
            Point point1 = this.convertV1CoordinatesToV3Point(referencePoint, x1Attr, y1Attr);
            Point point2 = null;
            Integer x2Attr = null;
            Integer y2Attr = null;
            Color color = null;
            if (node.getAttributes().getNamedItem("Color") != null) {
                String colorAttr = node.getAttributes().getNamedItem("Color").getNodeValue();
                color = V1_COLOR_MAP.get(colorAttr.toLowerCase());
            }
            if (node.getAttributes().getNamedItem("X2") != null && node.getAttributes().getNamedItem("Y2") != null) {
                x2Attr = Integer.parseInt(node.getAttributes().getNamedItem("X2").getNodeValue());
                y2Attr = Integer.parseInt(node.getAttributes().getNamedItem("Y2").getNodeValue());
                point2 = this.convertV1CoordinatesToV3Point(referencePoint, x2Attr, y2Attr);
            }
            Object component = null;
            if (nodeName.equalsIgnoreCase("text")) {
                LOG.debug((Object)("Recognized " + nodeName));
                Label label = new Label();
                label.setName(nameAttr);
                if (color != null) {
                    label.setColor(color);
                }
                label.setValue(valueAttr);
                label.setHorizontalAlignment(HorizontalAlignment.LEFT);
                label.setVerticalAlignment(VerticalAlignment.CENTER);
                label.setControlPoint(this.convertV1CoordinatesToV3Point(referencePoint, x1Attr, y1Attr), 0);
                component = label;
            } else if (nodeName.equalsIgnoreCase("pad")) {
                LOG.debug((Object)("Recognized " + nodeName));
                SolderPad pad = new SolderPad();
                pad.setName(nameAttr);
                if (color != null) {
                    pad.setLeadColor(color);
                }
                pad.setControlPoint(this.convertV1CoordinatesToV3Point(referencePoint, x1Attr, y1Attr), 0);
                component = pad;
            } else if (nodeName.equalsIgnoreCase("cut")) {
                LOG.debug((Object)("Recognized " + nodeName));
                TraceCut cut = new TraceCut();
                cut.setCutBetweenHoles(false);
                cut.setName(nameAttr);
                cut.setControlPoint(this.convertV1CoordinatesToV3Point(referencePoint, x1Attr, y1Attr), 0);
                component = cut;
            } else if (nodeName.equalsIgnoreCase("trace")) {
                LOG.debug((Object)("Recognized " + nodeName));
                CopperTrace trace = new CopperTrace();
                trace.setName(nameAttr);
                if (color != null) {
                    trace.setLeadColor(color);
                }
                trace.setControlPoint(point1, 0);
                trace.setControlPoint(point2, 1);
                component = trace;
            } else if (nodeName.equalsIgnoreCase("jumper")) {
                LOG.debug((Object)("Recognized " + nodeName));
                Jumper jumper = new Jumper();
                jumper.setName(nameAttr);
                jumper.setControlPoint(point1, 0);
                jumper.setControlPoint(point2, 1);
                component = jumper;
            } else if (nodeName.equalsIgnoreCase("wire")) {
                LOG.debug((Object)("Recognized " + nodeName));
                HookupWire wire = new HookupWire();
                long seed = Long.parseLong(node.getAttributes().getNamedItem("Seed").getNodeValue());
                Random r = new Random(seed);
                this.randSeed = seed;
                int d = (int)Math.round(Math.sqrt(Math.pow(point1.x - point2.x, 2.0) + Math.pow(point1.y - point2.y, 2.0)) / 2.0);
                int x2 = (int)((long)point1.x + Math.round((double)(point2.x - point1.x) * 0.4) + (long)this.myRandom(d, r));
                int y2 = (int)((long)point1.y + Math.round((double)(point2.y - point1.y) * 0.4) + (long)this.myRandom(d, r));
                int x3 = (int)((long)point1.x + Math.round((double)(point2.x - point1.x) * 0.6) + (long)this.myRandom(d, r));
                int y3 = (int)((long)point1.y + Math.round((double)(point2.y - point1.y) * 0.6) + (long)this.myRandom(d, r));
                wire.setName(nameAttr);
                String colorAttr = node.getAttributes().getNamedItem("Color").getNodeValue();
                wire.setLeadColor(this.parseV1Color(colorAttr));
                wire.setControlPoint(point1, 0);
                wire.setControlPoint(new Point(x2, y2), 1);
                wire.setControlPoint(new Point(x3, y3), 2);
                wire.setControlPoint(point2, 3);
                component = wire;
            } else if (nodeName.equalsIgnoreCase("resistor")) {
                LOG.debug((Object)("Recognized " + nodeName));
                Resistor resistor = new Resistor();
                resistor.setName(nameAttr);
                try {
                    resistor.setValue(Resistance.parseResistance((String)valueAttr));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not set value of " + nameAttr));
                }
                resistor.setLength(new Size(Double.valueOf(6.35), SizeUnit.mm));
                resistor.setWidth(new Size(Double.valueOf(2.2), SizeUnit.mm));
                resistor.setControlPoint(point1, 0);
                resistor.setControlPoint(point2, 1);
                component = resistor;
            } else if (nodeName.equalsIgnoreCase("capacitor")) {
                LOG.debug((Object)("Recognized " + nodeName));
                capacitor = new RadialFilmCapacitor();
                capacitor.setName(nameAttr);
                try {
                    ((RadialFilmCapacitor)capacitor).setValue(Capacitance.parseCapacitance((String)valueAttr));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not set value of " + nameAttr));
                }
                capacitor.setLength(new Size(Double.valueOf(6.0), SizeUnit.mm));
                capacitor.setWidth(new Size(Double.valueOf(2.0), SizeUnit.mm));
                capacitor.setControlPoint(point1, 0);
                capacitor.setControlPoint(point2, 1);
                component = capacitor;
            } else if (nodeName.equalsIgnoreCase("electrolyte")) {
                LOG.debug((Object)("Recognized " + nodeName));
                capacitor = new RadialElectrolytic();
                capacitor.setName(nameAttr);
                try {
                    ((RadialElectrolytic)capacitor).setValue(Capacitance.parseCapacitance((String)valueAttr));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not set value of " + nameAttr));
                }
                try {
                    String sizeAttr = node.getAttributes().getNamedItem("Size").getNodeValue();
                    if (sizeAttr.equalsIgnoreCase("small")) {
                        capacitor.setLength(new Size(Double.valueOf(3.5), SizeUnit.mm));
                    } else if (sizeAttr.equalsIgnoreCase("medium")) {
                        capacitor.setLength(new Size(Double.valueOf(5.0), SizeUnit.mm));
                    } else if (sizeAttr.equalsIgnoreCase("large")) {
                        capacitor.setLength(new Size(Double.valueOf(7.0), SizeUnit.mm));
                    } else {
                        capacitor.setLength(new Size(Double.valueOf(4.0), SizeUnit.mm));
                    }
                }
                catch (Exception e) {
                    capacitor.setLength(new Size(Double.valueOf(5.0), SizeUnit.mm));
                    LOG.debug((Object)("Could not set size of " + nameAttr));
                }
                capacitor.setControlPoint(point1, 0);
                capacitor.setControlPoint(point2, 1);
                component = capacitor;
            } else if (nodeName.equalsIgnoreCase("diode")) {
                LOG.debug((Object)("Recognized " + nodeName));
                capacitor = new DiodePlastic();
                capacitor.setName(nameAttr);
                try {
                    ((DiodePlastic)capacitor).setValue(valueAttr);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not set value of " + nameAttr));
                }
                capacitor.setLength(new Size(Double.valueOf(6.0), SizeUnit.mm));
                capacitor.setWidth(new Size(Double.valueOf(2.0), SizeUnit.mm));
                capacitor.setControlPoint(point1, 0);
                capacitor.setControlPoint(point2, 1);
                component = capacitor;
            } else if (nodeName.equalsIgnoreCase("led")) {
                LOG.debug((Object)("Recognized " + nodeName));
                LED led = new LED();
                led.setName(nameAttr);
                led.setValue(valueAttr);
                led.setBodyColor(Color.red);
                led.setBorderColor(Color.red.darker());
                led.setLength(new Size(Double.valueOf(3.0), SizeUnit.mm));
                led.setControlPoint(point1, 0);
                led.setControlPoint(point2, 1);
                component = led;
            } else if (nodeName.equalsIgnoreCase("transistor")) {
                LOG.debug((Object)("Recognized " + nodeName));
                TransistorTO92 transistor = new TransistorTO92();
                transistor.setName(nameAttr);
                try {
                    transistor.setValue(valueAttr);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not set value of " + nameAttr));
                }
                transistor.setControlPoint(point1, 0);
                if (point1.y > point2.y) {
                    transistor.setOrientation(Orientation._180);
                } else if (point1.y < point2.y) {
                    transistor.setOrientation(Orientation.DEFAULT);
                } else if (point1.x < point2.x) {
                    transistor.setOrientation(Orientation._270);
                } else if (point1.x > point2.x) {
                    transistor.setOrientation(Orientation._90);
                }
                component = transistor;
            } else if (nodeName.equalsIgnoreCase("ic")) {
                LOG.debug((Object)("Recognized " + nodeName));
                ic = new DIL_IC();
                int pinCount = 8;
                int rowSpace = 3;
                if (x1Attr < x2Attr && y1Attr < y2Attr) {
                    pinCount = (y2Attr - y1Attr + 1) * 2;
                    rowSpace = x2Attr - x1Attr;
                    ic.setOrientation(Orientation.DEFAULT);
                } else if (x1Attr > x2Attr && y1Attr < y2Attr) {
                    pinCount = (x1Attr - x2Attr + 1) * 2;
                    rowSpace = y2Attr - y1Attr;
                    ic.setOrientation(Orientation._90);
                } else if (x1Attr > x2Attr && y1Attr > y2Attr) {
                    rowSpace = x1Attr - x2Attr;
                    pinCount = (y1Attr - y2Attr + 1) * 2;
                    ic.setOrientation(Orientation._180);
                } else if (x1Attr < x2Attr && y1Attr > y2Attr) {
                    rowSpace = y1Attr - y2Attr;
                    pinCount = (x2Attr - x1Attr + 1) * 2;
                    ic.setOrientation(Orientation._270);
                }
                ic.setRowSpacing(new Size(Double.valueOf(0.1 * (double)rowSpace), SizeUnit.in));
                ic.setPinCount(DIL_IC.PinCount.valueOf("_" + pinCount));
                ic.setName(nameAttr);
                for (int j = 0; j < ic.getControlPointCount(); ++j) {
                    Point p = new Point(ic.getControlPoint(j));
                    p.translate(point1.x, point1.y);
                    ic.setControlPoint(p, j);
                }
                ic.setValue(valueAttr);
                component = ic;
            } else if (nodeName.equalsIgnoreCase("switch")) {
                LOG.debug((Object)("Recognized " + nodeName));
                MiniToggleSwitch sw = new MiniToggleSwitch();
                int sizeX = Math.abs(x1Attr - x2Attr);
                sizeY = Math.abs(y1Attr - y2Attr);
                ToggleSwitchType switchType = null;
                OrientationHV orientation = null;
                if (Math.min(sizeX, sizeY) == 0 && Math.max(sizeX, sizeY) == 1) {
                    switchType = ToggleSwitchType.SPST;
                    OrientationHV orientationHV = orientation = sizeX < sizeY ? OrientationHV.VERTICAL : OrientationHV.HORIZONTAL;
                }
                if (Math.min(sizeX, sizeY) == 0 && Math.max(sizeX, sizeY) == 2) {
                    switchType = ToggleSwitchType.SPDT;
                    OrientationHV orientationHV = orientation = sizeX < sizeY ? OrientationHV.VERTICAL : OrientationHV.HORIZONTAL;
                }
                if (Math.min(sizeX, sizeY) == 1 && Math.max(sizeX, sizeY) == 2) {
                    switchType = ToggleSwitchType.DPDT;
                    OrientationHV orientationHV = orientation = sizeX < sizeY ? OrientationHV.VERTICAL : OrientationHV.HORIZONTAL;
                }
                if (Math.min(sizeX, sizeY) == 2 && Math.max(sizeX, sizeY) == 2) {
                    switchType = ToggleSwitchType._3PDT;
                    orientation = OrientationHV.VERTICAL;
                }
                if (Math.min(sizeX, sizeY) == 2 && Math.max(sizeX, sizeY) == 3) {
                    switchType = ToggleSwitchType._4PDT;
                    OrientationHV orientationHV = orientation = sizeX < sizeY ? OrientationHV.HORIZONTAL : OrientationHV.VERTICAL;
                }
                if (Math.min(sizeX, sizeY) == 2 && Math.max(sizeX, sizeY) == 4) {
                    switchType = ToggleSwitchType._5PDT;
                    OrientationHV orientationHV = orientation = sizeX < sizeY ? OrientationHV.HORIZONTAL : OrientationHV.HORIZONTAL;
                }
                if (switchType == null || orientation == null) {
                    String message = "Unsupported toggle switch dimensions";
                    LOG.debug((Object)message);
                    if (!warnings.contains(message)) {
                        warnings.add(message);
                    }
                } else {
                    int j;
                    sw.setName(nameAttr);
                    sw.setOrientation(orientation);
                    sw.setValue(switchType);
                    sw.setSpacing(new Size(Double.valueOf(0.1), SizeUnit.in));
                    dx = 0;
                    dy = 0;
                    for (j = 0; j < sw.getControlPointCount(); ++j) {
                        Point p = new Point(sw.getControlPoint(j));
                        if (p.x < 0 && p.x < dx) {
                            dx = p.x;
                        }
                        if (p.y >= 0 || p.y >= dy) continue;
                        dy = p.y;
                    }
                    for (j = 0; j < sw.getControlPointCount(); ++j) {
                        Point p = new Point(sw.getControlPoint(j));
                        p.translate(Math.min(point1.x, point2.x) - dx, Math.min(point1.y, point2.y) - dy);
                        sw.setControlPoint(p, j);
                    }
                    component = sw;
                }
            } else if (nodeName.equalsIgnoreCase("lineic")) {
                LOG.debug((Object)("Recognized " + nodeName));
                ic = new SIL_IC();
                int pinCount = 8;
                if (x1Attr == x2Attr && y1Attr < y2Attr) {
                    pinCount = y2Attr - y1Attr + 1;
                    ic.setOrientation(Orientation.DEFAULT);
                } else if (x1Attr > x2Attr && y1Attr == y2Attr) {
                    pinCount = x1Attr - x2Attr + 1;
                    ic.setOrientation(Orientation._90);
                } else if (x1Attr == x2Attr && y1Attr > y2Attr) {
                    pinCount = y1Attr - y2Attr + 1;
                    ic.setOrientation(Orientation._180);
                } else if (x1Attr < x2Attr && y1Attr == y2Attr) {
                    pinCount = x2Attr - x1Attr + 1;
                    ic.setOrientation(Orientation._270);
                }
                ic.setPinCount(SIL_IC.PinCount.valueOf("_" + pinCount));
                ic.setName(nameAttr);
                for (int j = 0; j < ic.getControlPointCount(); ++j) {
                    Point p = new Point(ic.getControlPoint(j));
                    p.translate(point1.x, point1.y);
                    ic.setControlPoint(p, j);
                }
                ic.setValue(valueAttr);
                component = ic;
            } else if (nodeName.equalsIgnoreCase("pot")) {
                LOG.debug((Object)("Recognized " + nodeName));
                PotentiometerPanel pot = new PotentiometerPanel();
                pot.setBodyDiameter(new Size(Double.valueOf(14.0), SizeUnit.mm));
                pot.setSpacing(new Size(Double.valueOf(0.2), SizeUnit.in));
                pot.setName(nameAttr);
                try {
                    pot.setValue(Resistance.parseResistance((String)valueAttr));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not set value of " + nameAttr));
                }
                String taperAttr = node.getAttributes().getNamedItem("Taper").getNodeValue();
                if ("Linear".equals(taperAttr)) {
                    pot.setTaper(Taper.LIN);
                } else if ("Audio".equals(taperAttr)) {
                    pot.setTaper(Taper.LOG);
                } else if ("Reverse Audio".equals(taperAttr)) {
                    pot.setTaper(Taper.REV_LOG);
                }
                int delta = 40;
                if (x1Attr < x2Attr) {
                    pot.setOrientation(Orientation.DEFAULT);
                    for (int j = 0; j < pot.getControlPointCount(); ++j) {
                        Point p = new Point(pot.getControlPoint(j));
                        p.translate(point1.x - delta, point1.y);
                        pot.setControlPoint(p, j);
                    }
                } else if (x1Attr > x2Attr) {
                    pot.setOrientation(Orientation._180);
                    for (int j = 0; j < pot.getControlPointCount(); ++j) {
                        Point p = new Point(pot.getControlPoint(j));
                        p.translate(point1.x + delta, point1.y);
                        pot.setControlPoint(p, j);
                    }
                } else if (y1Attr < y2Attr) {
                    pot.setOrientation(Orientation._90);
                    for (int j = 0; j < pot.getControlPointCount(); ++j) {
                        Point p = new Point(pot.getControlPoint(j));
                        p.translate(point1.x, point1.y - delta);
                        pot.setControlPoint(p, j);
                    }
                } else if (y1Attr > y2Attr) {
                    pot.setOrientation(Orientation._270);
                    for (int j = 0; j < pot.getControlPointCount(); ++j) {
                        Point p = new Point(pot.getControlPoint(j));
                        p.translate(point1.x, point1.y + delta);
                        pot.setControlPoint(p, j);
                    }
                }
                component = pot;
            } else if (nodeName.equalsIgnoreCase("trimmer")) {
                LOG.debug((Object)("Recognized " + nodeName));
                TrimmerPotentiometer trimmer = new TrimmerPotentiometer();
                trimmer.setName(nameAttr);
                int sizeX = Math.abs(x1Attr - x2Attr);
                sizeY = Math.abs(y1Attr - y2Attr);
                TrimmerPotentiometer.TrimmerType trimmerType = null;
                Orientation orientation = null;
                dx = 0;
                dy = 0;
                if (Math.min(sizeX, sizeY) == 0 && Math.max(sizeX, sizeY) == 1) {
                    trimmerType = TrimmerPotentiometer.TrimmerType.VERTICAL_INLINE;
                    if (y1Attr > y2Attr) {
                        orientation = Orientation.DEFAULT;
                        dy = -1;
                    } else if (x1Attr > x2Attr) {
                        orientation = Orientation._90;
                        dx = 1;
                    } else if (y1Attr < y2Attr) {
                        orientation = Orientation._180;
                        dy = 1;
                    } else if (x1Attr < x2Attr) {
                        orientation = Orientation._270;
                        dx = -1;
                    }
                } else if (Math.min(sizeX, sizeY) == 1 && Math.max(sizeX, sizeY) == 1) {
                    trimmerType = TrimmerPotentiometer.TrimmerType.VERTICAL_OFFSET;
                    if (x1Attr > x2Attr && y1Attr > y2Attr) {
                        orientation = Orientation.DEFAULT;
                        dx = -1;
                        dy = -1;
                    } else if (x1Attr < x2Attr && y1Attr > y2Attr) {
                        orientation = Orientation._90;
                        dx = 1;
                        dy = -1;
                    } else if (x1Attr < x2Attr && y1Attr < y2Attr) {
                        orientation = Orientation._180;
                        dx = 1;
                        dy = 1;
                    } else if (x1Attr > x2Attr && y1Attr < y2Attr) {
                        orientation = Orientation._270;
                        dx = -1;
                        dy = 1;
                    }
                } else if (Math.min(sizeX, sizeY) == 1 && Math.max(sizeX, sizeY) == 2) {
                    trimmerType = TrimmerPotentiometer.TrimmerType.VERTICAL_OFFSET_BIG_GAP;
                    if (x1Attr > x2Attr && y1Attr > y2Attr) {
                        if (sizeX == 2) {
                            orientation = Orientation.DEFAULT;
                            dx = -2;
                            dy = -1;
                        } else {
                            orientation = Orientation._90;
                            dx = 1;
                            dy = -2;
                        }
                    } else if (x1Attr < x2Attr && y1Attr > y2Attr) {
                        if (sizeX == 2) {
                            orientation = Orientation._180;
                            dx = 2;
                            dy = 1;
                        } else {
                            orientation = Orientation._90;
                            dx = 1;
                            dy = -2;
                        }
                    } else if (x1Attr < x2Attr && y1Attr < y2Attr) {
                        if (sizeX == 2) {
                            orientation = Orientation._180;
                            dx = 2;
                            dy = 1;
                        } else {
                            orientation = Orientation._270;
                            dx = -1;
                            dy = 2;
                        }
                    } else if (x1Attr > x2Attr && y1Attr < y2Attr) {
                        if (sizeX == 2) {
                            orientation = Orientation.DEFAULT;
                            dx = -2;
                            dy = -1;
                        } else {
                            orientation = Orientation._270;
                            dx = -1;
                            dy = 2;
                        }
                    }
                } else if (Math.min(sizeX, sizeY) == 1 && Math.max(sizeX, sizeY) == 4) {
                    trimmerType = TrimmerPotentiometer.TrimmerType.FLAT_LARGE;
                    if (x1Attr > x2Attr && y1Attr > y2Attr) {
                        if (sizeX == 4) {
                            orientation = Orientation.DEFAULT;
                            dx = -4;
                            dy = -1;
                        } else {
                            orientation = Orientation._90;
                            dx = 1;
                            dy = -4;
                        }
                    } else if (x1Attr < x2Attr && y1Attr > y2Attr) {
                        if (sizeX == 4) {
                            orientation = Orientation._180;
                            dx = 4;
                            dy = 1;
                        } else {
                            orientation = Orientation._90;
                            dx = 1;
                            dy = -4;
                        }
                    } else if (x1Attr < x2Attr && y1Attr < y2Attr) {
                        if (sizeX == 4) {
                            orientation = Orientation._180;
                            dx = 4;
                            dy = 1;
                        } else {
                            orientation = Orientation._270;
                            dx = -1;
                            dy = 4;
                        }
                    } else if (x1Attr > x2Attr && y1Attr < y2Attr) {
                        if (sizeX == 4) {
                            orientation = Orientation.DEFAULT;
                            dx = -4;
                            dy = -1;
                        } else {
                            orientation = Orientation._270;
                            dx = -1;
                            dy = 4;
                        }
                    }
                }
                if (trimmerType == null || orientation == null) {
                    String message = "Unsupported trimmer dimensions";
                    LOG.debug((Object)message);
                    if (!warnings.contains(message)) {
                        warnings.add(message);
                    }
                } else {
                    try {
                        trimmer.setValue(Resistance.parseResistance((String)valueAttr));
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Could not set value of " + nameAttr));
                    }
                    trimmer.setType(trimmerType);
                    trimmer.setOrientation(orientation);
                    dx = (int)((double)dx * V1_GRID_SPACING.convertToPixels());
                    dy = (int)((double)dy * V1_GRID_SPACING.convertToPixels());
                    for (int j = 0; j < trimmer.getControlPointCount(); ++j) {
                        Point p = new Point(trimmer.getControlPoint(j));
                        p.translate(point1.x + dx, point1.y + dy);
                        trimmer.setControlPoint(p, j);
                    }
                    component = trimmer;
                }
            } else {
                String message = "Could not recognize component type " + nodeName;
                LOG.debug((Object)message);
                if (!warnings.contains(message)) {
                    warnings.add(message);
                }
            }
            if (component == null) continue;
            if (component instanceof AbstractLeadedComponent) {
                ((AbstractLeadedComponent)((Object)component)).setDisplay(Display.NAME);
            }
            if (component instanceof AbstractTransparentComponent) {
                ((AbstractTransparentComponent)component).setAlpha(Byte.valueOf((byte)100));
            }
            project.getComponents().add(component);
        }
        int minY = y;
        for (IDIYComponent c : project.getComponents()) {
            for (int i = 0; i < c.getControlPointCount(); ++i) {
                Point p = c.getControlPoint(i);
                if (p.y >= minY) continue;
                minY = p.y;
            }
        }
        Label titleLabel = new Label();
        titleLabel.setColor(Color.blue);
        titleLabel.setFontSize(24);
        titleLabel.setValue(project.getTitle());
        titleLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        titleLabel.setControlPoint(new Point(CalcUtils.roundToGrid((double)(x + boardWidth / 2), (Size)V1_GRID_SPACING), CalcUtils.roundToGrid((double)((int)((double)minY - 200.0 * V1_GRID_SPACING.getValue() * 5.0)), (Size)V1_GRID_SPACING)), 0);
        project.getComponents().add(titleLabel);
        Label creditsLabel = new Label();
        creditsLabel.setFontSize(16);
        creditsLabel.setValue(project.getAuthor());
        creditsLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        creditsLabel.setControlPoint(new Point(CalcUtils.roundToGrid((double)(x + boardWidth / 2), (Size)V1_GRID_SPACING), CalcUtils.roundToGrid((double)((int)((double)minY - 200.0 * V1_GRID_SPACING.getValue() * 4.0)), (Size)V1_GRID_SPACING)), 0);
        project.getComponents().add(creditsLabel);
        BOM bom = new BOM();
        int bomSize = (int)bom.getSize().convertToPixels();
        bom.setControlPoint(new Point(CalcUtils.roundToGrid((double)(x + (boardWidth - bomSize) / 2), (Size)V1_GRID_SPACING), CalcUtils.roundToGrid((double)((int)((double)(y + boardHeight) + 2.0 * V1_GRID_SPACING.convertToPixels())), (Size)V1_GRID_SPACING)), 0);
        project.getComponents().add(bom);
        Collections.sort(project.getComponents(), ComparatorFactory.getInstance().getComponentZOrderComparator());
        return project;
    }

    private Point convertV1CoordinatesToV3Point(Point reference, int x, int y) {
        Point point = new Point(reference);
        point.translate((int)((double)(x * 200) * V1_GRID_SPACING.getValue()), (int)((double)(y * 200) * V1_GRID_SPACING.getValue()));
        return point;
    }

    private Color parseV1Color(String color) {
        if ("brown".equals(color.toLowerCase())) {
            return new Color(139, 69, 19);
        }
        try {
            Field field = Color.class.getDeclaredField(color.toLowerCase());
            return (Color)field.get(null);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not parse color \"" + color + "\""), (Throwable)e);
            return Color.black;
        }
    }

    private int myRandom(int range, Random r) {
        int rand = r.nextInt(range = range * 2 / 3) - range / 2;
        if (Math.abs(rand) < range / 3) {
            rand = this.myRandom(range, r);
        }
        return rand;
    }

    private int randInt(int range) {
        long newSeed;
        this.randSeed = newSeed = this.randSeed * 134775813L + 1L;
        return (int)(newSeed * (long)range >> 32);
    }

    static {
        V1_COLOR_MAP.put("red", Color.red);
        V1_COLOR_MAP.put("blue", Color.blue);
        V1_COLOR_MAP.put("white", Color.white);
        V1_COLOR_MAP.put("green", Color.green.darker());
        V1_COLOR_MAP.put("black", Color.black);
        V1_COLOR_MAP.put("yellow", Color.yellow);
    }
}

