/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.BadPositionException;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.IView;
import org.diylc.images.IconLoader;
import org.diylc.presenter.Presenter;
import org.diylc.swing.IDynamicSubmenuHandler;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.CustomGlassPane;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.gui.actionbar.ActionBarPlugin;
import org.diylc.swing.gui.editor.PropertyEditorDialog;
import org.diylc.swing.plugins.autosave.AutoSavePlugin;
import org.diylc.swing.plugins.canvas.CanvasPlugin;
import org.diylc.swing.plugins.cloud.CloudPlugIn;
import org.diylc.swing.plugins.config.ConfigPlugin;
import org.diylc.swing.plugins.edit.EditMenuPlugin;
import org.diylc.swing.plugins.file.FileFilterEnum;
import org.diylc.swing.plugins.file.FileMenuPlugin;
import org.diylc.swing.plugins.help.HelpMenuPlugin;
import org.diylc.swing.plugins.layers.LayersMenuPlugin;
import org.diylc.swing.plugins.statusbar.StatusBar;
import org.diylc.swing.plugins.toolbox.ToolBox;
import org.diylc.swing.plugins.tree.ComponentTree;

public class MainFrame
extends JFrame
implements ISwingUI {
    private static final Logger LOG = Logger.getLogger(MainFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel centerPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private Presenter presenter;
    private JMenuBar mainMenuBar;
    private Map<String, JMenu> menuMap;
    private Map<String, ButtonGroup> buttonGroupMap;
    private CanvasPlugin canvasPlugin;

    public MainFrame() {
        super("DIYLC 3");
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(1024, 700));
        this.createBasePanels();
        this.menuMap = new HashMap<String, JMenu>();
        this.buttonGroupMap = new HashMap<String, ButtonGroup>();
        this.setIconImages(Arrays.asList(IconLoader.IconSmall.getImage(), IconLoader.IconMedium.getImage(), IconLoader.IconLarge.getImage()));
        DialogFactory.getInstance().initialize(this);
        this.presenter = new Presenter((IView)this);
        this.canvasPlugin = new CanvasPlugin(this);
        this.presenter.installPlugin((IPlugIn)new ToolBox(this));
        this.presenter.installPlugin((IPlugIn)new FileMenuPlugin(this));
        this.presenter.installPlugin((IPlugIn)new EditMenuPlugin(this));
        this.presenter.installPlugin((IPlugIn)new ConfigPlugin(this));
        this.presenter.installPlugin((IPlugIn)new LayersMenuPlugin(this));
        this.presenter.installPlugin((IPlugIn)new CloudPlugIn(this));
        this.presenter.installPlugin((IPlugIn)new HelpMenuPlugin(this));
        this.presenter.installPlugin((IPlugIn)new ActionBarPlugin(this));
        this.presenter.installPlugin((IPlugIn)new StatusBar(this));
        this.presenter.installPlugin((IPlugIn)this.canvasPlugin);
        this.presenter.installPlugin((IPlugIn)new ComponentTree(this, this.canvasPlugin.getCanvasPanel()));
        this.presenter.installPlugin((IPlugIn)new FramePlugin());
        this.presenter.installPlugin((IPlugIn)new AutoSavePlugin(this));
        this.presenter.createNewProject();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (MainFrame.this.presenter.allowFileAction()) {
                    ConfigurationManager.getInstance().writeValue("abnormalExit", false);
                    MainFrame.this.dispose();
                    MainFrame.this.presenter.dispose();
                    System.exit(0);
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MainFrame.this.presenter.allowFileAction()) {
                    ConfigurationManager.getInstance().writeValue("abnormalExit", false);
                    MainFrame.this.dispose();
                    MainFrame.this.presenter.dispose();
                    System.exit(0);
                }
            }
        });
        this.setGlassPane(new CustomGlassPane());
    }

    public Presenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        Timer timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.canvasPlugin.refresh();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void createBasePanels() {
        Container container = new Container();
        container.setLayout(new BorderLayout());
        this.centerPanel = new JPanel(new BorderLayout());
        container.add((Component)this.centerPanel, "Center");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        container.add((Component)this.topPanel, "North");
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 0));
        container.add((Component)this.leftPanel, "West");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        container.add((Component)this.bottomPanel, "South");
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 0));
        container.add((Component)this.rightPanel, "East");
        this.setContentPane(container);
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new JMenuBar();
            this.setJMenuBar(this.mainMenuBar);
        }
        return this.mainMenuBar;
    }

    public void showMessage(String string, String string2, int n) {
        JOptionPane.showMessageDialog(this, string, string2, n);
    }

    public int showConfirmDialog(String string, String string2, int n, int n2) {
        return JOptionPane.showConfirmDialog(this, string, string2, n, n2);
    }

    public boolean editProperties(List<PropertyWrapper> list, Set<PropertyWrapper> set) {
        PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(list, "Edit Selection", true);
        propertyEditorDialog.setVisible(true);
        set.addAll(propertyEditorDialog.getDefaultedProperties());
        return "OK".equals(propertyEditorDialog.getSelectedButtonCaption());
    }

    private JMenu findOrCreateMenu(String string) {
        JMenu jMenu;
        if (this.menuMap.containsKey(string)) {
            jMenu = this.menuMap.get(string);
        } else {
            jMenu = new JMenu(string);
            this.menuMap.put(string, jMenu);
            this.getMainMenuBar().add(jMenu);
        }
        return jMenu;
    }

    @Override
    public void injectGUIComponent(JComponent jComponent, int n) throws BadPositionException {
        LOG.info((Object)String.format("injectGUIComponent(%s, %s)", jComponent.getClass().getName(), n));
        switch (n) {
            case 1: {
                this.topPanel.add(jComponent);
                break;
            }
            case 2: {
                this.leftPanel.add(jComponent);
                break;
            }
            case 3: {
                this.bottomPanel.add(jComponent);
                break;
            }
            case 4: {
                this.rightPanel.add(jComponent);
                break;
            }
            case 0: {
                this.centerPanel.add((Component)jComponent, "Center");
                break;
            }
            default: {
                throw new BadPositionException();
            }
        }
        this.pack();
    }

    @Override
    public void injectMenuAction(Action action, String string) {
        LOG.info((Object)String.format("injectMenuAction(%s, %s)", action == null ? "Separator" : action.getValue("Name"), string));
        JMenu jMenu = this.findOrCreateMenu(string);
        if (action == null) {
            jMenu.addSeparator();
        } else {
            Boolean bl = (Boolean)action.getValue("org.diylc.checkBoxMenuItem");
            String string2 = (String)action.getValue("org.diylc.radioButtonGroup");
            if (bl != null && bl.booleanValue()) {
                jMenu.add(new JCheckBoxMenuItem(action));
            } else if (string2 != null) {
                ButtonGroup buttonGroup;
                if (this.buttonGroupMap.containsKey(string2)) {
                    buttonGroup = this.buttonGroupMap.get(string2);
                } else {
                    buttonGroup = new ButtonGroup();
                    this.buttonGroupMap.put(string2, buttonGroup);
                }
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
            } else {
                jMenu.add(action);
            }
        }
    }

    @Override
    public void injectSubmenu(String string, Icon icon, String string2) {
        LOG.info((Object)String.format("injectSubmenu(%s, icon, %s)", string, string2));
        JMenu jMenu = this.findOrCreateMenu(string2);
        JMenu jMenu2 = new JMenu(string);
        jMenu2.setIcon(icon);
        jMenu.add(jMenu2);
        this.menuMap.put(string, jMenu2);
    }

    @Override
    public void injectMenuComponent(JComponent jComponent) {
        this.getMainMenuBar().add(jComponent);
    }

    @Override
    public void injectDynamicSubmenu(String string, Icon icon, String string2, final IDynamicSubmenuHandler iDynamicSubmenuHandler) {
        LOG.info((Object)String.format("injectDynamicSubmenu(%s, icon, %s)", string, string2));
        JMenu jMenu = this.findOrCreateMenu(string2);
        final JMenu jMenu2 = new JMenu(string);
        jMenu2.setIcon(icon);
        jMenu.add(jMenu2);
        this.menuMap.put(string, jMenu2);
        final JMenuItem jMenuItem = new JMenuItem("<empty>");
        jMenuItem.setEnabled(false);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jMenu2.removeAll();
                List<String> list = iDynamicSubmenuHandler.getAvailableItems();
                if (list == null || list.isEmpty()) {
                    jMenu2.add(jMenuItem);
                } else {
                    for (String string : list) {
                        final JMenuItem jMenuItem2 = new JMenuItem(string);
                        jMenuItem2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                iDynamicSubmenuHandler.onActionPerformed(jMenuItem2.getText());
                            }
                        });
                        jMenu2.add(jMenuItem2);
                    }
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    @Override
    public <T> void executeBackgroundTask(final ITask<T> iTask, boolean bl) {
        if (bl) {
            this.getGlassPane().setVisible(true);
        }
        SwingWorker swingWorker = new SwingWorker<T, Void>(){

            @Override
            protected T doInBackground() throws Exception {
                return iTask.doInBackground();
            }

            @Override
            protected void done() {
                try {
                    Object t = this.get();
                    iTask.complete(t);
                    MainFrame.this.getGlassPane().setVisible(false);
                }
                catch (ExecutionException executionException) {
                    MainFrame.this.getGlassPane().setVisible(false);
                    LOG.error((Object)"Background task execution failed", (Throwable)executionException);
                    iTask.failed((Exception)executionException);
                }
                catch (InterruptedException interruptedException) {
                    MainFrame.this.getGlassPane().setVisible(false);
                    LOG.error((Object)"Background task execution interrupted", (Throwable)interruptedException);
                    iTask.failed((Exception)interruptedException);
                }
            }
        };
        swingWorker.execute();
    }

    @Override
    public JFrame getOwnerFrame() {
        return this;
    }

    public File promptFileSave() {
        return DialogFactory.getInstance().showSaveDialog(this, FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
    }

    @Override
    public void bringToFocus() {
        this.requestFocus();
    }

    class FramePlugin
    implements IPlugIn {
        private IPlugInPort plugInPort;

        FramePlugin() {
        }

        public void connect(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
        }

        public EnumSet<EventType> getSubscribedEventTypes() {
            return EnumSet.of(EventType.FILE_STATUS_CHANGED);
        }

        public void processMessage(EventType eventType, Object ... objectArray) {
            if (eventType == EventType.FILE_STATUS_CHANGED) {
                String string = (String)objectArray[0];
                if (string == null) {
                    string = "Untitled";
                }
                String string2 = (Boolean)objectArray[1] != false ? " (modified)" : "";
                MainFrame.this.setTitle(String.format("DIYLC G3 version %s.%s - %s %s", this.plugInPort.getCurrentVersionNumber().getMinor(), this.plugInPort.getCurrentVersionNumber().getBuild(), string, string2));
            }
        }
    }
}

