/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.actionbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.actionbar.MiniToolbar;

public class ActionBarPlugin
implements IPlugIn {
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;
    private JPanel actionPanel;
    private MiniToolbar miniToolbar;

    public ActionBarPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
    }

    public JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel();
            this.actionPanel.setOpaque(false);
            this.actionPanel.setLayout(new BorderLayout());
            this.actionPanel.add((Component)this.getMiniToolbar(), "East");
            this.actionPanel.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.actionPanel;
    }

    public MiniToolbar getMiniToolbar() {
        if (this.miniToolbar == null) {
            this.miniToolbar = new MiniToolbar();
            this.miniToolbar.add(ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, 1));
            this.miniToolbar.add(ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, -1));
            this.miniToolbar.addSpacer();
            this.miniToolbar.add(ActionFactory.getInstance().createMirrorSelectionAction(this.plugInPort, 0));
            this.miniToolbar.add(ActionFactory.getInstance().createMirrorSelectionAction(this.plugInPort, 1));
            this.miniToolbar.addSpacer();
            this.miniToolbar.add(ActionFactory.getInstance().createNudgeAction(this.plugInPort));
            this.miniToolbar.addSpacer();
            this.miniToolbar.add(ActionFactory.getInstance().createSendToBackAction(this.plugInPort));
            this.miniToolbar.add(ActionFactory.getInstance().createBringToFrontAction(this.plugInPort));
            this.miniToolbar.addSpacer();
            this.miniToolbar.add(ActionFactory.getInstance().createGroupAction(this.plugInPort));
            this.miniToolbar.add(ActionFactory.getInstance().createUngroupAction(this.plugInPort));
        }
        return this.miniToolbar;
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.swingUI.injectMenuComponent(this.getActionPanel());
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.SELECTION_CHANGED);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        if (eventType != EventType.SELECTION_CHANGED) {
            return;
        }
        boolean bl = !this.plugInPort.getSelectedComponents().isEmpty();
        this.getMiniToolbar().setEnabled(bl);
    }
}

