/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.diylc.images.IconLoader;

public class SearchHeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField searchField;
    private JComboBox categoryBox;
    private JComboBox sortBox;
    private JButton goButton;
    private boolean initialized = false;

    public SearchHeaderPanel() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel("Search For:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getSearchField(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel("Filter By Category:"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.getCategoryBox(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel("Sort By:"), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        this.add((Component)this.getSortBox(), gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.getGoButton(), gridBagConstraints);
    }

    public void setFocus() {
        this.getSearchField().requestFocusInWindow();
    }

    public void initializeLists(String[] stringArray, String[] stringArray2) {
        this.getCategoryBox().setModel(new DefaultComboBoxModel<String>(stringArray));
        this.getSortBox().setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private JTextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = new JTextField(60);
        }
        return this.searchField;
    }

    private JComboBox getCategoryBox() {
        if (this.categoryBox == null) {
            this.categoryBox = new JComboBox();
        }
        return this.categoryBox;
    }

    private JComboBox getSortBox() {
        if (this.sortBox == null) {
            this.sortBox = new JComboBox();
        }
        return this.sortBox;
    }

    public JButton getGoButton() {
        if (this.goButton == null) {
            this.goButton = new JButton("Go", IconLoader.DataFind.getIcon());
        }
        return this.goButton;
    }

    public String getSearchText() {
        return this.getSearchField().getText();
    }

    public String getCategory() {
        return this.getCategoryBox().getSelectedItem() == null ? "" : this.getCategoryBox().getSelectedItem().toString();
    }

    public String getSorting() {
        return this.getSortBox().getSelectedItem() == null ? "" : this.getSortBox().getSelectedItem().toString();
    }
}

