/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.core.measures;

import java.awt.Color;
import org.diylc.common.ResistorColorCode;
import org.diylc.core.measures.AbstractMeasure;
import org.diylc.core.measures.ResistanceUnit;

public class Resistance
extends AbstractMeasure<ResistanceUnit> {
    private static final long serialVersionUID = 1L;
    private static final Color[] COLOR_DIGITS = new Color[]{Color.black, Color.decode("#8B4513"), Color.red, Color.orange, Color.yellow, Color.decode("#76EE00"), Color.blue, Color.decode("#91219E"), Color.lightGray, Color.white};
    private static final Color[] COLOR_MULTIPLIER = new Color[]{Color.lightGray.brighter(), Color.decode("#FFB90F"), Color.black, Color.decode("#8B4513"), Color.red, Color.orange, Color.yellow, Color.decode("#76EE00"), Color.blue};

    public Resistance(Double d, ResistanceUnit resistanceUnit) {
        super(d, resistanceUnit);
    }

    public Resistance clone() throws CloneNotSupportedException {
        return new Resistance(this.value, (ResistanceUnit)this.unit);
    }

    public Color[] getColorCode(ResistorColorCode resistorColorCode) {
        Color[] colorArray;
        if (this.getValue() == 0.0) {
            switch (resistorColorCode) {
                case _4_BAND: {
                    colorArray = new Color[]{COLOR_DIGITS[0], COLOR_DIGITS[0], COLOR_MULTIPLIER[2]};
                    break;
                }
                case _5_BAND: {
                    colorArray = new Color[]{COLOR_DIGITS[0], COLOR_DIGITS[0], COLOR_DIGITS[0], COLOR_MULTIPLIER[2]};
                    break;
                }
                default: {
                    colorArray = new Color[]{};
                    break;
                }
            }
        } else {
            if (this.getValue() == null || this.getUnit() == null) {
                return new Color[0];
            }
            double d = this.getValue() * ((ResistanceUnit)this.getUnit()).getFactor();
            int n = 0;
            while (true) {
                int n2 = resistorColorCode == ResistorColorCode._4_BAND ? 99 : 999;
                if (!(d > (double)n2)) break;
                ++n;
                d /= 10.0;
            }
            while (true) {
                int n3 = resistorColorCode == ResistorColorCode._4_BAND ? 10 : 100;
                if (!(d < (double)n3)) break;
                --n;
                d *= 10.0;
            }
            if (n > 6 || n < -2) {
                return new Color[0];
            }
            switch (resistorColorCode) {
                case _4_BAND: {
                    colorArray = new Color[]{COLOR_DIGITS[(int)(d / 10.0)], COLOR_DIGITS[(int)(d % 10.0)], COLOR_MULTIPLIER[n + 2]};
                    break;
                }
                case _5_BAND: {
                    colorArray = new Color[]{COLOR_DIGITS[(int)(d / 100.0)], COLOR_DIGITS[(int)(d / 10.0 % 10.0)], COLOR_DIGITS[(int)(d % 10.0)], COLOR_MULTIPLIER[n + 2]};
                    break;
                }
                default: {
                    colorArray = new Color[]{};
                }
            }
        }
        return colorArray;
    }

    public static Resistance parseResistance(String string) {
        string = string.replace("*", "").replace("R", "\u2126");
        for (ResistanceUnit resistanceUnit : ResistanceUnit.values()) {
            if (!string.toLowerCase().endsWith(resistanceUnit.toString().toLowerCase())) continue;
            string = string.substring(0, string.length() - resistanceUnit.toString().length()).trim();
            return new Resistance((Double)Resistance.parse(string), resistanceUnit);
        }
        throw new IllegalArgumentException("Could not parse resistance: " + string);
    }
}

