/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.appframework.simplemq.MessageDispatcher;
import org.diylc.appframework.update.VersionNumber;
import org.diylc.common.EventType;
import org.diylc.core.Project;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Current;
import org.diylc.core.measures.Inductance;
import org.diylc.core.measures.Power;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.Voltage;
import org.diylc.parsing.IOldFileParser;
import org.diylc.presenter.ColorConverter;
import org.diylc.presenter.FontConverter;
import org.diylc.presenter.MeasureConverter;
import org.diylc.presenter.PointConverter;
import org.diylc.presenter.Presenter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProjectFileManager {
    private static final Logger LOG = Logger.getLogger(ProjectFileManager.class);
    private XStream xStream;
    private XStream xStreamOld;
    private String currentFileName = null;
    private boolean modified = false;
    private MessageDispatcher<EventType> messageDispatcher;
    private List<IOldFileParser> parsers;
    private Set<String> missingFields = new HashSet<String>();

    public ProjectFileManager(MessageDispatcher<EventType> messageDispatcher) {
        this.xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8")){

            protected MapperWrapper wrapMapper(MapperWrapper mapperWrapper) {
                return new MapperWrapper((Mapper)mapperWrapper){

                    public boolean shouldSerializeMember(Class clazz, String string) {
                        if (clazz == Object.class) {
                            ProjectFileManager.this.missingFields.add(clazz.getName() + "." + string);
                            return false;
                        }
                        return super.shouldSerializeMember(clazz, string);
                    }
                };
            }
        };
        this.xStream.autodetectAnnotations(true);
        this.xStream.alias("point", Point.class);
        this.xStream.alias("font", Font.class);
        this.xStream.alias("project", Project.class);
        this.xStream.aliasPackage("diylc", "org.diylc.components");
        this.xStream.registerConverter((Converter)new PointConverter());
        this.xStream.registerConverter((Converter)new ColorConverter());
        this.xStream.registerConverter((Converter)new FontConverter());
        this.xStream.registerConverter((Converter)new MeasureConverter());
        this.xStream.addImmutableType(Color.class);
        this.xStream.addImmutableType(Point.class);
        this.xStream.addImmutableType(Voltage.class);
        this.xStream.addImmutableType(Resistance.class);
        this.xStream.addImmutableType(Capacitance.class);
        this.xStream.addImmutableType(Current.class);
        this.xStream.addImmutableType(Power.class);
        this.xStream.addImmutableType(Inductance.class);
        this.xStream.addImmutableType(Size.class);
        this.xStreamOld = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.xStreamOld.autodetectAnnotations(true);
        this.messageDispatcher = messageDispatcher;
    }

    public void startNewFile() {
        this.currentFileName = null;
        this.modified = false;
        this.fireFileStatusChanged();
    }

    public List<IOldFileParser> getParsers() {
        if (this.parsers == null) {
            this.parsers = new ArrayList<IOldFileParser>();
            Set set = null;
            try {
                set = Utils.getClasses((String)"org.diylc.parsing");
                for (Class clazz : set) {
                    if (Modifier.isAbstract(clazz.getModifiers()) || !IOldFileParser.class.isAssignableFrom(clazz)) continue;
                    IOldFileParser iOldFileParser = (IOldFileParser)clazz.newInstance();
                    this.parsers.add(iOldFileParser);
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Could not find old version parsers", (Throwable)exception);
            }
        }
        return this.parsers;
    }

    public synchronized void serializeProjectToFile(Project project, String string, boolean bl) throws IOException {
        if (!bl) {
            LOG.info((Object)String.format("saveProjectToFile(%s)", string));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.xStream.toXML((Object)project, (Writer)outputStreamWriter);
        fileOutputStream.close();
        if (!bl) {
            this.currentFileName = string;
            this.modified = false;
            this.fireFileStatusChanged();
        }
    }

    public Project deserializeProjectFromFile(String string, List<String> list) throws SAXException, IOException, ParserConfigurationException {
        LOG.info((Object)String.format("loadProjectFromFile(%s)", string));
        Project project = null;
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new InputStreamReader(new FileInputStream(file))));
        document.getDocumentElement().normalize();
        if (document.getDocumentElement().getNodeName().equals(Project.class.getName()) || document.getDocumentElement().getNodeName().equals("project")) {
            project = this.parseV3File(string, list);
        } else {
            if (!document.getDocumentElement().getNodeName().equalsIgnoreCase("layout")) {
                throw new IllegalArgumentException("Could not open DIY file. Root node is not named 'Layout'.");
            }
            String string2 = document.getDocumentElement().getAttribute("formatVersion");
            List<IOldFileParser> list2 = this.getParsers();
            for (int i = 0; i < list2.size(); ++i) {
                if (!list2.get(i).canParse(string2)) continue;
                project = list2.get(i).parseFile(document.getDocumentElement(), list);
            }
            if (project == null) {
                throw new IllegalArgumentException("Unknown file format version: " + string2);
            }
        }
        Collections.sort(list);
        this.currentFileName = string;
        this.modified = false;
        return project;
    }

    public void notifyFileChange() {
        this.modified = true;
        this.fireFileStatusChanged();
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void fireFileStatusChanged() {
        this.messageDispatcher.dispatchMessage((Enum)EventType.FILE_STATUS_CHANGED, new Object[]{this.getCurrentFileName(), this.isModified()});
    }

    private Project parseV3File(String string, List<String> list) throws IOException {
        Project project;
        try {
            VersionNumber versionNumber = this.readV3Version(string);
            if (versionNumber.compareTo(Presenter.CURRENT_VERSION) > 0) {
                list.add("The file is created with a newer version of DIYLC and may contain features that are not supported by your version of DIYLC. Please update.");
            }
        }
        catch (Exception exception) {
            list.add("Could not read file version number, the file may be corrupted.");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        this.missingFields.clear();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            project = (Project)this.xStream.fromXML((Reader)inputStreamReader);
        }
        catch (Exception exception) {
            LOG.warn((Object)"Could not open with the new xStream, trying the old one", (Throwable)exception);
            fileInputStream.close();
            fileInputStream = new FileInputStream(string);
            project = (Project)this.xStreamOld.fromXML((InputStream)fileInputStream);
        }
        if (!this.missingFields.isEmpty()) {
            list.add("The project references unknown component properties, most likely because it was created with a newer version of DIYLC.");
        }
        fileInputStream.close();
        return project;
    }

    private VersionNumber readV3Version(String string) throws Exception {
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("fileVersion");
        int n = nodeList.getLength();
        if (n != 1) {
            throw new Exception("File version information could not be read from the XML.");
        }
        Node node = nodeList.item(0);
        Node node2 = node.getFirstChild().getNextSibling();
        int n2 = Integer.parseInt(node2.getFirstChild().getNodeValue());
        node2 = node2.getNextSibling().getNextSibling();
        int n3 = Integer.parseInt(node2.getFirstChild().getNodeValue());
        node2 = node2.getNextSibling().getNextSibling();
        int n4 = Integer.parseInt(node2.getFirstChild().getNodeValue());
        return new VersionNumber(n2, n3, n4);
    }
}

