/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class ButtonDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    private JPanel containerPanel;
    private JPanel buttonPanel;
    private String[] buttonCaptions;
    private Map<String, JButton> buttonMap;
    private String selectedButtonCaption;
    private static final KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
    public static final String dispatchWindowClosingActionMapKey = "org.diylc.swingframework.dispatch:WINDOW_CLOSING";

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, dispatchWindowClosingActionMapKey);
        root.getActionMap().put(dispatchWindowClosingActionMapKey, dispatchClosing);
    }

    public ButtonDialog(JFrame owner, String title, String[] buttonCaptions) {
        super((Frame)owner, title);
        this.setModal(true);
        this.setResizable(false);
        this.buttonCaptions = buttonCaptions;
        this.buttonMap = new HashMap<String, JButton>();
    }

    protected void layoutGui() {
        this.setContentPane(this.getContainerPanel());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public JButton getButton(String caption) {
        return this.buttonMap.get(caption);
    }

    public String getSelectedButtonCaption() {
        return this.selectedButtonCaption;
    }

    private JPanel getContainerPanel() {
        if (this.containerPanel == null) {
            this.containerPanel = new JPanel(new BorderLayout());
            this.containerPanel.add((Component)this.getMainComponent(), "Center");
            this.containerPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.containerPanel;
    }

    public JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String[] arr$ = this.buttonCaptions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String caption;
                final String command = caption = arr$[i$];
                JButton button = new JButton(caption);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ButtonDialog.this.validateInput(command)) {
                            ButtonDialog.this.selectedButtonCaption = command;
                            ButtonDialog.this.setVisible(false);
                        }
                    }
                });
                this.buttonPanel.add(button);
                this.buttonMap.put(command, button);
            }
            if (!this.buttonMap.isEmpty()) {
                this.getRootPane().setDefaultButton(this.buttonMap.get(this.buttonCaptions[0]));
            }
        }
        return this.buttonPanel;
    }

    protected abstract JComponent getMainComponent();

    protected boolean validateInput(String button) {
        return true;
    }
}

