/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.openide;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static int operatingSystem = -1;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static Reference<NamesAndValues> namesAndValues;
    private static Method fileToPath;
    private static Method pathToUri;
    private static Method pathsGet;
    private static Method pathToFile;

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 8192 : ("Windows Vista".equals(osName) ? 262144 : (osName.startsWith("Windows ") ? 32768 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 2048 : ("OpenVMS".equals(osName) ? 16384 : (osName.equals("Mac OS X") ? 4096 : (osName.startsWith("Darwin") ? 4096 : (osName.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : ("OpenBSD".equals(osName) ? 0x100000 : (File.pathSeparatorChar == ':' ? 524288 : 65536))))))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0x4A007) != 0;
    }

    public static boolean isMac() {
        return (Utilities.getOperatingSystem() & 0x1000) != 0;
    }

    public static boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0x1A13F8) != 0;
    }

    static void resetOperatingSystem() {
        operatingSystem = -1;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        return SourceVersion.isIdentifier(id) && !SourceVersion.isKeyword(id);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ie) {
            throw ie;
        }
        catch (Error e) {
            throw e;
        }
        if (Component.class.isAssignableFrom(clazz)) {
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!pds[i].getName().equals("cursor")) continue;
                try {
                    Method getter = Component.class.getDeclaredMethod("getCursor", new Class[0]);
                    Method setter = Component.class.getDeclaredMethod("setCursor", Cursor.class);
                    pds[i] = new PropertyDescriptor("cursor", getter, setter);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        if (bi != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return bi;
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, stopClass);
    }

    public static String pureClassName(String fullName) {
        int index = fullName.indexOf(36);
        if (index >= 0 && index < fullName.length()) {
            return fullName.substring(index + 1, fullName.length());
        }
        return fullName;
    }

    @Deprecated
    public static boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    @Deprecated
    public static int arrayHashCode(Object[] arr) {
        int c = 0;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            Object o = arr[i];
            int v = o == null ? 1 : o.hashCode();
            c += v ^ i;
        }
        return c;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        return Utilities.compareObjectsImpl(o1, o2, 1);
    }

    public static boolean compareObjectsImpl(Object o1, Object o2, int checkArraysDepth) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (checkArraysDepth > 0) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                Object[] o1a = (Object[])o1;
                int l1 = o1a.length;
                Object[] o2a = (Object[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (Utilities.compareObjectsImpl(o1a[i], o2a[i], checkArraysDepth - 1)) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                byte[] o1a = (byte[])o1;
                int l1 = o1a.length;
                byte[] o2a = (byte[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                short[] o1a = (short[])o1;
                int l1 = o1a.length;
                short[] o2a = (short[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                int[] o1a = (int[])o1;
                int l1 = o1a.length;
                int[] o2a = (int[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                long[] o1a = (long[])o1;
                int l1 = o1a.length;
                long[] o2a = (long[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                float[] o1a = (float[])o1;
                int l1 = o1a.length;
                float[] o2a = (float[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                double[] o1a = (double[])o1;
                int l1 = o1a.length;
                double[] o2a = (double[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                char[] o1a = (char[])o1;
                int l1 = o1a.length;
                char[] o2a = (char[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                boolean[] o1a = (boolean[])o1;
                int l1 = o1a.length;
                boolean[] o2a = (boolean[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return o1.equals(o2);
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return Utilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return Utilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String name = clazz.getName().replace('$', '.');
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public static Object[] toObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            int k = ((int[])array).length;
            Object[] r = new Integer[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((int[])array)[i];
            }
            return r;
        }
        if (array instanceof boolean[]) {
            int k = ((boolean[])array).length;
            Object[] r = new Boolean[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((boolean[])array)[i];
            }
            return r;
        }
        if (array instanceof byte[]) {
            int k = ((byte[])array).length;
            Object[] r = new Byte[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((byte[])array)[i];
            }
            return r;
        }
        if (array instanceof char[]) {
            int k = ((char[])array).length;
            Object[] r = new Character[k];
            for (int i = 0; i < k; ++i) {
                r[i] = Character.valueOf(((char[])array)[i]);
            }
            return r;
        }
        if (array instanceof double[]) {
            int k = ((double[])array).length;
            Object[] r = new Double[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((double[])array)[i];
            }
            return r;
        }
        if (array instanceof float[]) {
            int k = ((float[])array).length;
            Object[] r = new Float[k];
            for (int i = 0; i < k; ++i) {
                r[i] = Float.valueOf(((float[])array)[i]);
            }
            return r;
        }
        if (array instanceof long[]) {
            int k = ((long[])array).length;
            Object[] r = new Long[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((long[])array)[i];
            }
            return r;
        }
        if (array instanceof short[]) {
            int k = ((short[])array).length;
            Object[] r = new Short[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((short[])array)[i];
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getObjectType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getPrimitiveType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static Component getFocusTraversableComponent(Component c) {
        if (c.isFocusable()) {
            return c;
        }
        if (!(c instanceof Container)) {
            return null;
        }
        int k = ((Container)c).getComponentCount();
        for (int i = 0; i < k; ++i) {
            Component v = ((Container)c).getComponent(i);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuilder buff = new StringBuilder(20);
        int slength = s.length();
        for (int i = 0; i < slength; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (state == NULL) {
                    if (buff.length() <= 0) continue;
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                if (state == STICK) {
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\\');
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    state = INPARAM;
                    buff.append('\\');
                    buff.append(c);
                    continue;
                }
                buff.append(c);
                continue;
            }
            if (c == '\\') {
                if (state == NULL) {
                    if (++i < slength) {
                        char cc = s.charAt(i);
                        if (cc == '\"' || cc == '\\') {
                            buff.append(cc);
                            continue;
                        }
                        if (Character.isWhitespace(cc)) {
                            buff.append(c);
                            --i;
                            continue;
                        }
                        buff.append(c);
                        buff.append(cc);
                        continue;
                    }
                    buff.append('\\');
                    break;
                }
                if (state == INPARAM) {
                    state = INPARAMPENDING;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                    continue;
                }
                if (state == STICK) {
                    state = STICKPENDING;
                    continue;
                }
                if (state != STICKPENDING) continue;
                buff.append('\\');
                state = STICK;
                continue;
            }
            if (c == '\"') {
                if (state == NULL) {
                    state = INPARAM;
                    continue;
                }
                if (state == INPARAM) {
                    state = STICK;
                    continue;
                }
                if (state == STICK) {
                    state = INPARAM;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\"');
                    state = STICK;
                    continue;
                }
                buff.append('\"');
                state = INPARAM;
                continue;
            }
            if (state == INPARAMPENDING) {
                buff.append('\\');
                state = INPARAM;
            } else if (state == STICKPENDING) {
                buff.append('\\');
                state = STICK;
            }
            buff.append(c);
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            Utilities.escapeString(params[i], sb);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    private static void escapeString(String s, StringBuffer sb) {
        if (s.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                hasSpace = true;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                sb.append('\\').append('\"');
                continue;
            }
            sb.append(c);
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    private static synchronized NamesAndValues initNameAndValues() {
        NamesAndValues nav;
        if (namesAndValues != null && (nav = namesAndValues.get()) != null) {
            return nav;
        }
        Field[] fields = KeyEvent.class.getDeclaredFields();
        HashMap<String, Integer> names = new HashMap<String, Integer>(fields.length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> values = new HashMap<Integer, String>(fields.length * 4 / 3 + 5, 0.75f);
        for (Field f : fields) {
            String name;
            if (!Modifier.isStatic(f.getModifiers()) || !(name = f.getName()).startsWith("VK_")) continue;
            name = name.substring(3);
            try {
                int numb = f.getInt(null);
                names.put(name, numb);
                values.put(numb, name);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        if (names.get("CONTEXT_MENU") == null) {
            names.put("CONTEXT_MENU", 524);
            values.put(524, "CONTEXT_MENU");
            names.put("WINDOWS", 525);
            values.put(525, "WINDOWS");
        }
        names.put("MOUSE_WHEEL_UP", 656);
        names.put("MOUSE_WHEEL_DOWN", 657);
        values.put(656, "MOUSE_WHEEL_UP");
        values.put(657, "MOUSE_WHEEL_DOWN");
        NamesAndValues nav2 = new NamesAndValues(values, names);
        namesAndValues = new SoftReference<NamesAndValues>(nav2);
        return nav2;
    }

    public static String keyToString(KeyStroke stroke) {
        StringBuilder sb = new StringBuilder();
        if (Utilities.addModifiers(sb, stroke.getModifiers())) {
            sb.append('-');
        }
        Utilities.appendRest(sb, stroke);
        return sb.toString();
    }

    private static void appendRest(StringBuilder sb, KeyStroke stroke) {
        String c = Utilities.initNameAndValues().keyToString.get(stroke.getKeyCode());
        if (c == null) {
            sb.append(stroke.getKeyChar());
        } else {
            sb.append(c);
        }
    }

    public static String keyToString(KeyStroke stroke, boolean portable) {
        if (portable) {
            StringBuilder sb = new StringBuilder();
            if (Utilities.addModifiersPortable(sb, stroke.getModifiers())) {
                sb.append('-');
            }
            Utilities.appendRest(sb, stroke);
            return sb.toString();
        }
        return Utilities.keyToString(stroke);
    }

    private static boolean addModifiers(StringBuilder buf, int modif) {
        boolean b = false;
        if ((modif & 2) != 0) {
            buf.append("C");
            b = true;
        }
        if ((modif & 8) != 0) {
            buf.append("A");
            b = true;
        }
        if ((modif & 1) != 0) {
            buf.append("S");
            b = true;
        }
        if ((modif & 4) != 0) {
            buf.append("M");
            b = true;
        }
        if ((modif & 0x8000) != 0) {
            buf.append("D");
            b = true;
        }
        if ((modif & 0x10000) != 0) {
            buf.append("O");
            b = true;
        }
        return b;
    }

    private static boolean addModifiersPortable(StringBuilder buf, int modifiers) {
        boolean b = false;
        if ((modifiers & 1) != 0) {
            buf.append('S');
            b = true;
        }
        if (Utilities.isMac() && (modifiers & 4) != 0 || !Utilities.isMac() && (modifiers & 2) != 0) {
            buf.append('D');
            b = true;
        }
        if (Utilities.isMac() && (modifiers & 2) != 0 || !Utilities.isMac() && (modifiers & 8) != 0) {
            buf.append('O');
            b = true;
        }
        if (Utilities.isMac() && (modifiers & 8) != 0) {
            buf.append('A');
            b = true;
        }
        return b;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window w;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && (w = SwingUtilities.getWindowAncestor(focusOwner)) != null) {
            return w.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = new Rectangle(gconf.getBounds());
        String str = System.getProperty("netbeans.screen.insets");
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ", ");
            if (st.countTokens() == 4) {
                try {
                    bounds.y = Integer.parseInt(st.nextToken());
                    bounds.x = Integer.parseInt(st.nextToken());
                    bounds.height -= bounds.y + Integer.parseInt(st.nextToken());
                    bounds.width -= bounds.x + Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            return bounds;
        }
        str = System.getProperty("netbeans.taskbar.height");
        if (str != null) {
            bounds.height -= Integer.getInteger(str, 0).intValue();
            return bounds;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        return bounds;
    }

    public static Rectangle findCenterBounds(Dimension componentSize) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), componentSize);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration gconf, Dimension componentSize) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = gconf.getBounds();
        return new Rectangle(bounds.x + (bounds.width - componentSize.width) / 2, bounds.y + (bounds.height - componentSize.height) / 2, componentSize.width, componentSize.height);
    }

    public static URI toURI(File f) {
        String path;
        if (fileToPath != null) {
            try {
                URI u = (URI)pathToUri.invoke(fileToPath.invoke((Object)f, new Object[0]), new Object[0]);
                if (u.toString().startsWith("file:///")) {
                    // empty if block
                }
                return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), u.getQuery(), u.getFragment());
            }
            catch (Exception x) {
                LOG.log(Level.FINE, "could not convert " + f + " to URI", x);
            }
        }
        if ((path = f.getAbsolutePath()).startsWith("\\\\")) {
            if (!path.endsWith("\\") && f.isDirectory()) {
                path = path + "\\";
            }
            try {
                return new URI("file", null, path.replace('\\', '/'), null);
            }
            catch (URISyntaxException x) {
                LOG.log(Level.FINE, "could not convert " + f + " to URI", x);
            }
        }
        return f.toURI();
    }

    public static File toFile(URI u) throws IllegalArgumentException {
        String host;
        if (pathsGet != null) {
            try {
                return (File)pathToFile.invoke(pathsGet.invoke(null, u), new Object[0]);
            }
            catch (Exception x) {
                LOG.log(Level.FINE, "could not convert " + u + " to File", x);
            }
        }
        if ((host = u.getHost()) != null && !host.isEmpty() && "file".equals(u.getScheme())) {
            return new File("\\\\" + host + u.getPath().replace('/', '\\'));
        }
        return new File(u);
    }

    static {
        try {
            fileToPath = File.class.getMethod("toPath", new Class[0]);
        }
        catch (NoSuchMethodException x) {
            // empty catch block
        }
        if (fileToPath != null) {
            try {
                Class<?> path = Class.forName("java.nio.file.Path");
                pathToUri = path.getMethod("toUri", new Class[0]);
                pathsGet = Class.forName("java.nio.file.Paths").getMethod("get", URI.class);
                pathToFile = path.getMethod("toFile", new Class[0]);
            }
            catch (Exception x) {
                throw new ExceptionInInitializerError(x);
            }
        }
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }

    private static final class NamesAndValues {
        final Map<Integer, String> keyToString;
        final Map<String, Integer> stringToKey;

        NamesAndValues(Map<Integer, String> keyToString, Map<String, Integer> stringToKey) {
            this.keyToString = keyToString;
            this.stringToKey = stringToKey;
        }
    }
}

