/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.model.DrawingModel;
import export.ExportGraphic;
import globals.Globals;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import layers.LayerDesc;
import layers.StandardLayers;
import primitives.GraphicPrimitive;
import primitives.MacroDesc;
import primitives.PrimitiveAdvText;
import primitives.PrimitiveBezier;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitiveConnection;
import primitives.PrimitiveLine;
import primitives.PrimitiveMacro;
import primitives.PrimitiveOval;
import primitives.PrimitivePCBLine;
import primitives.PrimitivePCBPad;
import primitives.PrimitivePolygon;
import primitives.PrimitiveRectangle;

public class ParserActions {
    private final DrawingModel P;
    static final int MAX_TOKENS = 512;
    static final boolean useWindowsLineFeed = false;
    public String openFileName;

    public ParserActions(DrawingModel pp) {
        this.P = pp;
    }

    public void parseString(StringBuffer s) {
        this.P.getPrimitiveVector().clear();
        this.addString(s, false);
        this.P.setChanged(true);
    }

    public StringBuffer splitMacros(StringBuffer s, boolean splitStandardMacros) {
        StringBuffer txt = new StringBuffer("");
        DrawingModel Q = new DrawingModel();
        Q.setLibrary(this.P.getLibrary());
        Q.setLayers(this.P.getLayers());
        try {
            ParserActions pas = new ParserActions(Q);
            pas.parseString(s);
            File temp = File.createTempFile("copy", ".fcd");
            temp.deleteOnExit();
            String frm = "";
            frm = splitStandardMacros ? "fcda" : "fcd";
            ExportGraphic.export(temp, Q, frm, 1.0, true, false, true, false);
            FileInputStream input = new FileInputStream(temp);
            BufferedReader bufRead = new BufferedReader(new InputStreamReader((InputStream)input, "UTF8"));
            String line = "";
            txt = new StringBuffer(bufRead.readLine());
            txt.append("\n");
            while (line != null && (line = bufRead.readLine()) != null) {
                txt.append(line);
                txt.append("\n");
            }
            bufRead.close();
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
        }
        return txt;
    }

    public StringBuffer getText(boolean extensions) {
        StringBuffer s = this.registerConfiguration(extensions);
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            s.append(g.toString(extensions));
        }
        return s;
    }

    public StringBuffer registerConfiguration(boolean extensions) {
        Vector<LayerDesc> layerV = this.P.getLayers();
        if (!extensions) {
            return new StringBuffer();
        }
        StringBuffer s = new StringBuffer();
        if (Math.abs(2.0 - Globals.diameterConnection) > 1.0E-5) {
            s.append("FJC C " + Globals.diameterConnection + "\n");
        }
        Vector<LayerDesc> standardLayers = StandardLayers.createStandardLayers();
        for (int i = 0; i < layerV.size(); ++i) {
            LayerDesc l = layerV.get(i);
            String defaultName = standardLayers.get(i).getDescription();
            if (!l.getModified()) continue;
            int rgb = l.getColor().getRGB();
            float alpha = l.getAlpha();
            s.append("FJC L " + i + " " + rgb + " " + alpha + "\n");
            if (l.getDescription().equals(defaultName)) continue;
            s.append("FJC N " + i + " " + l.getDescription() + "\n");
        }
        if (Math.abs(Globals.lineWidth - 0.5) > 1.0E-5) {
            s.append("FJC A " + Globals.lineWidth + "\n");
        }
        if (Math.abs(Globals.lineWidthCircles - 0.35) > 1.0E-5) {
            s.append("FJC B " + Globals.lineWidthCircles + "\n");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(StringBuffer s, boolean selectNew) {
        boolean hasFCJ = false;
        StringBuffer token = new StringBuffer();
        String macroFont = this.P.getTextFont();
        int macroFontSize = this.P.getTextFontSize();
        GraphicPrimitive g = new PrimitiveLine(macroFont, macroFontSize);
        String[] tokens = new String[512];
        String[] old_tokens = new String[512];
        String[] name = null;
        String[] value = null;
        double newConnectionSize = -1.0;
        double newLineWidth = -1.0;
        double newLineWidthCircles = -1.0;
        int vn = 0;
        int vv = 0;
        int old_j = 0;
        int macro_counter = 0;
        token.ensureCapacity(256);
        ParserActions parserActions = this;
        synchronized (parserActions) {
            Vector<LayerDesc> layerV = this.P.getLayers();
            char c = '\n';
            int lineNum = 1;
            int j = 0;
            token.setLength(0);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                c = s.charAt(i);
                if (c == '\n' || c == '\r' || i == len - 1) {
                    if (i == len - 1 && c != '\n' && c != ' ') {
                        token.append(c);
                    }
                    ++lineNum;
                    tokens[j] = token.toString();
                    if (token.length() == 0) {
                        --j;
                    }
                    try {
                        int l;
                        if (hasFCJ && !tokens[0].equals("FCJ")) {
                            hasFCJ = this.registerPrimitivesWithFCJ(hasFCJ, tokens, g, old_tokens, old_j, selectNew);
                        }
                        if (tokens[0].equals("FCJ")) {
                            if (hasFCJ && old_tokens[0].equals("MC")) {
                                macro_counter = 2;
                                g = new PrimitiveMacro(this.P.getLibrary(), layerV, macroFont, macroFontSize);
                                g.parseTokens(old_tokens, old_j + 1);
                            } else if (hasFCJ && old_tokens[0].equals("LI")) {
                                g = new PrimitiveLine(macroFont, macroFontSize);
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 5 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.P.addPrimitive(g, false, null);
                                }
                            } else if (hasFCJ && old_tokens[0].equals("BE")) {
                                g = new PrimitiveBezier(macroFont, macroFontSize);
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 5 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.P.addPrimitive(g, false, null);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("RV") || old_tokens[0].equals("RP"))) {
                                g = new PrimitiveRectangle(macroFont, macroFontSize);
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.P.addPrimitive(g, false, null);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("EV") || old_tokens[0].equals("EP"))) {
                                g = new PrimitiveOval(macroFont, macroFontSize);
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.P.addPrimitive(g, false, null);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("PV") || old_tokens[0].equals("PP"))) {
                                g = new PrimitivePolygon(macroFont, macroFontSize);
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.P.addPrimitive(g, false, null);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("CV") || old_tokens[0].equals("CP"))) {
                                g = new PrimitiveComplexCurve(macroFont, macroFontSize);
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.P.addPrimitive(g, false, null);
                                }
                            } else if (hasFCJ && old_tokens[0].equals("PL")) {
                                macro_counter = 2;
                            } else if (hasFCJ && old_tokens[0].equals("PA")) {
                                macro_counter = 2;
                            } else if (hasFCJ && old_tokens[0].equals("SA")) {
                                macro_counter = 2;
                            }
                            hasFCJ = false;
                        } else if (tokens[0].equals("FJC")) {
                            LayerDesc ll;
                            if (tokens[1].equals("C")) {
                                newConnectionSize = Double.parseDouble(tokens[2]);
                            } else if (tokens[1].equals("L")) {
                                int layerNum = Integer.parseInt(tokens[2]);
                                if (layerNum >= 0 && layerNum < layerV.size()) {
                                    int rgb = Integer.parseInt(tokens[3]);
                                    float alpha = Float.parseFloat(tokens[4]);
                                    ll = layerV.get(layerNum);
                                    ll.getColor().setRGB(rgb);
                                    ll.setAlpha(alpha);
                                    ll.setModified(true);
                                }
                            } else if (tokens[1].equals("N")) {
                                int layerNum = Integer.parseInt(tokens[2]);
                                if (layerNum >= 0 && layerNum < layerV.size()) {
                                    String lName = "";
                                    StringBuffer temp = new StringBuffer(25);
                                    for (int t = 3; t < j + 1; ++t) {
                                        temp.append(tokens[t]);
                                        temp.append(" ");
                                    }
                                    lName = temp.toString();
                                    ll = layerV.get(layerNum);
                                    ll.setDescription(lName);
                                    ll.setModified(true);
                                }
                            } else if (tokens[1].equals("A")) {
                                newLineWidth = Double.parseDouble(tokens[2]);
                            } else if (tokens[1].equals("B")) {
                                newLineWidthCircles = Double.parseDouble(tokens[2]);
                            }
                        } else if (tokens[0].equals("LI")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (tokens[0].equals("BE")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (tokens[0].equals("MC")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (tokens[0].equals("TE")) {
                            hasFCJ = false;
                            macro_counter = 0;
                            g = new PrimitiveAdvText();
                            g.parseTokens(tokens, j + 1);
                            g.setSelected(selectNew);
                            this.P.addPrimitive(g, false, null);
                        } else if (tokens[0].equals("TY")) {
                            hasFCJ = false;
                            if (macro_counter == 2) {
                                --macro_counter;
                                name = new String[j + 1];
                                for (l = 0; l < j + 1; ++l) {
                                    name[l] = tokens[l];
                                }
                                vn = j;
                            } else if (macro_counter == 1) {
                                value = new String[j + 1];
                                for (l = 0; l < j + 1; ++l) {
                                    value[l] = tokens[l];
                                }
                                vv = j;
                                if (name != null) {
                                    g.setName(name, vn + 1);
                                }
                                g.setValue(value, vv + 1);
                                g.setSelected(selectNew);
                                this.P.addPrimitive(g, false, null);
                                macro_counter = 0;
                            } else {
                                g = new PrimitiveAdvText();
                                g.parseTokens(tokens, j + 1);
                                g.setSelected(selectNew);
                                this.P.addPrimitive(g, false, null);
                            }
                        } else if (tokens[0].equals("PL")) {
                            hasFCJ = true;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            macro_counter = 0;
                            old_j = j;
                            g = new PrimitivePCBLine(macroFont, macroFontSize);
                            g.parseTokens(tokens, j + 1);
                            g.setSelected(selectNew);
                        } else if (tokens[0].equals("PA")) {
                            hasFCJ = true;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            macro_counter = 0;
                            g = new PrimitivePCBPad(macroFont, macroFontSize);
                            old_j = j;
                            g.parseTokens(tokens, j + 1);
                            g.setSelected(selectNew);
                        } else if (tokens[0].equals("SA")) {
                            hasFCJ = true;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            macro_counter = 0;
                            g = new PrimitiveConnection(macroFont, macroFontSize);
                            g.parseTokens(tokens, j + 1);
                            g.setSelected(selectNew);
                        } else if (tokens[0].equals("EV") || tokens[0].equals("EP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (tokens[0].equals("RV") || tokens[0].equals("RP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (tokens[0].equals("PV") || tokens[0].equals("PP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (tokens[0].equals("CV") || tokens[0].equals("CP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        }
                    }
                    catch (IOException E) {
                        System.out.println("Error encountered: " + E.toString());
                        System.out.println("string parsing line: " + lineNum);
                        hasFCJ = false;
                        macro_counter = 0;
                    }
                    catch (NumberFormatException F) {
                        System.out.println("I could not read a number at line: " + lineNum);
                        hasFCJ = false;
                        macro_counter = 0;
                    }
                    j = 0;
                    token.setLength(0);
                    continue;
                }
                if (c == ' ') {
                    tokens[j] = token.toString();
                    if (++j >= 512) {
                        System.out.println("Too much tokens!");
                        System.out.println("string parsing line: " + lineNum);
                    }
                    token.setLength(0);
                    continue;
                }
                token.append(c);
            }
            try {
                this.registerPrimitivesWithFCJ(hasFCJ, tokens, g, old_tokens, old_j, selectNew);
            }
            catch (IOException E) {
                System.out.println("Error encountered: " + E.toString());
                System.out.println("string parsing line: " + lineNum);
            }
            catch (NumberFormatException F) {
                System.out.println("I could not read a number at line: " + lineNum);
            }
            if (newConnectionSize > 0.0) {
                Globals.diameterConnection = newConnectionSize;
            }
            if (newLineWidth > 0.0) {
                Globals.lineWidth = newLineWidth;
            }
            if (newLineWidthCircles > 0.0) {
                Globals.lineWidthCircles = newLineWidthCircles;
            }
            this.P.sortPrimitiveLayers();
        }
    }

    private boolean registerPrimitivesWithFCJ(boolean hasFCJ_t, String[] tokens, GraphicPrimitive gg, String[] old_tokens, int old_j, boolean selectNew) throws IOException {
        String macroFont = this.P.getTextFont();
        int macroFontSize = this.P.getTextFontSize();
        Vector<GraphicPrimitive> primitiveVector = this.P.getPrimitiveVector();
        Vector<LayerDesc> layerV = this.P.getLayers();
        GraphicPrimitive g = gg;
        boolean hasFCJ = hasFCJ_t;
        boolean addPrimitive = false;
        if (hasFCJ && !tokens[0].equals("FCJ")) {
            if (old_tokens[0].equals("MC")) {
                g = new PrimitiveMacro(this.P.getLibrary(), layerV, macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("LI")) {
                g = new PrimitiveLine(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("BE")) {
                g = new PrimitiveBezier(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("RP") || old_tokens[0].equals("RV")) {
                g = new PrimitiveRectangle(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("EP") || old_tokens[0].equals("EV")) {
                g = new PrimitiveOval(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("PP") || old_tokens[0].equals("PV")) {
                g = new PrimitivePolygon(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("PL")) {
                g = new PrimitivePCBLine(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("CP") || old_tokens[0].equals("CV")) {
                g = new PrimitiveComplexCurve(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("PA")) {
                g = new PrimitivePCBPad(macroFont, macroFontSize);
                addPrimitive = true;
            } else if (old_tokens[0].equals("SA")) {
                g = new PrimitiveConnection(macroFont, macroFontSize);
                addPrimitive = true;
            }
        }
        if (addPrimitive) {
            g.parseTokens(old_tokens, old_j + 1);
            g.setSelected(selectNew);
            this.P.addPrimitive(g, false, null);
            hasFCJ = false;
        }
        return hasFCJ;
    }

    public void loadLibraryInJar(URL s, String prefix_s) {
        String prefix = prefix_s;
        if (s == null) {
            if (prefix == null) {
                prefix = "";
            }
            System.out.println("Resource not found! " + prefix);
            return;
        }
        try {
            this.readLibraryBufferedReader(new BufferedReader(new InputStreamReader(s.openStream(), "UTF8")), prefix);
        }
        catch (IOException E) {
            System.out.println("Problems reading library: " + s.toString());
        }
    }

    public void readLibraryFile(String openFileName) throws IOException {
        InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(openFileName), "UTF8");
        BufferedReader bufRead = new BufferedReader(input);
        String prefix = "";
        prefix = Globals.getFileNameOnly(openFileName);
        if ("FCDstdlib".equals(prefix)) {
            prefix = "";
        }
        this.readLibraryBufferedReader(bufRead, prefix);
        bufRead.close();
    }

    public void readLibraryBufferedReader(BufferedReader bufRead, String prefix) throws IOException {
        String macroName = "";
        String longName = "";
        String categoryName = "";
        String libraryName = "";
        String line = "";
        while ((line = bufRead.readLine()) != null) {
            int i;
            StringBuffer temp;
            if ((line = line.trim()).length() <= 1) continue;
            if (line.charAt(0) == '{') {
                categoryName = "";
                temp = new StringBuffer(25);
                for (i = 1; i < line.length() && line.charAt(i) != '}'; ++i) {
                    temp.append(line.charAt(i));
                }
                categoryName = temp.toString().trim();
                if (i != line.length()) continue;
                IOException e = new IOException("Category non terminated with }.");
                throw e;
            }
            if (line.charAt(0) == '[') {
                int j;
                macroName = "";
                longName = "";
                temp = new StringBuffer(25);
                for (i = 1; line.charAt(i) != ' ' && line.charAt(i) != ']' && i < line.length(); ++i) {
                    temp.append(line.charAt(i));
                }
                macroName = temp.toString().trim();
                temp = new StringBuffer(25);
                for (j = i; j < line.length() && line.charAt(j) != ']'; ++j) {
                    temp.append(line.charAt(j));
                }
                longName = temp.toString();
                if (j == line.length()) {
                    IOException e = new IOException("Macro name non terminated with ].");
                    throw e;
                }
                if ("FIDOLIB".equals(macroName)) {
                    libraryName = longName.trim();
                    continue;
                }
                if (!"".equals(prefix)) {
                    macroName = prefix + "." + macroName;
                }
                macroName = macroName.toLowerCase(new Locale("en"));
                this.P.getLibrary().put(macroName, new MacroDesc(macroName, "", "", "", "", prefix));
                continue;
            }
            if ("".equals(macroName)) continue;
            macroName = macroName.toLowerCase(new Locale("en"));
            MacroDesc macroDesc = this.P.getLibrary().get(macroName);
            if (macroDesc == null) {
                return;
            }
            macroDesc.name = longName;
            macroDesc.key = macroName;
            macroDesc.category = categoryName;
            macroDesc.library = libraryName;
            macroDesc.filename = prefix;
            macroDesc.description = macroDesc.description + "\n" + line;
        }
    }

    public void loadLibraryDirectory(String s) {
        File dir = new File(s);
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase(new Locale("en")).endsWith(".fcl");
            }
        });
        if (!dir.exists() || files == null) {
            if (!"".equals(s)) {
                System.out.println("Warning! Library directory is incorrect:");
                System.out.println(s);
            }
            System.out.println("Activated FidoCadJ internal libraries and symbols.");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            try {
                this.readLibraryFile(f.getPath());
                continue;
            }
            catch (IOException E) {
                System.out.println("Problems reading library " + f.getName() + " " + E);
            }
        }
    }
}

