/*
 * Decompiled with CFR 0.152.
 */
package export;

import circuit.controllers.EditorActions;
import circuit.model.DrawingModel;
import circuit.views.Drawing;
import circuit.views.Export;
import export.ExportEPS;
import export.ExportEagle;
import export.ExportFidoCad;
import export.ExportInterface;
import export.ExportPDF;
import export.ExportPGF;
import export.ExportSVG;
import geom.MapCoordinates;
import graphic.DimensionG;
import graphic.PointG;
import graphic.nil.GraphicsNull;
import graphic.swing.ColorSwing;
import graphic.swing.Graphics2DSwing;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import layers.LayerDesc;

public final class ExportGraphic {
    private ExportGraphic() {
    }

    public static void export(File file, DrawingModel P, String format, double unitPerPixel, boolean antiAlias, boolean blackWhite, boolean ext, boolean shiftMin) throws IOException {
        ExportGraphic.exportSizeP(file, P, format, 0, 0, unitPerPixel, false, antiAlias, blackWhite, ext, shiftMin);
    }

    public static void exportSize(File file, DrawingModel P, String format, int width, int height, boolean antiAlias, boolean blackWhite, boolean ext, boolean shiftMin) throws IOException {
        ExportGraphic.exportSizeP(file, P, format, width, height, 1.0, true, antiAlias, blackWhite, ext, shiftMin);
    }

    private static void exportSizeP(File file, DrawingModel P, String format, int width_t, int height_t, double unitPerPixel_t, boolean setSize, boolean antiAlias, boolean blackWhite, boolean ext, boolean shiftMin) throws IOException {
        ExportInterface ef;
        int width = width_t;
        int height = height_t;
        double unitPerPixel = unitPerPixel_t;
        MapCoordinates m = new MapCoordinates();
        EditorActions edt = new EditorActions(P, null);
        edt.setSelectionAll(false);
        PointG org = new PointG(0, 0);
        DimensionG d = ExportGraphic.getImageSize(P, 1.0, true, org);
        if (setSize) {
            d.width += 6;
            d.height += 6;
            unitPerPixel = Math.min((double)width / (double)d.width, (double)height / (double)d.height);
        } else {
            width = (int)((double)(d.width + 6) * unitPerPixel);
            height = (int)((double)(d.height + 6) * unitPerPixel);
        }
        org.x = (int)((double)org.x * unitPerPixel);
        org.y = (int)((double)org.y * unitPerPixel);
        org.x = (int)((double)org.x - 6.0 * unitPerPixel / 2.0);
        org.y = (int)((double)org.y - 6.0 * unitPerPixel / 2.0);
        Vector<LayerDesc> ol = P.getLayers();
        if (blackWhite) {
            Vector<LayerDesc> v = new Vector<LayerDesc>();
            for (int i = 0; i < 16; ++i) {
                v.add(new LayerDesc(new ColorSwing().black(), ol.get(i).getVisible(), "B/W", ol.get(i).getAlpha()));
            }
            P.setLayers(v);
        }
        m.setMagnitudes(unitPerPixel, unitPerPixel);
        if (shiftMin) {
            m.setXCenter(-org.x);
            m.setYCenter(-org.y);
        }
        if ("png".equals(format) || "jpg".equals(format)) {
            try {
                BufferedImage bufferedImage = new BufferedImage(width, height, 1);
                Graphics2D g2d = bufferedImage.createGraphics();
                if (antiAlias) {
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, width, height);
                Drawing drawingAgent = new Drawing(P);
                drawingAgent.draw(new Graphics2DSwing(g2d), m);
                ImageIO.write((RenderedImage)bufferedImage, format, file);
                g2d.dispose();
            }
            catch (OutOfMemoryError E) {
                IOException D = new IOException("Memory Error");
                P.setLayers(ol);
                throw D;
            }
            catch (Exception E) {
                IOException D = new IOException("Size error" + E);
                P.setLayers(ol);
                throw D;
            }
        } else if ("svg".equals(format)) {
            ExportSVG es = new ExportSVG(file);
            new Export(P).exportDrawing(es, true, false, m);
        } else if ("eps".equals(format)) {
            ExportEPS ep = new ExportEPS(file);
            new Export(P).exportDrawing(ep, true, false, m);
        } else if ("pgf".equals(format)) {
            ef = new ExportPGF(file);
            new Export(P).exportDrawing(ef, true, false, m);
        } else if ("pdf".equals(format)) {
            ef = new ExportPDF(file);
            new Export(P).exportDrawing(ef, true, false, m);
        } else if ("scr".equals(format)) {
            ef = new ExportEagle(file);
            new Export(P).exportDrawing(ef, true, false, m);
        } else if ("fcd".equals(format)) {
            ef = new ExportFidoCad(file);
            ((ExportFidoCad)ef).setSplitStandardMacros(false);
            ((ExportFidoCad)ef).setExtensions(ext);
            new Export(P).exportDrawing(ef, true, true, m);
        } else if ("fcda".equals(format)) {
            ef = new ExportFidoCad(file);
            ((ExportFidoCad)ef).setSplitStandardMacros(true);
            ((ExportFidoCad)ef).setExtensions(ext);
            new Export(P).exportDrawing(ef, true, true, m);
        } else {
            IOException E = new IOException("Wrong file format");
            throw E;
        }
        P.setLayers(ol);
    }

    public static DimensionG getImageSize(DrawingModel dm, double unitperpixel, boolean countMin, PointG origin) {
        int height;
        int width;
        MapCoordinates m = new MapCoordinates();
        m.setMagnitudes(unitperpixel, unitperpixel);
        m.setXCenter(0.0);
        m.setYCenter(0.0);
        dm.setChanged(true);
        Drawing drawingAgent = new Drawing(dm);
        drawingAgent.draw(new GraphicsNull(), m);
        dm.setChanged(true);
        if (countMin) {
            width = m.getXMax() - m.getXMin();
            height = m.getYMax() - m.getYMin();
        } else {
            width = m.getXMax();
            height = m.getYMax();
        }
        if (width <= 0 || height <= 0) {
            System.out.println("Warning: Image has a zerosized image");
            width = 100;
            height = 100;
        }
        if (m.getXMax() > m.getXMin() && m.getYMax() > m.getYMin()) {
            origin.x = m.getXMin();
            origin.y = m.getYMin();
        } else {
            origin.x = 0;
            origin.y = 0;
        }
        return new DimensionG(width, height);
    }

    public static PointG getImageOrigin(DrawingModel dm, double unitperpixel) {
        int originy;
        int originx;
        dm.setChanged(true);
        MapCoordinates m = new MapCoordinates();
        m.setMagnitudes(unitperpixel, unitperpixel);
        m.setXCenter(0.0);
        m.setYCenter(0.0);
        Drawing drawingAgent = new Drawing(dm);
        drawingAgent.draw(new GraphicsNull(), m);
        dm.setChanged(true);
        if (m.getXMax() >= m.getXMin() && m.getYMax() >= m.getYMin()) {
            originx = m.getXMin();
            originy = m.getYMin();
        } else {
            originx = 0;
            originy = 0;
        }
        return new PointG(originx, originy);
    }

    public static MapCoordinates calculateZoomToFit(DrawingModel dm, int sizex, int sizey, boolean countMin) {
        double zoomy;
        double zoomx;
        PointG org = new PointG(0, 0);
        MapCoordinates newZoom = new MapCoordinates();
        DimensionG D = ExportGraphic.getImageSize(dm, 1.0, countMin, org);
        double maxsizex = D.width;
        double maxsizey = D.height;
        if (!countMin) {
            org = new PointG(0, 0);
        }
        double z = (zoomx = 1.0 / (maxsizex / (double)sizex)) > (zoomy = 1.0 / (maxsizey / (double)sizey)) ? zoomy : zoomx;
        if ((z = (double)Math.round(z * 100.0) / 100.0) < 0.25) {
            z = 0.25;
        }
        newZoom.setMagnitudes(z, z);
        newZoom.setXCenter((double)org.x * z);
        newZoom.setYCenter((double)org.y * z);
        return newZoom;
    }
}

