/*
 * Decompiled with CFR 0.152.
 */
package globals;

import globals.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import net.sourceforge.fidocadj.FidoMain;
import primitives.MacroDesc;
import undo.UndoActorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibUtils {
    public static Map<String, MacroDesc> getLibrary(Map<String, MacroDesc> m, String libfile) {
        TreeMap<String, MacroDesc> mm = new TreeMap<String, MacroDesc>();
        for (Map.Entry<String, MacroDesc> e : m.entrySet()) {
            String lib;
            MacroDesc md = e.getValue();
            int dotPos = md.key.lastIndexOf(".");
            if (dotPos < 0 || !(lib = md.key.substring(0, dotPos).trim()).equalsIgnoreCase(libfile)) continue;
            mm.put(e.getKey(), md);
        }
        return mm;
    }

    public static String prepareText(Map<String, MacroDesc> m, String name) {
        StringBuffer sb = new StringBuffer();
        String prev = null;
        sb.append("[FIDOLIB " + name + "]\n");
        for (Map.Entry<String, MacroDesc> e : m.entrySet()) {
            MacroDesc md = e.getValue();
            if (prev == null || !prev.equalsIgnoreCase(md.category.trim())) {
                sb.append("{" + md.category + "}\n");
                prev = md.category.toLowerCase(new Locale("en")).trim();
            }
            sb.append("[");
            sb.append(md.key.substring(md.key.lastIndexOf(".") + 1).toUpperCase().trim());
            sb.append(" ");
            sb.append(md.name.trim());
            sb.append("]");
            int u = md.description.codePointAt(0) == 10 ? 1 : 0;
            sb.append("\n");
            sb.append(md.description.substring(u));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void saveToFile(String file, String text) throws FileNotFoundException {
        System.out.println("file: " + file);
        try {
            PrintWriter pw = new PrintWriter(file, "UTF8");
            pw.print(text);
            pw.flush();
            pw.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void save(Map<String, MacroDesc> m, String file, String libname, String prefix) {
        try {
            LibUtils.saveToFile(file + ".fcl", LibUtils.prepareText(LibUtils.getLibrary(m, prefix), libname));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String getLibDir() throws FileNotFoundException {
        Preferences prefs = Preferences.userNodeForPackage(FidoMain.class);
        String s = prefs.get("DIR_LIBS", "");
        if (s == null || s.length() == 0) {
            throw new FileNotFoundException();
        }
        if (!s.endsWith(System.getProperty("file.separator"))) {
            s = s + System.getProperty("file.separator");
        }
        return s;
    }

    public static String getLibPath(String lib) throws FileNotFoundException {
        return LibUtils.getLibDir() + lib.trim();
    }

    public static void deleteLib(String s) throws FileNotFoundException, IOException {
        File f = new File(LibUtils.getLibDir() + s + ".fcl");
        if (!f.delete()) {
            throw new IOException("Can not delete library.");
        }
    }

    public static List<File> getLibs() throws FileNotFoundException {
        File lst = new File(LibUtils.getLibDir());
        ArrayList<File> l = new ArrayList<File>();
        if (!lst.exists()) {
            return null;
        }
        for (File f : lst.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".fcl")) continue;
            l.add(f);
        }
        return l;
    }

    public static boolean isStdLib(MacroDesc tlib) {
        String szlib = tlib.library;
        String szfn = tlib.filename;
        if (szlib == null) {
            return false;
        }
        boolean isStandard = false;
        int dotpos = -1;
        boolean extensions = true;
        dotpos = tlib.key.indexOf(".");
        if (dotpos < 0) {
            isStandard = true;
        } else {
            String library = tlib.key.substring(0, dotpos);
            if (extensions && "pcb".equals(library)) {
                isStandard = true;
            } else if (extensions && "ihram".equals(library)) {
                isStandard = true;
            } else if (extensions && "elettrotecnica".equals(library)) {
                isStandard = true;
            }
        }
        return isStandard;
    }

    public static void renameGroup(Map<String, MacroDesc> libref, String tlib, String tgrp, String newname) throws FileNotFoundException {
        String prefix = "";
        for (MacroDesc md : libref.values()) {
            if (!md.category.equalsIgnoreCase(tgrp) || !md.library.trim().equalsIgnoreCase(tlib.trim())) continue;
            md.category = newname;
            prefix = md.filename;
        }
        if ("".equals(prefix)) {
            return;
        }
        LibUtils.save(libref, LibUtils.getLibPath(tlib), tlib.trim(), prefix);
    }

    public static boolean checkKey(Map<String, MacroDesc> libref, String tlib, String key) {
        for (MacroDesc md : libref.values()) {
            if (!md.library.equalsIgnoreCase(tlib) || !md.key.equalsIgnoreCase(key.trim())) continue;
            return true;
        }
        return key.contains("]");
    }

    public static boolean checkLibrary(String library) {
        return library.contains("]") || library.contains(".") || library.contains("/") || library.contains("\\") || library.contains("~") || library.contains("&") || library.contains(",") || library.contains(";") || library.contains("]") || library.contains("\"");
    }

    public static void renameLib(Map<String, MacroDesc> m, String file, String libname, String libname2) {
        try {
            LibUtils.saveToFile(file + ".fcl", LibUtils.prepareText(LibUtils.getLibrary(m, libname), libname2));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void deleteGroup(Map<String, MacroDesc> m, String tlib, String tgrp) throws FileNotFoundException {
        TreeMap<String, MacroDesc> mm = new TreeMap<String, MacroDesc>();
        mm.putAll(m);
        String prefix = "";
        for (Map.Entry smd : mm.entrySet()) {
            MacroDesc md = (MacroDesc)smd.getValue();
            if (!md.library.trim().equalsIgnoreCase(tlib) || !md.category.equalsIgnoreCase(tgrp)) continue;
            m.remove(md.key);
            prefix = md.filename;
        }
        if ("".equals(prefix)) {
            return;
        }
        LibUtils.save(m, LibUtils.getLibPath(tlib), tlib, prefix);
    }

    public static List<String> enumGroups(Map<String, MacroDesc> m, String prefix) {
        LinkedList<String> lst = new LinkedList<String>();
        for (MacroDesc md : m.values()) {
            if (lst.contains(md.category) || !prefix.trim().equalsIgnoreCase(md.filename.trim())) continue;
            lst.add(md.category);
        }
        return lst;
    }

    public static String getLibName(Map<String, MacroDesc> m, String prefix) {
        LinkedList lst = new LinkedList();
        for (MacroDesc md : m.values()) {
            if (lst.contains(md.category) || !prefix.trim().equalsIgnoreCase(md.filename.trim())) continue;
            return md.library;
        }
        return null;
    }

    public static void saveLibraryState(UndoActorListener ua) throws IOException {
        try {
            File tempDir = File.createTempFile("fidocadj_", "");
            if (!tempDir.delete()) {
                throw new IOException("saveLibraryState: Can not delete temp file.");
            }
            if (!tempDir.mkdir()) {
                throw new IOException("saveLibraryState: Can not create temp directory.");
            }
            String s = LibUtils.getLibDir();
            String d = tempDir.getAbsolutePath();
            File sourceDir = new File(s);
            File destinationDir = new File(d);
            FileUtils.copyDirectoryNonRecursive(sourceDir, destinationDir, "fcl");
            if (ua != null) {
                ua.saveUndoLibrary(d);
            }
        }
        catch (IOException e) {
            System.out.println("Cannot save the library status.");
        }
    }
}

