/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import circuit.CircuitPanel;
import circuit.controllers.ParserActions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JApplet;
import javax.swing.JScrollPane;
import layers.StandardLayers;

public class FidoReadApplet
extends JApplet {
    private static final long serialVersionUID = 10L;
    CircuitPanel CC;
    Color backgroundColor;
    JScrollPane SC;

    public void init() {
        this.backgroundColor = Color.white;
        this.CC = new CircuitPanel(false);
        this.CC.setBackground(this.backgroundColor);
        this.CC.setGridVisibility(false);
        this.SC = new JScrollPane(this.CC);
        this.SC.getVerticalScrollBar().setUnitIncrement(20);
        this.SC.getHorizontalScrollBar().setUnitIncrement(20);
        this.CC.profileTime = false;
        this.CC.antiAlias = true;
        ParserActions pa = this.CC.getParserActions();
        pa.loadLibraryInJar(FidoReadApplet.class.getResource("lib/IHRAM.FCL"), "ihram");
        pa.loadLibraryInJar(FidoReadApplet.class.getResource("lib/FCDstdlib.fcl"), "");
        pa.loadLibraryInJar(FidoReadApplet.class.getResource("lib/PCB_en.fcl"), "pcb");
        this.CC.P.setLayers(StandardLayers.createStandardLayers());
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.SC, "Center");
    }

    public void trace(String c, int zoom) {
        this.CC.getMapCoordinates().setMagnitudes(zoom, zoom);
        this.CC.getParserActions().parseString(new StringBuffer(c));
        this.repaint();
        this.getToolkit().sync();
    }

    public void setAntiAlias(boolean aa) {
        this.CC.antiAlias = aa;
    }

    public void setProfileTime(boolean pp) {
        this.CC.profileTime = pp;
    }

    public void backColor(int color) {
        switch (color) {
            case 0: {
                this.backgroundColor = Color.black;
                break;
            }
            case 1: {
                this.backgroundColor = Color.blue;
                break;
            }
            case 2: {
                this.backgroundColor = Color.green;
                break;
            }
            case 3: {
                this.backgroundColor = Color.cyan.darker();
                break;
            }
            case 4: {
                this.backgroundColor = Color.red;
                break;
            }
            case 5: {
                this.backgroundColor = Color.magenta;
                break;
            }
            case 6: {
                this.backgroundColor = Color.orange;
                break;
            }
            case 7: {
                this.backgroundColor = Color.lightGray;
                break;
            }
            case 8: {
                this.backgroundColor = Color.gray;
                break;
            }
            case 9: {
                this.backgroundColor = new Color(128, 128, 255);
                break;
            }
            case 10: {
                this.backgroundColor = new Color(128, 255, 128);
                break;
            }
            case 11: {
                this.backgroundColor = new Color(128, 255, 255);
                break;
            }
            case 12: {
                this.backgroundColor = new Color(255, 128, 128);
                break;
            }
            case 13: {
                this.backgroundColor = Color.pink;
                break;
            }
            case 14: {
                this.backgroundColor = Color.yellow;
                break;
            }
            default: {
                this.backgroundColor = Color.white;
            }
        }
        this.CC.setBackground(this.backgroundColor);
    }
}

