/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel;

import circuit.model.DrawingModel;
import globals.LibUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.event.AddEvent;
import net.sourceforge.fidocadj.librarymodel.event.KeyChangeEvent;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListener;
import net.sourceforge.fidocadj.librarymodel.event.RemoveEvent;
import net.sourceforge.fidocadj.librarymodel.event.RenameEvent;
import primitives.MacroDesc;
import undo.UndoActorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryModel {
    private final ArrayList<LibraryListener> libraryListeners;
    private final DrawingModel drawingModel;
    private final List<Library> libraries;
    private Map<String, MacroDesc> masterLibrary;
    private UndoActorListener undoActorListener;

    public LibraryModel(DrawingModel drawingModel) {
        this.drawingModel = drawingModel;
        this.libraryListeners = new ArrayList();
        this.libraries = new ArrayList<Library>();
        this.updateLibraries();
    }

    public void addLibraryListener(LibraryListener listener) {
        this.libraryListeners.add(listener);
    }

    public void removeLibraryListener(LibraryListener listener) {
        this.libraryListeners.remove(listener);
    }

    public void remove(Category category) throws IllegalLibraryAccessException {
        if (category == null) {
            return;
        }
        Library parentLibrary = category.getParentLibrary();
        if (parentLibrary.isStdLib()) {
            throw new IllegalLibraryAccessException("A category in standard library can't be removed.");
        }
        parentLibrary.removeCategory(category);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireRemoved(parentLibrary, category);
    }

    public void remove(Library library) throws IllegalLibraryAccessException {
        if (library == null) {
            return;
        }
        if (library.isStdLib()) {
            throw new IllegalLibraryAccessException("A standard library can't be removed.");
        }
        this.libraries.remove(library);
        this.synchronizeMasterLibrary();
        try {
            LibUtils.deleteLib(library.getFileName());
        }
        catch (FileNotFoundException e) {
            System.out.println("library not found:" + library.getFileName());
        }
        catch (IOException e) {
            System.out.println("Exception: " + e);
        }
        this.saveLibraryState();
        this.fireRemoved(null, library);
    }

    public void remove(MacroDesc macro) throws IllegalLibraryAccessException {
        if (macro == null) {
            return;
        }
        Category category = (Category)this.getParentNode(macro);
        if (category == null) {
            throw new IllegalLibraryAccessException("It's a wondering macro.");
        }
        if (category.getParentLibrary().isStdLib()) {
            throw new IllegalLibraryAccessException("A standard library can't be removed.");
        }
        category.removeMacro(macro);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireRemoved(category, macro);
    }

    public void rename(MacroDesc macro, String newName) throws IllegalNameException, IllegalLibraryAccessException {
        if (macro == null) {
            return;
        }
        String oldName = macro.name;
        if (newName == null || newName.length() == 0) {
            throw new IllegalNameException("Name length must not be zero.");
        }
        if (this.isStdLib(macro)) {
            throw new IllegalLibraryAccessException("A macro in standard library can't be renamed.");
        }
        macro.name = newName;
        this.save();
        this.saveLibraryState();
        this.fireRenamed(this.getParentNode(macro), macro, oldName);
    }

    public void rename(Category category, String newName) throws IllegalNameException, IllegalLibraryAccessException {
        String oldName = category.getName();
        if (newName == null || newName.length() == 0) {
            throw new IllegalNameException("Name length must not be zero.");
        }
        if (category.getParentLibrary().isStdLib()) {
            throw new IllegalLibraryAccessException("A category in standard library can't be renamed.");
        }
        if (!Category.isValidName(newName)) {
            throw new IllegalNameException("invalid name");
        }
        category.setName(newName);
        this.synchronizeMacros(category.getParentLibrary());
        this.save();
        this.saveLibraryState();
        this.fireRenamed(this.getParentNode(category), category, oldName);
    }

    public void rename(Library library, String newName) throws IllegalNameException, IllegalLibraryAccessException {
        String oldName = library.getName();
        if (newName == null || newName.length() == 0) {
            throw new IllegalNameException("Name length must not be zero.");
        }
        if (library.isStdLib()) {
            throw new IllegalLibraryAccessException("A standard library can't be renamed.");
        }
        if (!Library.isValidName(newName)) {
            throw new IllegalNameException("invalid name");
        }
        library.setName(newName);
        this.synchronizeMacros(library);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireRenamed(null, library, oldName);
    }

    public void copy(MacroDesc macro, Category destCategory) {
        System.out.println("copy:" + macro + destCategory);
        MacroDesc newMacro = this.copyMacro(macro, destCategory);
        this.synchronizeMacros(destCategory.getParentLibrary());
        this.synchronizeMasterLibrary();
        this.fireAdded(destCategory, newMacro);
    }

    private MacroDesc copyMacro(MacroDesc macro, Category destCategory) {
        int retry;
        if (macro == null || destCategory == null) {
            return null;
        }
        MacroDesc newMacro = this.cloneMacro(macro);
        String newPlainKey = LibraryModel.createRandomMacroKey();
        for (retry = 20; 0 < retry && destCategory.getParentLibrary().containsMacroKey(newPlainKey); --retry) {
        }
        if (retry < 0) {
            throw new RuntimeException("Key generation failed.");
        }
        newMacro.key = LibraryModel.createMacroKey(destCategory.getParentLibrary().getFileName(), newPlainKey);
        destCategory.addMacro(newMacro);
        return newMacro;
    }

    public void copy(Category category, Library destLibrary) {
        if (category == null || destLibrary == null) {
            return;
        }
        Category newCategory = new Category(category.getName(), category.getParentLibrary(), false);
        for (MacroDesc macro : category.getAllMacros()) {
            this.copyMacro(macro, newCategory);
        }
        destLibrary.addCategory(newCategory);
        this.synchronizeMacros(destLibrary);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireAdded(destLibrary, newCategory);
    }

    public void changeKey(MacroDesc macro, String newKey) throws IllegalKeyException, IllegalLibraryAccessException {
        if (macro == null || newKey.length() == 0) {
            throw new IllegalKeyException("Name length must not be zero.");
        }
        if (this.isStdLib(macro)) {
            throw new IllegalLibraryAccessException("A macro in standard library can't be renamed.");
        }
        Category category = (Category)this.getParentNode(macro);
        if (category.getParentLibrary().containsMacroKey(newKey)) {
            throw new IllegalKeyException("New key already exists.");
        }
        String oldKey = LibraryModel.getPlainMacroKey(macro);
        macro.key = LibraryModel.createMacroKey(macro.filename, newKey);
        this.save();
        this.saveLibraryState();
        this.fireKeyChanged(this.getParentNode(macro), macro, oldKey);
    }

    private MacroDesc cloneMacro(MacroDesc macro) {
        MacroDesc newMacro = new MacroDesc(macro.key, macro.name, macro.description, macro.category, macro.library, macro.filename);
        return newMacro;
    }

    public static String getPlainMacroKey(MacroDesc macro) {
        if (macro == null) {
            return null;
        }
        String[] parted = macro.key.split("\\.");
        if (1 < parted.length) {
            return parted[1];
        }
        return parted[0];
    }

    public static String createRandomMacroKey() {
        long t = System.nanoTime();
        long h = 0L;
        int i = 0;
        while (t > 0L) {
            h ^= (t >>= i * 8) & 0xFFL;
            ++i;
        }
        return String.valueOf(h);
    }

    public static String createMacroKey(String fileName, String key) {
        String macroKey = fileName + "." + key;
        return macroKey.toLowerCase(new Locale("en"));
    }

    private void synchronizeMacros(Library library) {
        if (library.isStdLib()) {
            return;
        }
        for (Category category : library.getAllCategories()) {
            for (MacroDesc m : category.getAllMacros()) {
                m.category = category.getName();
                m.library = library.getName();
                m.filename = library.getFileName();
                String plainKey = LibraryModel.getPlainMacroKey(m);
                m.key = LibraryModel.createMacroKey(library.getFileName(), plainKey);
            }
        }
    }

    public void setUndoActorListener(UndoActorListener undoActorListener) {
        this.undoActorListener = undoActorListener;
    }

    private boolean isStdLib(MacroDesc macro) {
        for (Library l : this.getAllLibraries()) {
            if (!l.isStdLib()) continue;
            for (Category c : l.getAllCategories()) {
                for (MacroDesc m : c.getAllMacros()) {
                    if (!macro.equals(m)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void fireAdded(Object parentNode, Object addedNode) {
        for (LibraryListener l : this.libraryListeners) {
            l.libraryNodeAdded(new AddEvent(parentNode, addedNode));
        }
    }

    private void fireRenamed(Object parentNode, Object renamedNode, String oldName) {
        for (LibraryListener l : this.libraryListeners) {
            l.libraryNodeRenamed(new RenameEvent(parentNode, renamedNode, oldName));
        }
    }

    private void fireRemoved(Object parentNode, Object removedNode) {
        for (LibraryListener l : this.libraryListeners) {
            l.libraryNodeRemoved(new RemoveEvent(parentNode, removedNode));
        }
    }

    private void fireKeyChanged(Object parentNode, Object changedNode, String oldKey) {
        for (LibraryListener l : this.libraryListeners) {
            l.libraryNodeKeyChanged(new KeyChangeEvent(parentNode, changedNode, oldKey));
        }
    }

    private Object getParentNode(Object node) {
        for (Library l : this.getAllLibraries()) {
            if (node.equals(l)) {
                return null;
            }
            for (Category c : l.getAllCategories()) {
                if (node.equals(c)) {
                    return l;
                }
                for (MacroDesc m : c.getAllMacros()) {
                    if (!node.equals(m)) continue;
                    return c;
                }
            }
        }
        return null;
    }

    public Map<String, MacroDesc> getAllMacros() {
        return this.masterLibrary;
    }

    public List<Library> getAllLibraries() {
        return this.libraries;
    }

    public void save() {
        for (Library library : this.libraries) {
            try {
                if (library.isStdLib()) continue;
                LibUtils.save(this.masterLibrary, LibUtils.getLibPath(library.getFileName()), library.getName().trim(), library.getFileName());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    public void saveLibraryState() {
        try {
            LibUtils.saveLibraryState(this.undoActorListener);
        }
        catch (IOException e) {
            System.out.println("Exception: " + e);
        }
    }

    public void undoLibrary() {
    }

    public void forceUpdate() {
        this.updateLibraries();
        this.fireChanged();
    }

    private void fireChanged() {
        for (LibraryListener l : this.libraryListeners) {
            l.libraryLoaded();
        }
    }

    private void synchronizeMasterLibrary() {
        this.masterLibrary.clear();
        for (Library library : this.libraries) {
            for (Category category : library.getAllCategories()) {
                for (MacroDesc macro : category.getAllMacros()) {
                    this.masterLibrary.put(macro.key, macro);
                }
            }
        }
    }

    private void updateLibraries() {
        HashMap<String, Library> tmpLibraryMap = new HashMap<String, Library>();
        this.masterLibrary = this.drawingModel.getLibrary();
        this.libraries.clear();
        for (MacroDesc md : this.masterLibrary.values()) {
            Category category;
            Library library;
            this.cleanMacro(md);
            String key = md.filename + "/" + md.library;
            if (tmpLibraryMap.containsKey(key)) {
                library = (Library)tmpLibraryMap.get(key);
            } else {
                library = new Library(md.library, md.filename, LibUtils.isStdLib(md));
                tmpLibraryMap.put(key, library);
                this.libraries.add(library);
            }
            if (library.getCategory(md.category) == null) {
                boolean catIsHidden = "hidden".equals(md.category);
                category = new Category(md.category, library, catIsHidden);
                library.addCategory(category);
            } else {
                category = library.getCategory(md.category);
            }
            category.addMacro(md);
        }
        this.fireChanged();
    }

    private void cleanMacro(MacroDesc macro) {
        macro.name = macro.name.trim();
    }

    public class IllegalKeyException
    extends LibraryException {
        IllegalKeyException(String message) {
            super(message);
        }
    }

    public class IllegalLibraryAccessException
    extends LibraryException {
        IllegalLibraryAccessException(String message) {
            super(message);
        }
    }

    public class IllegalNameException
    extends LibraryException {
        IllegalNameException(String message) {
            super(message);
        }
    }

    public class LibraryException
    extends Exception {
        LibraryException(String message) {
            super(message);
        }
    }
}

